/************************************************************************/
/*	geometry.cc							*/
/*	This file holds functions describing the geometry of the	*/
/*	leaflets.							*/
/************************************************************************/

#include <math.h>
#define	FIRST	1
#define	SECOND	2
#include "constant.h"

double	ZMax(
){
	return sqrt(2*R*(r-g) + alpha*(r-g)*(r-g));
}

double	XMax(
double	z
){
	double	temp;

	temp=alpha*(r*r + z*z - g*g);
	temp+=2*R*g + z*z + r*r + R*R;
	temp=sqrt(temp) - R + alpha*g;
	return temp/(1+alpha);
}

double	xofyandz(
double	y,
double	z
){

	return (alpha*g -R + sqrt(R*R + alpha*y*y + alpha*z*z))/alpha;
}

double	IntersectHeight(
double	y
){
	double	x;
	double	temp;

	x=sqrt(r*r-y*y);
	temp=2*R*(x-g)-y*y;
	temp+=alpha*x*x - 2*alpha*x*g +alpha*g*g;
	return sqrt(temp);
}

double	zofyandcylz(
double	y,
double	cyl_z,
double	tolerance
){
	int	nsteps,i;
	double	z,cylztmp;
	double	zlow,zhigh;
	double	L,offset,h;
	extern double	Length(double(*)(double,double,int),int,double,double,double,int);
	extern double	dxofyandz(double, double, int);
	extern double	IntersectHeight(double);

	h=IntersectHeight(y);
	L=Length(dxofyandz,FIRST,y,0,h,50);
	offset=L-h;
	nsteps=(int) (log(zmax/tolerance)/log(2)) + 1;
	zlow=0;
	zhigh=zmax;
	for(i=0;i<nsteps;i++){
		z=(zhigh+zlow)/2;
		cylztmp=Length(dxofyandz,FIRST,y,0,z,50)-offset;
		if(cylztmp>cyl_z){
			zhigh=z;
		}
		if(cylztmp<cyl_z){
			zlow=z;
		}
		if(cylztmp==cyl_z) return z;
	}
	return z;
}


/************************************************************************/
/*	dxofyandz. This describes the derivative of x wrt y or z	*/
/*	(at constant z or y respectively). This 		 	*/
/*	function also takes an argument called const_arg, which is	*/
/*	FIRST if the first argument is to be held constant for the	*/
/*	derivative, and SECOND if the second argument is to be held	*/
/*	constant. For example						*/
/*		dxofyandz(y,z,FIRST)					*/
/*	should return							*/
/*		d       |						*/
/*		- x(y,z)|						*/
/*	       dz       |y						*/
/*	and								*/
/*		dxofyandz(y,z,SECOND)					*/
/*	returns								*/
/*		d       |						*/
/*		- x(y,z)|						*/
/*	       dy       |z						*/
/************************************************************************/
double	dxofyandz(
double	y,
double	z,
int	const_arg
){
	if(const_arg==FIRST){
		return z/sqrt(R*R + alpha*(y*y + z*z));
	}
	if(const_arg==SECOND){
		return y/sqrt(R*R + alpha*(y*y + z*z));
	}
}
