/* created Februari 9th, 1990 by Nick
   last modification July 30th, 1990, by Chris

   Purpose: This program is used to digitize a set of points on the screen
   and to store their location and their pixel value in a file. The location
   stored in the file is the X and Y coordinates expressed in the coordinate
   system of PC-SCOPE (i.e. the origin is located at the upper left corner of
   the selected quadrant). The angle and the absolute positions of the
   reference markers on the shore are added at the end of the file.
*/
#include <stdio.h>
#include <ctype.h>
#include <graph.h>
#include <process.h>
#include <bios.h>

main(argc,argv)
int argc;
char *argv[];
{FILE *fopen(), *file1, *file2, *file3, *file4;
 char fname[30], text[80];
 int xstrt, ystrt, num;
 int bstat, state, quad, hpos, vpos, pxval;
 int xc, yc, tmp, n, g;
 int des[4], line[21], col[21];
 int i, j, x0, y0, x1, y1, x2, y2, x4, y4, x6, y6, c, l, option;
 float xpos, ypos, som, pix, ang, lef, rig;
 struct rccoord rc;
 char ch, *rep;

/* Read the numbers of the image
   First number corresponds to image on quadrant 0, second number to
   quadrant 1, .... If the number is 0, no image is stored on corresponding
   quadrant. */

 for(i=0;i<4;i++)
  sscanf(argv[i+1],"%d",&des[i]);

/* The file to store the results. Its name contains a letter, at the user's
   choice, the number of the image and the extension DAT. */

 _outtext("enter first letter of the file: ");
 scanf("%c",&ch);
 _outtext("\n");

 for(quad=0;quad<4;quad++)
  {num=0;
   if(des[quad])
      {sprintf(text,"Processing quadrant %d\n",quad);
       _outtext(text);
       selfrplan(quad);
       sprintf(fname,"C:\\%1c%3.3d.DAT",ch,des[quad]);
       sprintf(text,"Saving data in file %s\n",fname);
       _outtext(text);

/* The file is opened to write */
       file3=fopen(fname,"w");
       fprintf(file3,"NNN XXX YYY GGG\n");

/* Option 1: automatic process: OK if the second, forth and sixth previous
   files exist. Option 0: manual process. */

       option=1;
       sprintf(fname,"C:\\%1c%3.3d.DAT",ch,(des[quad]-6));
       if ((file4=fopen(fname,"r"))==NULL) option=0;
       else for(j=0;j<4;j++) fscanf(file4,"%s",text);
       sprintf(fname,"C:\\%1c%3.3d.DAT",ch,(des[quad]-4));
       if ((file1=fopen(fname,"r"))==NULL) option=0;
       else for(j=0;j<4;j++) fscanf(file1,"%s",text);
       sprintf(fname,"C:\\%1c%3.3d.DAT",ch,(des[quad]-2));
       if ((file2=fopen(fname,"r"))==NULL) option=0;
       else for(j=0;j<4;j++) fscanf(file2,"%s",text);
       if(option)
         _outtext("Automatic option enabled.\n");
       else
         _outtext("Digitize the points with the mouse...\n");
       xstrt=255;
       ystrt=255;
       for(;;)
        {switch(option)
          {case 0: man:

/* The user selects a window surrounding the point of interest */
           _outtext("upper left corner of the window.\n");

/* bstat corresponds to the button of the mouse that has been hit */
           m_getpos(&bstat,&x1,&y1,xstrt,ystrt,255,-1,-1,"");

/* Wait until the user release the button */
           state=1;
           while(state) m_status(&state,&hpos,&vpos);
           if(bstat==2) goto next;
           _outtext("lower right corner of the window.\n");
           x2=(x1+10);
           y2=(y1+10);
           if(x2>=1024) x2=1023;
           if(y2>=1024) y2=1023;
           if(x1<512 && x2>=512) x2=511;
           if(y1<512 && y2>=512) y2=511;
           m_getcadre(&bstat,&x2,&y2,&x1,&y1,255,-1,-1,"");

/* Wait until the user releases the button */
           state=1;
           while(state) m_status(&state,&hpos,&vpos);
           if(bstat==2) goto next;
           break;

/* Automatic process: the previous files are scanned for the previous
   positions of the same point. */
           case 1: aut:
           fscanf(file4,"%d",&n);
           if(fscanf(file4,"%d",&x6)!=1)
             {option=0;
              goto man;
             }
           if(fscanf(file4,"%d",&y6)!=1)
             {option=0;
              goto man;
             }
           fscanf(file4,"%d",&g);
           sprintf(text,"Pos. 6 im. before: X=%d, Y=Md\n,x6,y6);
           _outtext(text);

           fscanf(file1,"%d",&n);
           if(fscanf(file1,"%d",&x4)!=1)
             {option=0;
              goto man;
             }
           if(fscanf(file1,"%d",&y4)!=1)
             {option=0;
              goto man;
             }
           fscanf(file1,"%d",&g);
           sprintf(text,"Pos. 4 im. before: X=%d, Y=Md\n,x4,y4);
           _outtext(text);

           fscanf(file2,"%d",&n);
           if(fscanf(file2,"%d",&x2)!=1)
             {option=0;
              goto man;
             }
           if(fscanf(file2,"%d",&y2)!=1)
             {option=0;
              goto man;
             }
           fscanf(file2,"%d",&g);
           sprintf(text,"Pos. 2 im. before: X=%d, Y=Md\n,x2,y2);
           _outtext(text);

/* Automatic process: extrapolation of the new position from the previous
   ones. */
           x0=3*x2-3*x4+x6+(quad/2)*512;
           y0=3*y2-3*y4+y6+(quad%2)*512;
           x1=x0-5;
           y1=y0-5;
           x2=x0+5;
           y2=y0+5;
          }
          xpos=0.0;
          ypos=0.0;
          som=0.0;
          if(x2>x1)
            {tmp=x1;
             x1=x2;
             x2=tmp;
            }
          if(y2>y1)
            {tmp=y1;
             y1=y2;
             y2=tmp;
            }

/* Calculation of the centre of white */
          for(c=x1;c<=x2;c++)
            {for(l=y1;l<=y2;l++)
              {getpixel(&pxval,c,l);
               if(pxval<40) pxval=0;
               pix=(float)pxval/255.0;
               xpos+=(float)(c-x1)*pix*pix;
               ypos+=(float)(l-y1)*pix*pix;
               som+=pix*pix;
              }
            }
          if(som<0.00001) som=1.0:
          xpos=xpos/som;
          ypos=ypos/som;
          xc=x1+(int)xpos;
          yc=y1+(int)ypos;
          getpixel(&pxval,xc,yc);

/* Drawing of the cross to indicate the calculated position. The original
   pixel values are stored in memory in case of recalculation. */
          xincynh();
          getlnseg(line,xc-5,yc,11);
          xinhyinc();
          getlnseg(col,xc,yc-5,11);
          vecteur(xc-5,yc,xc+5,yc,128);
          vecteur(xc,yc-5,xc,yc+5,128);
          _outtext("Are you satisfied? (Y or N) ");
          scanf("%1s",rep);
          _outtext("\n");
          if(strcmpi(rep,"N")==0)
            {xincyinh();
             putlnseg(line,xc-5,yc,11);
             xinhyinc();
             putlnseg(col,xc,yc-5,11);
             goto man;
            }

/* Writing the results in the file */
          num++;
          xstrt=xc;
          ystrt=yc;
          xc=xc%512;
          yc=yc%512;
          ypos=(float)x1+xpos;
          ypos=(float)y1+ypos;
          fprintf(file3,"%3d %f %f %3d\n",num,xpos,ypos,pxval);
          sprintf(text,"Point %d: X=%4d  Y=%4d  g=%3d\n",num,xc,yc,pxval);
          _outtext(text);
         }
         next:

/* End of the file: angle of the camera and position of the markers on the
   shore are added before closing. */
         _outtext("angle: ");
         scanf("%f",&ang);
         _outtext("\n");
         fprintf(file3,"%.3f\n",ang);
         sprintf(text,"angle=%.3f\n",ang);
         _outtext(text);

         _outtext("left marker: ");
         scanf("%f",&lef);
         _outtext("\n");
         fprintf(file3,"%.3f\n",lef);
         sprintf(text,"angle=%.3f\n",lef);
         _outtext(text);

         _outtext("right marker: ");
         scanf("%f",&rig);
         _outtext("\n");
         fprintf(file3,"%.3f\n",rig);
         sprintf(text,"angle=%.3f\n",rig);
         _outtext(text);

         fclose(file1);
         fclose(file2);
         fclose(file3);
         fclose(file3);
        }
      }
 end
 fclose(file1);
 fclose(file2);
 fclose(file3);
 fclose(file4);
 }
