*        PROGRAM newergo.for
***********************************************************************
*       WARNING!!!
*       THIS PROGRAM IS TREATING ONLY 250 FILES.
**************************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION CH(NINT),T(NINT),XX(NINT,1),YY(NINT,1)

	CHARACTER*24 NAME,DUMMY,NNAME1,NNAME2,NAME1,NAME2,NNAME3
	CHARACTER*24 NNAME10,NNAME11
	CHARACTER*1  ANSWER

***********************************************************************
*       EACH FILE CONTAINS 11 POINTS
*       1-FIRST POINT OF HORIZ. SCALE
*       2-SECOND POINT OF HORIZ. SCALE  AND GEN. REF.
*       3-HEAD
*       4-NECK
*       5-SHOULDER
*       6-ELBOW
*       7-WRIST
*       8-HIP
*       9-KNEE
*       10-ANKLE
*       11-BACK
************************************************************
*PRESENTATION OF THE PROGRAM
***********************************************************
      WRITE(6,10)
10    FORMAT(////////' This program is concerned with
     1  image analysis in rowing.'
     1 //' The data files must be available in the VAX'
     1 //' Possibilities: '//
     2 5x,'- correction of the aberrations'/
     2 5x,'- calculations of linear velocities and accelerations'/
     2 5x,'- calculations of angular velocities and accelerations'////
*     3 5x,'- display of graphics'/
*     3 5x,'- statistics'/
*     4 5x,'- production of charts of data and results'///
     5 ' PRESS ANY KEY TO CONTINUE '$)
       READ(5,20)DUMMY
20     FORMAT(A)
****************************************************************
* ACCESS TO THE DATA
***************************************************************
	write (6,25)
25      format(/' have you got a data file? [Y/N] '$)
	read(5,20)answer
	if (answer.eq.'y'.or.answer.eq.'Y') go to 48

***** NO FILE READY

* EACH FILE, PREPARED WITH PCSCOPE, CONTAINS THE INFORMATION OF ONE
* IMAGE. ITS NAME HAS BEEN BUILT AS FOLLOWED :
* A LETTER, 3 DIGITS CORRESPONDING TO THE IMAGE NUMBER, .DAT
* THEY HAVE BEEN TRANSFERRED TO THE VAX.
* THEY MUST BE READ CONSECUTIVELY, BEGINNING WITH THE FIRST ONE OF THE TEST.

26      write(6,27)
27      format (/' how many files do you want to read?'/)
	read (5,*)k

	IF(K.GT.250)THEN                ! LIMITATION OF THE PROGRAM
		WRITE(6,28)
28              FORMAT(/' NO MORE THAN 250 FILES PLEASE!')
		GO TO 26
	ENDIF

	npts = 1
	write (6,29)
29      format (/' Enter first filename : '$)
	read (5,20) name
	if (name .EQ. ' ') call exit

* READING THE LETTER AND THE FIRST NUMBER

	i_index = index (name,' ')
	do ii = 1, i_index-1
		if (name(ii:).ge.char(48) .and.
     1                   name(ii:ii).le.char(57)) go to 30
	enddo
	ii = i_index-1
30      read (name(ii:ii+2), '(i3)') inum

* READING THE CONSECUTIVE FILES UP TO THE K ONE
	do nf = inum, inum + k - 1
	   write (name(ii:ii+2), '(i3)') nf
	   do i = ii,ii+2
		if (name(i:i) .eq. ' ') name(i:i) = char(48)
	   enddo
	   type *, '                  reading ',name
	   open (unit=1, file=name, status='old')
	   read (1,20) dummy            
	   do i=1,11
		read (1, *) nr(i), xr(i), yr(i), gr(i)

		x(npts) = xr(i)              ! NR REFERS TO THE ORDER NUMBER
		y(npts) = yr(i)              ! GR REFERS TO THE POINT INTENSITY
		npts = npts + 1              ! WE DO NOT USE THIS INFORMATION
	   enddo
	   close (unit = 1)

	enddo
	npts = npts - 1

	WRITE(6,*)NPTS


*** GIVE A NAME TO THE COMMON FILE OF DATA

	WRITE(6,42)
42      FORMAT(/' FILENAME [N FOLLOWED BY THE SAME LETTER AS SOURCE]:'$)
	READ(5,20)NAME1

* WRITING THE DATA IN A SINGLE FILE

	OPEN(UNIT=2,FILE=NAME1,STATUS='NEW')
	WRITE(2,*) NPTS
	DO I=1,NPTS
		WRITE(2,*) X(I), Y(I)
	ENDDO
	CLOSE (UNIT=2)
	GO TO 52                        ! TO CONTINUE

****SEE THE FILE WHICH IS READY

48      WRITE(6,51)
51      FORMAT(/' ENTER FILENAME :'$)
	READ(5,20)NAME1

* GIVES OTHER EXTENSIONS TO SAME FILENAME

52      KK =INDEX(NAME1,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NAME1, ' ')-1
		NAME2(1:KK) = NAME1(1:KK)
		NAME2(KK+1:KK+4) = '.ABE'
	ELSE
		NAME2(1:KK)=NAME1(1:KK)
		NAME2(KK+1:KK+3)='ABE'
	ENDIF

* ABERRATIONS
**************
	WRITE(6,55)
55      FORMAT(/' CORRECTION FOR ABERRATIONS? [Y/N]')
	READ(5,20)ANSWER
	IF(ANSWER.EQ.'Y'.OR.ANSWER.EQ.'y')THEN
		CALL ABERR(NAME1,NAME2)
	ENDIF

	WRITE(6,75)
75      FORMAT(/' PREPARATION OF SEPARATED FILES?[Y/N]')
	READ(5,20)ANSWER
	IF(ANSWER.EQ.'N'.OR.ANSWER.EQ.'n')GO TO 76

* CALCULATION OF THE CONVERSION FACTORS

	OPEN(UNIT=4,FILE=NAME2,STATUS='OLD')
		READ(4,*)NPTS
		DO I=1,NPTS
			READ(4,*)X(I),Y(I)
		ENDDO
	CLOSE(UNIT=4)

	M=0
	DO I=1,NPTS,11
		M=M+1
		CH(M)=SQRT(((X(I+1)-X(I))**2)+((Y(I+1)-Y(I))**2))
	ENDDO
	MM=M

	SUMH=0.
	DO M=1,MM
		SUMH=SUMH+CH(M)
	ENDDO
	M=M-1
	HCF=SUMH/M
	WRITE(6,*)M,HCF
	HCF=.5/HCF
	WRITE(6,*)M,HCF

* SEPARATE INFORMATION OF THE DIFFERENT POINTS AND SMOOTHING
************************************************************
	call SEPARATE(NAME2,HCF)

* CALCULATION OF THE CENTER OF GRAVITY
**************************************
76      WRITE(6,77)
77      FORMAT(/' CALCULATION OF POSITION OF C OF G?[Y/N]')
	READ(5,20)ANSWER
	IF(ANSWER.EQ.'N'.OR.ANSWER.EQ.'n')GO TO 80
	CALL GRAV


* LINEAR VELOCITY AND ACCELERATION
**********************************
80      nname1='                            '
	nname10='                           '
	nname11='                           '   
	write(6,85)
85      format(/' Calculation of velocities and accelerations?[y/n]')
	read(5,20)answer
	if (answer.eq.'y'.or.answer.eq.'Y')then
89              write(6,90)
90              format (/'                     MENU     '//,
     1          '            HEAD           3 '/,
     2          '     TO BE CHOOSEN FIRST TO DETERMINE THE
     2               LIMITS OF NORMALISATION '/,
     2          '            NECK           4 '/,
     7          '            SHOULDER       5'/,
     8          '            ELBOW          6 '/,
     9          '            WRIST          7'/,
     4          '            HIP           8 '/,
     5          '            KNEE          9'/,
     6          '            ANKLE         10 '/,
     5          '            DORSAL        11' /,
     3          '            CENTER OF GRAV        12'/)
	read (5,*)J
	nname1 = '                        '
	if (j.eq.3)nname1= 'head'
	if (j.eq.4)nname1= 'neck'
	if (j.eq.5)nname1= 'shoulder'
	if (j.eq.6)nname1= 'elbow'
	if (j.eq.7)nname1= 'wrist'
	if (j.eq.8)nname1= 'hip'
	if (j.eq.9)nname1='knee'
	if (j.eq.10)nname1='ankle'
	if (j.eq.11)nname1='dorsal'
	if (j.eq.12)nname1='CENTER'

	JJ=J
	open (unit=10,file=nname1,status='old')
	read(10,*)kr
	do i=1,KR
		read(10,*)x(i),y(i)
		XX(I,1)=X(I)
		YY(I,1)=Y(I)
	enddo
	close (unit=10)

	KK =INDEX(NNAME1,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NNAME1, ' ')-1
		NNAME10(1:KK) = NNAME1(1:KK)
		NNAME11(1:KK) = NNAME1(1:KK)
		NNAME10(KK+1:KK+4) = '.DAX'
		NNAME11(KK+1:KK+4) = '.DAY'
	ELSE
		NNAME10(1:KK)=NNAME1(1:KK)
		NNAME11(1:KK)=NNAME1(1:KK)
		NNAME10(KK+1:KK+3)='DAX'
		NNAME11(KK+1:KK+3)='DAY'
	ENDIF

***** PREPARE DATA FILE FOR PLOT
	OPEN (UNIT=1,FILE=NNAME10,STATUS='NEW')
	OPEN (UNIT=2,FILE=NNAME11,STATUS='NEW')
	WRITE(1,*)KR,1
	WRITE(2,*)KR,1
	DO I=1,KR
		T(I)=I*.04
		WRITE(1,*)T(I)
		WRITE(2,*)T(I)
	ENDDO
	WRITE(1,*)(XX(I,1),I=1,KR)
	WRITE(2,*)(YY(I,1),I=1,KR)
	CLOSE(UNIT=1)
	CLOSE(UNIT=2)
	
	CALL VELACC(Jj)

* NORMALISATION PROCESS
***********************
	WRITE(6,112)
112     FORMAT(/' DO YOU WANT TO NORMALISE THE DATA?[Y/N]')
	READ(5,20)ANSWER
	IF(ANSWER.EQ.'Y'.OR.ANSWER.EQ.'y')THEN
		CALL NORMAL(JJ)
	ENDIF
		go to 80
	else
		go to 120
	endif
************************************************************
* ANGLES, ANGULAR VELOCITIES AND ACCELERATIONS.
*************************************************************
120     WRITE(6,130)
130     FORMAT(/' ANGLE MEASUREMENTS?[Y/N]'$)
	READ(5,20)ANSWER
	IF(ANSWER.EQ.'Y'.OR.ANSWER.EQ.'y')THEN
139             WRITE(6,140)
140             FORMAT(/'         MENU  ',///,
     1          5X,'- NECK    TYPE 1 ',///,
     1          5X,'- BACK    TYPE 2 ',///,
     1          5X,'- HIP     TYPE 3 ',///,
     1          5X,'- KNEE    TYPE 4 ',///,
     1          ' IF YOU WANT TO EXIT TYPE 5')
		READ(5,*)KAN
		IF(KAN.EQ.5)GO TO 150
		CALL ANGLE(KAN)
		GO TO 139
	ELSE
		CONTINUE
	ENDIF
150     CONTINUE
	END


**********************************************************

	SUBROUTINE ABERR(NPTS,NAME1,NAME2)

**************************************************************
C TABLE A  CONTAINS THE X VALUES OF THE GRID READ ON THE SCREEN
C TABLE B               Y
C TABLE XX               THEORETICAL X VALUES OF THE GRID
C TABLE YY                           Y

	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)


	CHARACTER*24 NAME1,NAME2,GRIDNAM

	DIMENSION A(20,20),B(20,20),XX(20,20),YY(20,20)
	dimension RX(NVAL),RY(NVAL)

	WRITE(6,5)
5       FORMAT(/' ENTER NAME OF THE GRID DATA')
	READ(5,6)GRIDNAM
6       FORMAT(A)

	OPEN(UNIT=2,FILE=NAME1,STATUS='OLD')
	READ(2,*)NPTS
	READ(2,*)(X(I),Y(I),I=1,NPTS)
	CLOSE(UNIT=2)

	OPEN (UNIT=1,FILE=GRIDNAM,STATUS='OLD')
	READ(1,*)KK,JJ
	DO J=1,JJ
		DO K=1,KK
		READ(1,*)A(K,J),B(K,J),XX(K,J),YY(K,J)
		ENDDO
	ENDDO
	CLOSE(UNIT=1)   

	DO I=1,NPTS

C FIND THE SUPERIOR LIMIT FOR X AND Y.

	K=1
	DO J=1,JJ
		IF(Y(I).LE.B(K,J)) GO TO 10
	ENDDO
	JL=JJ
	GO TO 15
10      JL=J

15      J=1
	DO K=1,KK
		IF (X(I).LE.A(K,J))GO TO 20
	ENDDO
	IC = KK
	GO TO 25
20      IC=K


C CHECK THE VALUES ( BECAUSE WE WORK IN THE FIRST COLUMN AND LINE)

25      IF (IC.EQ.KK.AND.JL.EQ.JJ)GO TO 100
	IF (JL.EQ.JJ)GO TO 30
	IF (Y(I).GT.B(IC,JL)) THEN
		JL=JL+1
		GO TO 30
	ELSE
		GO TO 30
	ENDIF
30      IF (IC.EQ.KK) GO TO 100
	IF (X(I).GT.A(IC,JL)) THEN
		IC=IC+1         
		GO TO 25
	ELSE
		GO TO 100
	ENDIF


C BORDER CASES (TO OBTAIN A SQUARE WITH DEFINED CORNERS FOR INTERPOLATION)

100     IF (IC.EQ.1) IC=IC+1
	IF (JL.EQ.1) JL=JL+1

	
C DELIMITATE THE FOUR POINTS FOR INTERPOLATION

	A4 = A(IC,JL)
	B4 = B(IC,JL)
	XX4 = XX(IC,JL)
	YY4 = YY(IC,JL)
	A3 = A(IC-1,JL)
	B3 = B(IC-1,JL)
	XX3 = XX(IC-1,JL)
	YY3 = YY(IC-1,JL)
	A2 = A(IC,JL-1)
	B2 = B(IC,JL-1)
	XX2 = XX(IC,JL-1)
	YY2 = YY(IC,JL-1)
	A1 = A(IC-1,JL-1)
	B1 = B(IC-1,JL-1)
	XX1 = XX(IC-1,JL-1)
	YY1 = YY(IC-1,JL-1)


C CALCULATION IN PARTS FOR X VALUE

	DA1=A2-A1
	DA2=A3-A1
	DA3=A4-A1
	IF(DA1.EQ.0.)DA1=0.00001
	IF(DA2.EQ.0.)DA2=0.00001
	IF(DA3.EQ.0.)DA3=0.00001

	TA1 = (A1*B1-A2*B2)/DA1
	TA2 = (A1*B1-A3*B3)/DA2
	TA3 = (A1*B1-A4*B4)/DA3

	FA1 = (B1-B2)/DA1
	FA2 = (B1-B3)/DA2
	FA3 = (B1-B4)/DA3

	DFA1=FA2-FA1
	DFA2=FA3-FA1
	IF(DFA1.EQ.0.)DFA1=0.00001
	IF(DFA2.EQ.0.)DFA2=0.00001
	
	VA1 = (XX2-XX1)/DA1
	VA2 = (XX3-XX1)/DA2
	VA3 = (XX4-XX1)/DA3

	PA1 = ((VA1-VA2)/DFA1)-((VA1-VA3)/DFA2)
	PA2 = ((TA1-TA3)/DFA2)-((TA1-TA2)/DFA1)
	IF (PA2.EQ.0.) PA2=.00001
	DA = PA1 / PA2
	
	CA = ((VA1-VA3)/DFA2) + (DA *(TA1-TA3)/DFA2)
	
	BA = VA3 + CA*FA3 + DA*TA3

	AA = XX1 - A1*BA - B1*CA - A1*B1*DA

	RX(I) = AA + BA*X(I) + CA*Y(I) + DA*X(I)*Y(I)

C FOR THE Y VALUE


	VB1 = (YY2-YY1)/DA1
	VB2 = (YY3-YY1)/DA2
	VB3 = (YY4-YY1)/DA3

	PB1 = ((VB1-VB2)/DFA1)-((VB1-VB3)/DFA2)
	DB = PB1 / PA2
	
	CB = ((VB1-VB3)/DFA2) + (DB *(TA1-TA3)/DFA2)
	
	BB = VB3 + CB*FA3 + DB*TA3

	AB = YY1 - A1*BB - B1*CB - A1*B1*DB

	RY(I) = AB + BB*X(I) + CB*Y(I)+ DB*X(I)*Y(I)

	ENDDO

	DO I=1,NPTS
		X(I)=RX(I)
		Y(I)=RY(I)
	ENDDO
	
	OPEN (UNIT=3,FILE=NAME2,STATUS='NEW')
	WRITE(3,*)NPTS
	DO I=1,NPTS
		WRITE(3,*)X(I),Y(I)
	ENDDO
	CLOSE(UNIT=3)
	RETURN
	END

**********************************************************************

	SUBROUTINE SEPARATE(NAME2,hcf)

********************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION F(NVAL),GG(NVAL),FN(NVAL),GN(NVAL)
	CHARACTER*24 NNAME1,NAME2,NNAMER

	write(6,1)name2
1       FORMAT(A)
	WRITE(6,*)HCF


* SEPARATING THE FILES CONCERNING EACH JOINT

	do j=2,11
		WRITE(6,*)J
		NNAMER='                      '
		nname1= '                        '
		if (j.eq.2)nname1= 'ERGO'
		if (j.eq.3)nname1= 'head'
		if (j.eq.4)nname1= 'neck'
		if (j.eq.5)nname1= 'shoulder'
		if (j.eq.6)nname1= 'elbow'
		if (j.eq.7)nname1= 'wrist'
		if (j.eq.8)nname1= 'hip'
		if (j.eq.9)nname1='knee'
		if (j.eq.10)nname1='ankle'
		if (j.eq.11)nname1='dorsal'

	KK =INDEX(NNAME1,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NNAME1, ' ')-1
		NNAMER(1:KK) = NNAME1(1:KK)
		NNAMER(KK+1:KK+4) = '.RAW'
	ELSE
		NNAMER(1:KK)=NNAME1(1:KK)
		NNAMER(KK+1:KK+3)='RAW'
	ENDIF

* READING THE CORRECTED DATA FILE

	OPEN(UNIT=4,FILE=NAME2,STATUS='OLD')
	READ(4,*)NPTS
	DO I=1,NPTS
		READ(4,*)X(I),Y(I)
	ENDDO
	CLOSE(UNIT=4)

	WARN=0.
	OPEN (UNIT=11,FILE=NNAMER,STATUS='NEW')
		KR=NPTS/11
		WRITE(11,*)KR
		DO I=J,NPTS,11
			IF(X(I).LE.50..OR.ABS(Y(I)).LE.50.)THEN
				WARN=1.
				WRITE(6,*)I,X(I),Y(I)
			ELSE
				CONTINUE
			ENDIF
			WRITE(11,*)X(I),Y(I)
		ENDDO
	CLOSE(UNIT=11)

	IF(WARN.EQ.1.)THEN
		WRITE(6,*)WARN
		CALL SPLINE(J,KR)
	ELSE
		CONTINUE
	ENDIF
	ENDDO

	DO J=3,11
		NNAMER='                      '
		nname1= '                        '
		if (j.eq.3)nname1= 'head'
		if (j.eq.4)nname1= 'neck'
		if (j.eq.5)nname1= 'shoulder'
		if (j.eq.6)nname1= 'elbow'
		if (j.eq.7)nname1= 'wrist'
		if (j.eq.8)nname1= 'hip'
		if (j.eq.9)nname1='knee'
		if (j.eq.10)nname1='ankle'
		if (j.eq.11)nname1='dorsal'

	KK =INDEX(NNAME1,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NNAME1, ' ')-1
		NNAMER(1:KK) = NNAME1(1:KK)
		NNAMER(KK+1:KK+4) = '.RAW'
	ELSE
		NNAMER(1:KK)=NNAME1(1:KK)
		NNAMER(KK+1:KK+3)='RAW'
	ENDIF

*RELATIVE DISPLACEMENT
	OPEN(UNIT=10,FILE=NNAMER,STATUS='OLD')
	READ(10,*)KR
	READ(10,*)(X(I),Y(I),I=1,KR)
	CLOSE(UNIT=10)

	OPEN(UNIT=11,FILE='ERGO.RAW',STATUS='OLD')
	READ(11,*)KR
	READ(11,*)(XA(I),YA(I),I=1,KR)
	CLOSE(UNIT=11)
			OPEN(UNIT=1,FILE=nname1,STATUS='NEW')
			OPEN(UNIT=13,FILE=NNAMER,STATUS='NEW')
				WRITE(1,*)KR
				WRITE(13,*)KR
				DO I=1,KR
					X(I)=X(I)-XA(I)
					Y(I)=YA(I)-Y(I)
					WRITE(13,*)X(I),Y(I)
					X(I)=X(I)*HCF
					Y(I)=(Y(I)*HCF)*.7
					WRITE(1,*)X(I),Y(I)
				ENDDO
			CLOSE(UNIT=1)
			CLOSE(UNIT=13)

* SMOOTHING

	OPEN (UNIT=2,FILE=nname1,STATUS='OLD')
		READ(2,*)KR
		DO I=1,KR
			READ(2,*)F(I),GG(I)
		ENDDO
	CLOSE(UNIT=2)

	KD=KR-4
	OPEN (UNIT=8,FILE=NNAME1,STATUS='NEW')
	WRITE(8,*)KD
	TYPE *,KD
	DO I=3,KR-2
		FN(I)=(.5*F(I-2)+F(I-1)+F(I)+F(I+1)+.5*F(I+2))/4.
		GN(I)=(.5*GG(I-2)+GG(I-1)+GG(I)+GG(I+1)+.5*GG(I+2))/4.
		WRITE(8,*)FN(I),GN(I)
	ENDDO
	CLOSE(UNIT=8)

100     continue
	ENDDO
	RETURN
	END

*************************************************************************
	SUBROUTINE SPLINE (J,KR)
************************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	CHARACTER*24 NNAMER,NAMEX,NAMEY

	DIMENSION K(NINT),XX(NINT),KNEW(NINT),XNEW(NINT),YNEW(NINT),
     1  YY(NINT),IXD(NINT),YD(NINT),B(NINT),DD(NINT),D(NINT),
     1  DS(NINT),XR(NINT),XD(NINT)

	NNAMER='                         '
	NAMEX='                         '
	NAMEY='                         '
	if (j.eq.3)NnameR= 'head.raw'
	if (j.eq.4)NnameR= 'neck.raw'
	if (j.eq.5)NnameR= 'shoulder.raw'
	if (j.eq.6)NnameR= 'elbow.raw'
	if (j.eq.7)NnameR= 'wrist.raw'
	if (j.eq.8)NnameR= 'hip.raw'
	if (j.eq.9)NnameR= 'knee.raw'
	if (j.eq.10)NnameR= 'ankle.raw'
	if (j.eq.11)Nnamer='dorsal.raw'
	
	KK =INDEX(NNAMER,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NNAMER, ' ')-1
		NAMEX(1:KK) = NNAMER(1:KK)
		NAMEY(1:KK) = NNAMER(1:KK)
		NAMEX(KK+1:KK+4) = '.PSX'
		NAMEY(KK+1:KK+4) = '.PSY'
	ELSE
		NAMEX(1:KK)=NNAMER(1:KK)
		NAMEY(1:KK)=NNAMER(1:KK)
		NAMEX(KK+1:KK+3)='PSX'
		NAMEY(KK+1:KK+3)='PSY'
	ENDIF

	OPEN(UNIT=12,FILE=NNAMER,STATUS='OLD')
	READ(12,*)KR
	READ(12,*)(X(I),Y(I),I=1,KR)
	CLOSE(UNIT=12)

	KK=0
	DO I=1,KR
		IF(X(I).GT.20..AND.Y(I).GT.20.)THEN
			KK=KK+1
			K(KK)=I
			XX(KK)=X(I)
			YY(KK)=Y(I)
			WRITE(6,*)I,KK
		ELSE
			CONTINUE
		ENDIF
	ENDDO

	OPEN(UNIT=1,FILE='TEMP',STATUS='NEW')
	WRITE(1,*)KK,1
	WRITE(1,*)(K(I),I=1,KK)
	WRITE(1,*)(XX(I),I=1,KK)
	CLOSE(UNIT=1)
*
* NNEW=NUMBER OF NEW POINTS [KR]
* DT=NEW CONTANT SPACING [1]
*

	KNEW(1)=1
	NR=KK
	DO II=1,NR
		IXD(II)=K(II)
		XD(II)=XX(II)
		YD(II)=YY(II)
	ENDDO

	DO I=1,KR-1
		CALL PENDE(IXD,XD,0.,0.,B,0,0,NR)
		CALL FLESS(IXD,XD,B,KNEW(I),XNEW(I),YP,YP2,NR)
		KNEW(I+1)=KNEW(I)+1
	ENDDO
	KNEW(KR)=K(KK)
	XNEW(KR)=XX(KK)

	KNEW(1)=1
	DO I=1,KR-1
		TYPE*,' WE ARE IN SPLINE NUMBER : '
		WRITE(6,*)I
		CALL PENDE(IXD,YD,0.,0.,B,0,0,NR)
		CALL FLESS(IXD,YD,B,KNEW(I),YNEW(I),YP,YP2,NR)
		KNEW(I+1)=KNEW(I)+1
	ENDDO
	KNEW(KR)=K(KK)
	YNEW(KR)=YY(KK)
*
* PLOTTING OF THE NEW DATA
*
	OPEN (UNIT=11,FILE=NAMEX,STATUS='NEW')
	WRITE(11,*)KR,1
	WRITE(11,*)(KNEW(I),I=1,KR)
	WRITE(11,*)(XNEW(I),I=1,KR)
	CLOSE(UNIT=11)

	OPEN (UNIT=10,FILE=NAMEY,STATUS='NEW')
	WRITE(10,*)KR,1
	WRITE(10,*)(KNEW(I),I=1,KR)
	WRITE(10,*)(YNEW(I),I=1,KR)
	CLOSE(UNIT=10)

	OPEN(UNIT=13,FILE=NNAMER,STATUS='NEW')
	WRITE(13,*)KR
	WRITE(13,*)(XNEW(I),YNEW(I),I=1,KR)
	CLOSE(UNIT=13)
	RETURN
	END


**********************************************************************
	SUBROUTINE PENDE(IXD,YD,PIN,PFI,B,IF1,IF2,NR)
**********************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION IXD(NINT),YD(NINT),B(NINT),DD(NINT),D(NINT),DS(NINT)
	IDK=IXD(2)-IXD(1)
	PI=IDK/6.
	YY=YD(2)-YD(1)
	EI=YY/IDK
	IF(IF1.NE.1)GO TO 21
	B(1)=EI-PIN
	D(1)=2.*PI
	DD(1)=PI
	GO TO 22
21      B(1)=0.
	D(1)=1.
	DD(1)=0.
22      CONTINUE
	NN=NR-1
	DO K=2,NN
		KP=K+1
		IDK=IXD(KP)-IXD(K)
		PIP=IDK/6.
		YY=YD(KP)-YD(K)
		EIP=YY/IDK
		DS(K)=PI
		DD(K)=PIP
		D(K)=2.*(PI+PIP)
		B(K)=EIP-EI
		PI=PIP
		EI=EIP
	ENDDO
	IF (IF2.NE.1)GO TO 23
	NN=NR
	B(NR)=PFI-EI
	D(NR)=2.*PI
	DS(NR)=PI
	GO TO 24
23      B(NR)=0.
	D(NR)=1.
	DS(NR)=0.
24      CONTINUE
*
* SYSTEM SOLUTION
*
	DO I=2,NN
		A1=DS(I)
		D(I)=D(I)/A1
		DD(I)=DD(I)/A1
		B(I)=B(I)/A1
	ENDDO
	MN=NN-1
	DO I=1,MN
		II=I+1
		A1=D(I)
		DD(I)=DD(I)/A1
		B(I)=B(I)/A1
		D(II)=D(II)-DD(I)
		B(II)=B(II)-B(I)
	ENDDO
	A1=D(NN)
	DD(NN)=DD(NN)/A1
	B(NN)=B(NN)/A1
	NN=NR-1
	DO I=1,NN
		L=NR-1
		B(L)=B(L)-DD(L)*B(L+1)
	ENDDO
	RETURN
	END

****************************************************************************
	SUBROUTINE FLESS(IXD,YD,B,IXN,YI,YP,YP2,NR)
****************************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION IXD(NINT),YD(NINT),B(NINT)

	K=1
	IDK=IXD(2)-IXD(1)
	EI=(YD(2)-YD(1))/IDK
	DB=(B(2)-B(1))*IDK/6.
	IF(IXN-IXD(1))1,2,3
2       YI=YD(K)
	YP=-B(K)*IDK/2.+EI-DB
	YP2=B(K)
	GO TO 10
3       K=K+1
	IF(IXN-IXD(K))4,4,5
5       IF(K.GT.NR)GO TO 1
	IDK=IXD(K+1)-IXD(K)
	EI=(YD(K+1)-YD(K))/IDK
	DB=(B(K+1)-B(K))*IDK/6.
	GO TO 3
4       IXP=IXD(K)-IXN
	IXM=IXN-IXD(K-1)
	YI=B(K-1)*(IXP**3)/(6.*IDK)+B(K)*(IXM**3)/(6.*IDK)+IXP*
     1  (YD(K-1)/IDK-B(K-1)*IDK/6.)+IXM*(YD(K)/IDK-B(K)*IDK/6.)
	YP=-B(K-1)*(IXP**2)/(2.*IDK)+B(K)*(IXM**2)/(2.*IDK)+EI-DB
	YP2=B(K-1)*IXP/IDK+B(K)*IXM/IDK
	GO TO 10
1       WRITE(6,100)
100     FORMAT(1X,' X EXTERNAL TO THE INTERPOLATION INTERVAL')
10      RETURN
	END

***************************************************************
	SUBROUTINE GRAV

***************************************************************

	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT)
	COMMON  THETA(NINT),YA(NINT),COSI(NINT)

	DIMENSION XD(NINT,1),YD(NINT,1),XHE(NINT),YHE(NINT),XS(NINT),
     1     YS(NINT),XE(NINT),YE(NINT),XW(NINT),YW(NINT),XH(NINT),
     1     YH(NINT),XK(NINT),YK(NINT),XAN(NINT),YAN(NINT),
     1     T(NINT),XP(NINT),YP(NINT)

	CHARACTER*24 NNAME1

	do j=3,10
		WRITE(6,*)J
		nname1= '                        '
		if (j.eq.3)nname1= 'head'
		if (j.eq.4)GO TO 300
		if (j.eq.5)nname1= 'shoulder'
		if (j.eq.6)nname1= 'elbow'
		if (j.eq.7)nname1= 'wrist'
		if (j.eq.8)nname1= 'hip'
		if (j.eq.9)nname1='knee'
		if (j.eq.10)nname1='ankle'

		OPEN (UNIT=1,FILE=NNAME1,STATUS='OLD')
		READ(1,*)K
		DO I=1,K
			READ(1,*)XP(I),YP(I)
		ENDDO
		CLOSE(UNIT=1)

		IF(J.EQ.3)THEN
			DO I=1,K
				XHE(I)=XP(I)
				YHE(I)=YP(I)
			ENDDO
		ENDIF

		IF(J.EQ.5)THEN
			DO I=1,K
				XS(I)=XP(I)
				YS(I)=YP(I)
			ENDDO
		ENDIF
		IF(J.EQ.6)THEN
			DO I=1,K
				XE(I)=XP(I)
				YE(I)=YP(I)
			ENDDO
		ENDIF
		IF(J.EQ.7)THEN
			DO I=1,K
				XW(I)=XP(I)
				YW(I)=YP(I)
			ENDDO
		ENDIF
		IF(J.EQ.8)THEN
			DO I=1,K
				XH(I)=XP(I)
				YH(I)=YP(I)
			ENDDO
		ENDIF
		IF(J.EQ.9)THEN
			DO I=1,K
				XK(I)=XP(I)
				YK(I)=YP(I)
			ENDDO
		ENDIF
		IF(J.EQ.10)THEN
			DO I=1,K
				XAN(I)=XP(I)
				YAN(I)=YP(I)
			ENDDO
		ENDIF           
		
300     CONTINUE
	ENDDO
**************************************************************
* SEGMENTAL WEIGHTS TO PREPARE THE CALCULATION OF THE BODY
* CENTER OF GRAVITY
**************************************************************
		WHE =.073               
		WTR =.507               
		WAR =.052               
		WFA =.046               
		WTH =.206               
		WSH =.086              
		WFO =.030               

	DO I=1,K
*       head moments
		xhe(I) = xhe(I)*whe
		yhe(I) = yhe(I)*whe
*       trunk center of gravity and moments
		xtr= xs(I) - ( xs(I) - xh(I) ) * .38
		xtr= xtr* wtr
		ytr= ys(I) - ( ys(I) - yh(I) ) * .38
		ytr= ytr* wtr
*       arm center of gravity and moments
		xar= xs(I) + ( xe(I) - xs(I) ) * .513
		xar= xar* war
		yar= ys(I) + ( ye(I) - ys(I) ) * .513
		yar= yar* war
*       forearm center of gravity and moments
		xfa= xe(i) + ( xw(I) - xe(I) ) * .73
		xfa= xfa* wfa
		yfa= ye(I) + ( yw(I) - ye(I) ) * .73
		yfa= yfa* wfa
*       thigh center of gravity and moments
		xth= xh(i) + ( xk(I) - xh(I) ) * .372
		xth= xth* wth
		yth= yh(I) + ( yk(I) - yh(I) ) * .372
		yth= yth* wth
*       shank center of gravity and moments
		xsh= xk(I) + ( xan(I) - xk(I) ) * .371
		xsh= xsh* wsh
		ysh= yk(I) + ( yan(I) - yk(I) ) * .371
		ysh= ysh* wsh
*       foot center of gravity and moments
		xfo= xan(i) + abs(( xan(I) - xk(I) ) * .27)
		xfo= xfo* wfo
		yfo= yan(I) + abs(( yan(I) - yk(I) ) * .27)
		yfo= yfo* wfo

* position of the center of gravity of the body
		xd(I,1) = xhe(I)+ xtr+ xar+ xfa+ xth+ xsh+ xfo
		yd(I,1) = yhe(I)+ ytr+ yar+ yfa+ yth+ ysh+ yfo
	ENDDO

* WRITING THE DATA CONCERNING THE CENTER OF GRAVITY

	OPEN ( UNIT=100, FILE = 'centerx', STATUS = 'NEW')
	WRITE(100,*)K,1
	DO I=1,K
		T(I) = .04 * I
		WRITE(100,*) T(I)
	ENDDO
	DO I=1,K
		WRITE(100,*) XD(I,1)
	ENDDO
	CLOSE (UNIT=100)
	
	OPEN (UNIT=20, FILE = 'centery', STATUS = 'NEW')
	WRITE (20,*)K,1
	DO I=1,K
		T(I) = .04 * I
		WRITE(20,*) T(I)
	ENDDO
	DO I=1,K
		WRITE(20,*) YD(I,1)
	ENDDO
	CLOSE (UNIT=20)

	DO I=1,K
		XP(I)=XD(I,1)
		YP(I)=YD(I,1)
	ENDDO

	OPEN (UNIT=4,FILE='CENTER',STATUS='NEW')
	WRITE(4,*)K
	DO I=1,K
		WRITE(4,*)XP(I),YP(I)
	ENDDO
	CLOSE(UNIT=4)
	RETURN
	END


************************************************************************
	SUBROUTINE VELACC(J)
**********************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION XT(NINT,3),YT(NINT,3),XX(NINT,3),YY(NINT,3)

	character*24 NNAME1,NNAME2,NNAME3,NNAME4,NNAME5,NNAME6,
	character*24 nnamea,NNAME7,NNAME8,NNAME9,NNAME10,NNAME11

	h=.04
	mspan=7
	kd=4

	nname1 = '                        '
	if (j.eq.3)nname1= 'head'
	if (j.eq.4)nname1= 'neck'
	if (j.eq.5)nname1= 'shoulder'
	if (j.eq.6)nname1= 'elbow'
	if (j.eq.7)nname1= 'wrist'
	if (j.eq.8)nname1= 'hip'
	if (j.eq.9)nname1='knee'
	if (j.eq.10)nname1='ankle'
	if (j.eq.11)nname1='dorsal'
	if (j.eq.12)nname1='CENTER'

	JNAME=J
	NNAME2='                        '
	NNAME3='                        '
	NNAME4='                        '
	NNAME5='                        '
	NNAME6='                        '
	NNAME7='                        '
	NNAME8='                        '
	NNAME9='                        '
	NNAME10='                        '
	NNAME11='                        '
	KK =INDEX(NNAME1,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NNAME1, ' ')-1
		nnamea(1:kk) = nname1(1:kk)
		NNAME2(1:KK) = NNAME1(1:KK)
		NNAME3(1:KK) = NNAME1(1:KK)
		NNAME4(1:KK) = NNAME1(1:KK)
		NNAME5(1:KK) = NNAME1(1:KK)
		nnamea(KK+1:KK+4) = '.dat'
		NNAME2(KK+1:KK+4) = '.RVX'
		NNAME3(KK+1:KK+4) = '.RVY'
		NNAME4(KK+1:KK+4) = '.RAX'
		NNAME5(KK+1:KK+4) = '.RAY'
	ELSE
		nnamea(1:kk)=nnamea(1:kk)
		NNAME2(1:KK)=NNAME1(1:KK)
		NNAME3(1:KK)=NNAME1(1:KK)
		NNAME4(1:KK) = NNAME1(1:KK)
		NNAME5(1:KK) = NNAME1(1:KK)
		nnamea(kk+1:KK+3)='dat'
		NNAME2(KK+1:KK+3)='rvx'
		NNAME3(KK+1:KK+3)='RVY'
		NNAME4(KK+1:KK+3)='RAX'
		NNAME5(KK+1:KK+3)='RAY'
	ENDIF
	open(unit=10,file=nnamea,status='old')
	read(10,*)kr
	do i=1,kr
		read(10,*)x(i),y(i)
	enddo
	close(unit=10)

	L= MSPAN/2
	M= L+1

*       FOURTH DEGREE

	DO J=M,KR-L
			VX(J)=(X(J-3)-3*(X(J-2))-3*(X(J-1))+3*(X(J+1))+
     1           3*(X(J+2))-X(J+3))/(12.*H)
			VY(J)=(Y(J-3)-3*(Y(J-2))-3*(Y(J-1))+3*(Y(J+1))+
     1           3*(Y(J+2))-Y(J+3))/(12.*H)
			AX(J)=(5*(X(J-2))-X(J-3)+X(J-1)-10*(X(J))+
     1           X(J+1)+5*(X(J+2))-X(J+3))/(12.*H*H)
			AY(J)=(5*(Y(J-2))-Y(J-3)+Y(J-1)-10*(Y(J))+
     1           Y(J+1)+5*(Y(J+2))-Y(J+3))/(12.*H*H)
	 ENDDO

1000    open (unit=2,file='temp1.dat',status='new')
	NPTS=KR-L-M+1
	WRITE(2,*)NPTS
	DO J=M,KR-L
		WRITE(2,*)VX(J),VY(J)
	ENDDO
	CLOSE (UNIT=2)

	OPEN(UNIT=3,FILE='temp2.dat',STATUS='NEW')
	WRITE(3,*)NPTS
	DO J=M,KR-L
		WRITE(3,*)AX(J),AY(J)
	ENDDO
	CLOSE(UNIT=3)
	
	open (unit=8,file=NNAME2,status='new')
	open (unit=9,file=NNAME3,status='new')
	kd=NPTS-4
	write(8,*)kd,1
	write(9,*)kd,1
	DO I=3,NPTS-2
		X(I)=(I+2)*.04
		WRITE(8,*)X(I)
		WRITE(9,*)X(I)
	ENDDO
	do i=3,NPTS-2
		xx(i,1)=(.5*Vx(i-2)+Vx(i-1)+Vx(i)+Vx(i+1)+.5*Vx(i+2))/4.
		yy(i,1)=(.5*Vy(i-2)+Vy(i-1)+Vy(i)+Vy(i+1)+.5*Vy(i+2))/4.
		write(8,*)Xx(i,1)
		write(9,*)Yy(i,1)
	enddo
	close(unit=8)
	close(unit=9)
	open (unit=7,file=NNAME4,status='new')
	open (unit=10,file=NNAME5,status='new')
	kd=npts-4
	write(7,*)kd,1
	write(10,*)kd,1
	DO I=3,NPTS-2
		X(I)=(I+2)*.04
		WRITE(7,*)X(I)
		WRITE(10,*)X(I)
	ENDDO
	DO J=3,NPTS-2
		xx(i,1)=(.5*ax(i-2)+ax(i-1)+ax(i)+ax(i+1)+.5*ax(i+2))/4.
		yy(i,1)=(.5*ay(i-2)+ay(i-1)+ay(i)+ay(i+1)+.5*ay(i+2))/4.
		write(7,*)Xx(j,1)
		write(10,*)Yy(j,1)
	ENDDO
	close(unit=7)
	close(unit=10)
	GO TO 1020
1020    RETURN
	END


*******************************************************************

	SUBROUTINE NORMAL(NNAME1,JJ)

****************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

* Program to normalise in time
	DIMENSION B(1000),RVX(1000),RVY(1000),
     1    RAX(1000),RAY(1000),RXTOT(10),RXRECOV(10),RXSTROKE(10),
     1    TCSXMAX(10),TCXMIN(10),TCXMAX(10),TT(1000,10),TXRECOV(10),
     1    TCVXMIN(10),TCVXMAX(10),TCAXMIN(10),TCAXMAX(10),TCYMAX(10),
     1    TVXMIN(10),TVXMAX(10),TAXMIN(10),TAXMAX(10),TCYMIN(10),
     1    TXMIN(10),TXMAX(10),TYMIN(10),TYMAX(10),TXSTROKE(10),
     1    XTMAX(10),XTMIN(10),XSMAX(10),XAMPL(10),XX(1000,10),
     1    YYMIN(10),YYMAX(10),YAMPL(10),YY(1000,10),
     1    VXMIN(10),VXMAX(10),VVX(1000,10),VVY(1000,10),VXAMPL(10),
     1    AAX(1000,10),AAY(1000,10),AXMAX(10),AXMIN(10),AXAMPL(10)

	CHARACTER*24 NNAME1,NNAME4,NNAME5

	NNAME4='                        '
	NNAME5='                        '
	KK =INDEX(NNAME1,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NNAME1, ' ')-1
		NNAME4(1:KK) = NNAME1(1:KK)
		NNAME5(1:KK) = NNAME1(1:KK)
		NNAME4(KK+1:KK+4) = '.SVE'
		NNAME5(KK+1:KK+4) = '.SAC'
	ELSE
		NNAME4(1:KK) = NNAME1(1:KK)
		NNAME5(1:KK) = NNAME1(1:KK)
		NNAME4(KK+1:KK+3)='SVE'
		NNAME5(KK+1:KK+3)='SAC'
	ENDIF

	WRITE(6,1)NNAME1,JJ
1       FORMAT(1X,A,3X,I3)

* READING OF THE DATA FILE (DISPLACEMENT)
	OPEN(UNIT=1,FILE=NNAME1,STATUS='OLD')
	READ(1,*)NPTS
	DO I=1,NPTS
		READ(1,*)X(I),Y(I)
	ENDDO
	CLOSE(UNIT=1)

* READING OF THE DATA FILE (VELOCITY)
	OPEN(UNIT=2,FILE=NNAME4,STATUS='OLD')
	READ(2,*)NV
	DO K=1,NV
		READ(2,*)RVX(K),RVY(K)
		I=K+5
		VX(I)=RVX(K)
		VY(I)=RVY(K)
	ENDDO
	CLOSE(UNIT=2)

* READING OF THE DATA FILE (ACCELERATION)
	OPEN(UNIT=2,FILE=NNAME5,STATUS='OLD')
	READ(2,*)NA
	DO K=1,NA
		READ(2,*)RAX(K),RAY(K)
		I=K+8
		AX(I)=RAX(K)
		AY(I)=RAY(K)
	ENDDO
	CLOSE(UNIT=2)

* FIND THE AMPLITUDE OF THE MOVEMENT IN X
	XMIN=X(1)
	XMAX=X(1)
	DO I=2,NPTS
		IF(X(I).LT.XMIN)XMIN=X(I)
		IF(X(I).GT.XMAX)XMAX=X(I)
	ENDDO
	WRITE(6,*)XMIN,XMAX

* CALCULATE A RECOGNISABLE POINT
	TTEST=XMAX-((XMAX-XMIN)/2.)
*       TEST=XMIN+TTEST
	WRITE(6,*)TTEST

* VARIATION OF THE DATA AROUND ZERO     
*       DO I=1, NPTS
*               X(I)=X(I)-TEST
*       ENDDO

* FIND THE AMPLITUDE OF THE MOVEMENT IN Y
	YMIN=Y(1)
	YMAX=Y(1)
	DO I=2,NPTS
		IF(Y(I).LT.YMIN)YMIN=Y(I)
		IF(Y(I).GT.YMAX)YMAX=Y(I)
	ENDDO
	WRITE(6,*)YMIN,YMAX

* CALCULATE A RECOGNISABLE POINT
	YTEST=YMAX-((YMAX-YMIN)/2.)
*       TYEST=YMIN+YTEST
	WRITE(6,*)YTEST

* VARIATION OF THE DATA AROUND ZERO     
*       DO I=1, NPTS
*               Y(I)=Y(I)-TYEST
*       ENDDO

	IF(JJ.EQ.3)GO TO 500

	WARN=0.
	WRITE(6,*)WARN,JJ
	WRITE(6,10)
10      FORMAT(/' HOW MANY CYCLES DO YOU WANT TO NORMALISE?')
	READ(5,*)MM
	WRITE(6,20)
20      FORMAT(/' ENTER THE VALUE TO BEGIN THE NORMALISATION')
	READ(5,*)IZERO
	M=1
21      WRITE(6,22)
22      FORMAT(/' ENTER THE INTERMEDIATE VALUE')
	READ(5,*)IINT
25      WRITE(6,30)
30      FORMAT(/' ENTER THE VALUE TO STOP THE NORMALISATION')
	READ(5,*)IEND
	CALL CYCLE(NNAME1,JJ,WARN,IZERO,IINT,IEND,AA,BB,CC,MM,M,NPTS)
	IF (WARN.EQ.-1.)GO TO 1000
	GO TO 21
	
* FIND THE LIMIT FOR NORMALISATION
500     WARN=1.
	INUM=1
	NSTART=2
	M=1
	MM=1
	WRITE(6,*)WARN,M,MM

* FIRST POINT IS THE MORE POSITIVE (CATCH)
510     DO I=NSTART,NPTS-8
		INUM=INUM+1
		IF(X(I).GT.TTEST)THEN
			IF(X(I).LT.X(I-1))THEN
				INUM=I-1
				XTMAX(M)=X(I-1)
				DO K=I,I+10
					IF(X(K).GT.XTMAX(M))THEN
						XTMAX(M)=X(K)
						INUM=K
					ENDIF
				ENDDO
				GO TO 520
			ENDIF
		ENDIF
	ENDDO
	WRITE(6,512)
512     FORMAT(/' END OF FILE')
	GO TO 800
520     IZERO=INUM
	TCXMAX(M)=FLOAT(INUM)
	WRITE(6,*)IZERO,X(IZERO)

* SECOND POINT IS THE MOST NEGATIVE (END OF STROKE)
	DO I=IZERO+1,NPTS-8
		INUM=INUM+1
		IF(X(I).LT.TTEST)THEN
			IF(X(I).GT.X(I-1))THEN
				INUM=I-1
				XTMIN(M)=X(I-1)
				DO K=I,I+10
					IF(X(K).LT.XTMIN(M))THEN
						XTMIN(M)=X(K)
						INUM=K
					ENDIF
				ENDDO
				GO TO 530
			ENDIF
		ENDIF
	ENDDO
	WRITE(6,512)
	GO TO 800
530     IINT=INUM
	TCXMIN(M)=FLOAT(INUM)
	WRITE(6,*)IINT,X(IINT)

* END OF THE NORMALISATION (NEW CATCH)
	DO I=IINT+1,NPTS-8
		INUM=INUM+1
		IF(X(I).GT.TTEST)THEN
			IF(X(I).LT.X(I-1))THEN
				INUM=I-1
				XSMAX(M)=X(I-1)
				DO K=I,I+10
					IF(X(K).GT.XSMAX(M))THEN
						XSMAX(M)=X(K)
						INUM=K
					ENDIF
				ENDDO
				GO TO 540
			ENDIF
		ENDIF
	ENDDO
	WRITE(6,512)
	GO TO 800
540     IEND=INUM
	TCSXMAX(M)=FLOAT(INUM)
	WRITE(6,*)IEND,X(IEND)

	IF(XTMAX(M).GT.XSMAX(M))THEN
		TXMAX(M)=0.0
	ELSE
		XTMAX(M)=XSMAX(M)
		TXMAX(M)=1.0
		TCXMAX(M)=TCSXMAX(M)
	ENDIF
	AA=XTMAX(M)     ! MAXIMAL VALUE OF X IN THE CYCLE
	BB=TXMAX(M)     !0. IF MAX VALUE IS THE FIRST PEAK OR 1. FOR SECOND PEAK
	CC=TCXMAX(M)    ! REAL TIME OF THE MAXIMAL VALUE IN SECONDS

	CALL CYCLE(NNAME1,JJ,WARN,IZERO,IINT,IEND,AA,BB,CC,MM,M,NPTS)
		WRITE(6,*)WARN
		IF(WARN.EQ.-1.)GO TO 1000
		NSTART=IEND
		INUM=IEND-1
		GO TO 510
800     WARN=2.
	CALL CYCLE(NNAME1,JJ,WARN,IZERO,IINT,IEND,AA,BB,CC,MM,M,NPTS)
1000    CONTINUE
	RETURN
	END

*********************************************************************

	SUBROUTINE CYCLE(NNAME1,JJ,WARN,IZERO,IINT,IEND,AA,BB,CC,
     1     MM,M,NPTS)

**********************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION B(1000),ITOT(10),RVX(1000),RVY(1000),
     1    RAX(1000),RAY(1000),RXTOT(10),RXRECOV(10),RXSTROKE(10),
     1    TCSXMAX(10),TCXMIN(10),TCXMAX(10),TT(1000,10),TXRECOV(10),
     1    TCVXMIN(10),TCVXMAX(10),TCAXMIN(10),TCAXMAX(10),TCYMAX(10),
     1    TVXMIN(10),TVXMAX(10),TAXMIN(10),TAXMAX(10),TCYMIN(10),
     1    TXMIN(10),TXMAX(10),TYMIN(10),TYMAX(10),TXSTROKE(10),
     1    XTMAX(10),XTMIN(10),XSMAX(10),XAMPL(10),XX(1000,10),
     1    YYMIN(10),YYMAX(10),YAMPL(10),YY(1000,10),
     1    VXMIN(10),VXMAX(10),VVX(1000,10),VVY(1000,10),VXAMPL(10),
     1    AAX(1000,10),AAY(1000,10),AXMAX(10),AXMIN(10),AXAMPL(10)

	CHARACTER*24 NNAME1,NNAME6,NNAME7,NNAME8,
     1    NNAME9,NNAME10,NNAME11,NNAME12

	NNAME6='                        '
	NNAME7='                        '
	NNAME8='                        '
	NNAME9='                        '
	NNAME10='                       '
	NNAME11='                       '
	NNAME12='                       '
	KK =INDEX(NNAME1,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NNAME1, ' ')-1
		NNAME6(1:KK) = NNAME1(1:KK)
		NNAME7(1:KK) = NNAME1(1:KK)
		NNAME8(1:KK) = NNAME1(1:KK)
		NNAME9(1:KK) = NNAME1(1:KK)
		NNAME10(1:KK) = NNAME1(1:KK)
		NNAME11(1:KK) = NNAME1(1:KK)
		NNAME12(1:KK) = NNAME1(1:KK)
		NNAME6(KK+1:KK+4) = '.NDX'
		NNAME7(KK+1:KK+4) = '.NDY'
		NNAME8(KK+1:KK+4) = '.NVX'
		NNAME9(KK+1:KK+4) = '.NVY'
		NNAME10(KK+1:KK+4) = '.NAX'
		NNAME11(KK+1:KK+4) = '.NAY'
		NNAME12(KK+1:KK+4) = '.OUT'
	ELSE
		NNAME6(1:KK) = NNAME1(1:KK)
		NNAME7(1:KK) = NNAME1(1:KK)
		NNAME8(1:KK) = NNAME1(1:KK)
		NNAME9(1:KK) = NNAME1(1:KK)
		NNAME10(1:KK) = NNAME1(1:KK)
		NNAME11(1:KK) = NNAME1(1:KK)
		NNAME12(1:KK) = NNAME1(1:KK)
		NNAME6(KK+1:KK+3)='NDX'
		NNAME7(KK+1:KK+3)='NDY'
		NNAME8(KK+1:KK+3)='NVX'
		NNAME9(KK+1:KK+3)='NVY'
		NNAME10(KK+1:KK+3)='NAX'
		NNAME11(KK+1:KK+3)='NAY'
		NNAME12(KK+1:KK+3)='OUT'
	ENDIF

	WRITE(6,*)IZERO,IINT,IEND
	WRITE(6,*)WARN,JJ

	ITOT(M)=IEND-IZERO

	IF(WARN.EQ.2.)GO TO 100

* FOR X WITHIN THE SELECTED CYCLE, FIND THE MAX,MIN AND THE CORRESPONDING TIME
* FOR Y WITHIN THE SELECTED CYCLE, FIND THE MAX,MIN AND THE CORRESPONDING TIME
	YYMIN(M)=Y(IZERO)
	YYMAX(M)=Y(IZERO)
	VXMIN(M)=0.0
	VXMAX(M)=0.0
	AXMIN(M)=0.0
	AXMAX(M)=0.0
	DO I=IZERO,IEND
		IF(Y(I).LE.YYMIN(M))THEN
			YYMIN(M)=Y(I)
			TCYMIN(M)=FLOAT(I)
		ELSE IF (Y(I).GE.YYMAX(M)) THEN
			YYMAX(M)=Y(I)
			TCYMAX(M)=FLOAT(I)
		ELSE
			CONTINUE
		ENDIF

		IF(VX(I).LE.VXMIN(M))THEN
			VXMIN(M)=VX(I)
			TCVXMIN(M)=FLOAT(I)
		ELSE IF (VX(I).GE.VXMAX(M)) THEN
			VXMAX(M)=VX(I)
			TCVXMAX(M)=FLOAT(I)
		ELSE
			CONTINUE
		ENDIF

		IF(AX(I).LE.AXMIN(M))THEN
			AXMIN(M)=AX(I)
			TCAXMIN(M)=FLOAT(I)
		ELSE IF (AX(I).GE.AXMAX(M)) THEN
			AXMAX(M)=AX(I)
			TCAXMAX(M)=FLOAT(I)
		ELSE
			CONTINUE
		ENDIF
	ENDDO

	N(M)=IEND-IZERO+1
	A=FLOAT(IEND-IZERO)
	TYMIN(M)=(TCYMIN(M)-FLOAT(IZERO))/A
	TYMAX(M)=(TCYMAX(M)-FLOAT(IZERO))/A
	TVXMIN(M)=(TCVXMIN(M)-FLOAT(IZERO))/A
	TVXMAX(M)=(TCVXMAX(M)-FLOAT(IZERO))/A
	TAXMIN(M)=(TCAXMIN(M)-FLOAT(IZERO))/A
	TAXMAX(M)=(TCAXMAX(M)-FLOAT(IZERO))/A
	I=0
	DO K=IZERO,IEND
		I=I+1
		B(K)=FLOAT(K-IZERO)
		TT(I,M)=B(K)/A
		XX(I,M)=X(K)
		YY(I,M)=Y(K)
		VVX(I,M)=VX(K)
		VVY(I,M)=VY(K)
		AAX(I,M)=AX(K)
		AAY(I,M)=AY(K)
	ENDDO

	CALL GRAPH(NNAME1,JJ,IZERO,IINT,IEND,M)

	IF(WARN.NE.1.)THEN
			XTMIN(M)=X(IZERO)
			XTMAX(M)=X(IZERO)
		DO I=IZERO,IEND
			IF(X(I).LE.XTMIN(M))THEN
				XTMIN(M)=X(I)
				IINT=I
				TCXMIN(M)=FLOAT(I)
			ELSE IF (X(I).GE.XTMAX(M)) THEN
				XTMAX(M)=X(I)
				TCXMAX(M)=FLOAT(I)
			ELSE
				CONTINUE
			ENDIF
		ENDDO
		WRITE(6,*)XTMIN(M),M,IINT
		TXMIN(M)=(TCXMIN(M)-FLOAT(IZERO))/A
		TXMIN(M)=(TCXMIN(M)-FLOAT(IZERO))/A

		IF (M.NE.MM)THEN
			IZERO=IEND
			M=M+1
			GO TO 1000
		ELSE
			GO TO 110
		ENDIF
	ELSE
		XTMAX(M)=AA
		TXMAX(M)=BB
		TCXMAX(M)=CC
		XTMIN(M)=X(IZERO)
		WRITE(6,*)XTMIN(M),M
		DO I=IZERO,IEND
			IF(X(I).LE.XTMIN(M))THEN
				XTMIN(M)=X(I)
				TCXMIN(M)=FLOAT(I)
			ELSE
				CONTINUE
			ENDIF
		ENDDO
		TXMIN(M)=(TCXMIN(M)-FLOAT(IZERO))/A
		WRITE(6,*)XTMIN(M)
* TEST IF THERE ARE STILL SOME POINTS TO READ
		IF(IEND.LT.NPTS-8)THEN
			M=M+1
			MM=MM+1
			WRITE(6,*)M,MM,WARN
			GO TO 1000
		ELSE    
			GO TO 110
		ENDIF
	ENDIF           

100     MM=MM-1
	M=M-1
110     NCURVES=MM
	WRITE(6,*)XTMIN(M)
* FILE FOR PLOT OF ALL CYCLES IN X
	OPEN (UNIT=4,FILE=NNAME6,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(XX(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

* FILE FOR PLOT OF ALL CYCLES IN Y
	OPEN (UNIT=4,FILE=NNAME7,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(YY(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

* FILE FOR PLOT OF ALL CYCLES IN VX
	OPEN (UNIT=4,FILE=NNAME8,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(VVX(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

* FILE FOR PLOT OF ALL CYCLES IN VY
	OPEN (UNIT=4,FILE=NNAME9,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(VVY(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

* FILE FOR PLOT OF ALL CYCLES IN AX
	OPEN (UNIT=4,FILE=NNAME10,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(AAX(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

* FILE FOR PLOT OF ALL CYCLES IN AY
	OPEN (UNIT=4,FILE=NNAME11,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(AAY(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

*RESULTS ON PRINTER
	OPEN(UNIT=8,FILE=NNAME12,STATUS='NEW')
	WRITE(8,194)NNAME12
194     FORMAT(1X,A)
	WRITE(8,195)
195     FORMAT(/' FOR X ')
	WRITE(8,196)
196     FORMAT('_________________')
	WRITE(8,200)
200     FORMAT(' CURVE     MIN    REALTIME  NORMTIME      MAX   REALTIME
     1 NORMTIME . ')
	DO M=1,NCURVES
		TCXMIN(M)=TCXMIN(M)*.04
		TCXMAX(M)=TCXMAX(M)*.04
	WRITE(8,220)M,XTMIN(M),TCXMIN(M),TXMIN(M),XTMAX(M),TCXMAX(M),TXMAX(M)
220             FORMAT(1X,I3,4X,3(1X,F8.4),4X,3(1X,F8.4))
		TXSTROKE(M)=ABS(TXMAX(M)-TXMIN(M))
		TXRECOV(M)=(1.-TXSTROKE(M))
		XAMPL(M)=XTMAX(M)-XTMIN(M)
		IF(TXMAX(M).EQ.0.)THEN
			RXSTROKE(M)=ABS(TCXMAX(M)-TCXMIN(M))
			RXRECOV(M)=(FLOAT(ITOT(M))*0.04)-RXSTROKE(M)
		ELSE
			RXRECOV(M)=ABS(TCXMAX(M)-TCXMIN(M))
			RXSTROKE(M)=(FLOAT(ITOT(M))*0.04)-RXRECOV(M)
		ENDIF
		RXTOT(M)=RXSTROKE(M)+RXRECOV(M)
	ENDDO
	WRITE(8,230)
230     FORMAT(/' CURVE     TIME OF STROKE   TIME OF RECOVERY    AMPLITUDE')
	DO M=1,NCURVES
		WRITE(8,240)M,TXSTROKE(M),TXRECOV(M),XAMPL(M)
240             FORMAT(1X,I3,3(8X,F10.8))
		WRITE(8,242)
242     FORMAT(/'           TEMPORAL VALUES                ')
		WRITE(8,250)RXSTROKE(M),RXRECOV(M),RXTOT(M)
250             FORMAT(10X,F10.6,10X,F10.6,10X,F10.6)
	ENDDO
	WRITE(8,210)
210     FORMAT(/'                ')
	WRITE(8,260)
260     FORMAT(/  ' FOR Y  ')
	WRITE(8,196)
	WRITE(8,201)
201     FORMAT(' CURVE      MIN.    NORMTIME             MAX.  NORMTIME ')
	DO M=1,NCURVES
	WRITE(8,261)M,YYMIN(M),TYMIN(M),YYMAX(M),TYMAX(M)
261     FORMAT(1X,I3,4X,2(F9.6,2X,F9.6,8X))
		YAMPL(M)=YYMAX(M)-YYMIN(M)
	ENDDO
	WRITE(8,265)
265     FORMAT(/' CYCLE     AMPLITUDE IN Y')
	DO M=1,NCURVES
	WRITE(8,270)M, YAMPL(M)
270     FORMAT(1X,I3,8X,F10.6)
	ENDDO
	WRITE(8,210)
	WRITE(8,280)
280     FORMAT(/  ' FOR VX  ')
	WRITE(8,196)
	WRITE(8,201)
	DO M=1,NCURVES
	WRITE(8,261)M,VXMIN(M),TVXMIN(M),VXMAX(M),TVXMAX(M)
		VXAMPL(M)=VXMAX(M)-VXMIN(M)
	ENDDO
	WRITE(8,285)
285     FORMAT(/' CYCLE     AMPLITUDE IN VX')
	DO M=1,NCURVES
	WRITE(8,270)M, VXAMPL(M)
	ENDDO
	WRITE(8,210)
	WRITE(8,290)
290     FORMAT(/' FOR AX ')
	WRITE(8,196)
	WRITE(8,201)
	DO M=1,NCURVES
	WRITE(8,261)M,AXMIN(M),TAXMIN(M),AXMAX(M),TAXMAX(M)
		AXAMPL(M)=AXMAX(M)-AXMIN(M)
	ENDDO
	WRITE(8,295)
295     FORMAT(/' CYCLE     AMPLITUDE IN AX')
	DO M=1,NCURVES
	WRITE(8,270)M, AXAMPL(M)
	ENDDO
	CLOSE(UNIT=8)
	WARN=-1.
1000    CONTINUE
	RETURN
	END

*********************************************************************

	SUBROUTINE GRAPH(NNAME1,JJ,IZERO,IINT,IEND,M)

**********************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION XD(NINT,1),YD(NINT,1)
	
	CHARACTER*24 NNAME1,NNAME2,NNAME3,NNAME4,NUM

	TYPE *, NNAME1
	NNAME2='                                        '
	NNAME3='                                        '
	NNAME4='                                        '
			NUM='         '
		WRITE(NUM,'(I5)')M
		LG=LEN(NUM)
		I1=1
		DO I=1,LG
			IF(NUM(I:I).EQ.' ')GO TO 10
			NUM(I1:I1)=NUM(I:I)
			NUM(I:I)=' '
			I1=I1+1
10              ENDDO
		
	KK =INDEX(NNAME1,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (NNAME1, ' ')-1
		NNAME2(1:KK) = NNAME1(1:KK)
		NNAME3(1:KK) = NNAME1(1:KK)
		NNAME4(1:KK) = NNAME1(1:KK)
		NNAME2(KK+1:KK+4) = '.DAT'
		NNAME3(KK+1:KK+3) = '.CA'
		NNAME3(KK+4:KK+5) = NUM
		NNAME4(KK+1:KK+3) = '.RE'
		NNAME4(KK+4:KK+5) = NUM
	ELSE
		NNAME2(1:KK)=NNAME1(1:KK)
		NNAME3(1:KK)=NNAME1(1:KK)
		NNAME4(1:KK) = NNAME1(1:KK)
		NNAME2(KK+1:KK+3)='DAT'
		NNAME3(KK+1:KK+2)='CA'
		NNAME3(KK+3:KK+4)=NUM
		NNAME4(KK+1:KK+2)='RE'
		NNAME4(KK+4:KK+4)=NUM
	ENDIF

	WRITE(6,*)IZERO,IINT,IEND
	OPEN(UNIT=1,FILE=NNAME2,STATUS='OLD')
		READ(1,*)NP
		READ(1,*)(XA(I),YA(I),I=1,NP)
	CLOSE(UNIT=1)

	OPEN(UNIT=2,FILE=NNAME3,STATUS='NEW')
		WRITE(2,*)1
		IZ=IINT-IZERO+1
		WRITE(2,*)IZ
		WRITE(2,*)(XA(I),YA(I),I=IZERO,IINT)
	CLOSE(UNIT=2)
	
	OPEN(UNIT=3,FILE=NNAME4,STATUS='NEW')
		WRITE(3,*)1
		IZ=IEND-IINT+1
		WRITE(3,*)IZ
		WRITE(3,*)(XA(I),YA(I),I=IINT,IEND)
	CLOSE(UNIT=3)

	RETURN
	END

**********************************************************************

	SUBROUTINE ANGLE(KAN)

**********************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION T(NINT)               
	CHARACTER*24 FNAME,SNAME,TNAME,ONAME,VNAME,ANAME

	FNAME='               '
	SNAME='               '
	TNAME='               '
	ONAME='               '
	VNAME='               '
	ANAME='                 '       
	IF(KAN.EQ.1)THEN
		FNAME='HEAD'
		SNAME='NECK'
		TNAME='DORSAL'
	ELSE IF (KAN.EQ.2)THEN
		FNAME='NECK'
		SNAME='DORSAL'
		TNAME='HIP'
	ELSE IF (KAN.EQ.3)THEN
		FNAME='DORSAL'
		SNAME='HIP'
		TNAME='KNEE'    
	ELSE IF (KAN.EQ.4)THEN
		FNAME='HIP'
		SNAME='KNEE'
		TNAME='ANKLE'
	ELSE
		GO TO 1000
	ENDIF

	KK =INDEX(SNAME,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (SNAME, ' ')-1
		ONAME(1:KK) = SNAME(1:KK)
		ONAME(KK+1:KK+4) = '.ANG'
	ELSE
		ONAME(1:KK)=SNAME(1:KK)
		ONAME(KK+1:KK+3)='ANG'
	ENDIF

	OPEN(UNIT=1,FILE=FNAME,STATUS='OLD')
	READ(1,*)KD
	DO I=1,KD
		READ(1,*)XA(I),YA(I)
	ENDDO   
	CLOSE(UNIT=1)

	OPEN(UNIT=2,FILE=SNAME,STATUS='OLD')
	READ(2,*)KD
	DO I=1,KD
		READ(2,*)XB(I),YB(I)
	ENDDO
	CLOSE(UNIT=2)

	OPEN(UNIT=3,FILE=TNAME,STATUS='OLD')
	READ(3,*)KD
	DO I=1,KD
		READ(3,*)XC(I),YC(I)
	ENDDO
	CLOSE(UNIT=3)

	OPEN(UNIT=4,FILE=ONAME,STATUS='NEW')
	OPEN(UNIT=13,FILE='TEMP',STATUS='NEW')
	WRITE(4,*)KD
	DO I=1,KD
			T(I)=I*.04
			WRITE(4,*)T(I)
	ENDDO
	DO I=1,KD
		AT(I)=SQRT(((XB(I)-XA(I))**2)+((YB(I)-YA(I))**2))
		CT(I)=SQRT(((XC(I)-XA(I))**2)+((YC(I)-YA(I))**2))
		BT(I)=SQRT(((XC(I)-XB(I))**2)+((YC(I)-YB(I))**2))
		COSI(I)=((AT(I)**2)+(BT(I)**2)-(CT(I)**2))/
     1      (2*AT(I)*BT(I))
		IF(ABS(COSI(I)).GT.1.)THEN
			WRITE(6,200)I,COSI(I)
200     FORMAT(' CAUTION VALUE ',1X,I3,1X,F12.8,' WAS OVER 1 .
     1     CHECK IT PLEASE!')
			IF(COSI(I).LT.0.)COSI(I)=-1.
			IF(COSI(I).GE.0.)COSI(I)=1.
		ELSE
			CONTINUE
		ENDIF
		THETA(I)=ACOS(COSI(I))
* transformation to get the result in degrees
		X(I)=(theta(I)*180)/3.1416
	WRITE(13,*)AT(I),CT(I),BT(I),COSI(I)
		WRITE(4,*) X(I)
	ENDDO
	CLOSE(UNIT=4)
	CLOSE(UNIT=13)

	CALL VELAC2(KD,ONAME)

1000    CONTINUE
	RETURN
	END


************************************************************************
	SUBROUTINE VELAC2(KD,ONAME)
**********************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

	DIMENSION XT(NINT,3),XX(NINT,3),T(NINT)
	CHARACTER*24 ONAME,VNAME,ANAME,ZNAME,UNAME

	VNAME='                           '
	ANAME='                           '
	ZNAME='                           '
	UNAME='                           '
	H=0.04

	KK =INDEX(ONAME,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (ONAME, ' ')-1
		VNAME(1:KK) = ONAME(1:KK)
		ANAME(1:KK) = ONAME(1:KK)
		ZNAME(1:KK) = ONAME(1:KK)
		UNAME(1:KK) = ONAME(1:KK)
		VNAME(KK+1:KK+4) = '.AVE'
		ANAME(KK+1:KK+4) = '.AAC'
		ZNAME(KK+1:KK+4) = '.ATO'
		UNAME(KK+1:KK+4) = '.PLA'
	ELSE
		VNAME(1:KK)=ONAME(1:KK)
		ANAME(1:KK)=ONAME(1:KK)
		ZNAME(1:KK) = ONAME(1:KK)
		UNAME(1:KK) = ONAME(1:KK)
		VNAME(KK+1:KK+3)='AVE'
		ANAME(KK+1:KK+3)='AAC'
		ZNAME(KK+1:KK+3)='ATO'
		UNAME(KK+1:KK+3)='PLA'
	ENDIF

	MSPAN=5
	L= 2
	M= 3


*       FOURTH DEGREE

	DO J=M,KD-L
			VX(J)=(X(J-2)-8*(X(J-1))+8*(X(J+1))-X(J+2))/
     1                       (12.*H)
	ENDDO
	GO TO 1000


1000    open (unit=2,file=VNAME,status='new')
	NPTS=KD-8
	WRITE(2,*)NPTS
	do J=M+2,KD-L-2
		Vx(J)=(.5*Vx(J-2)+Vx(J-1)+Vx(J)+Vx(J+1)+.5*Vx(J+2))/4.
		write(2,*)vx(J)
	enddo
	CLOSE(UNIT=2)

	OPEN (UNIT=3,FILE=VNAME,STATUS='OLD')
	READ(3,*)NP
	READ(3,*)(VX(I),I=1,NP)
	CLOSE(UNIT=3)

	open (unit=7,file=ANAME,status='new')
	kl=NPTS-6
	write(7,*)kl
	DO J=M+5,KD-L-5
		AX(J)=(VX(J-3)-3*(VX(J-2))-3*(VX(J-1))+3*(VX(J+1))+
     1       3*(VX(J+2))-VX(J+3))/(12.*H)
		write(7,*)ax(j)
	ENDDO
	close(unit=7)

******** prepare plot
	open(unit=1,file=ONAME,status='old')
		READ(1,*)NPTS
		READ(1,*)(T(I),I=1,NPTS)
		READ(1,*)(X(I),I=1,NPTS)
		DO I=1,NPTS
			XT(I,1)=X(I)
		ENDDO                   
	CLOSE(UNIT=1)

	OPEN(UNIT=13,FILE=UNAME,STATUS='NEW')
		WRITE(13,*)NPTS,1
		WRITE(13,*)(T(I),I=1,NPTS)
		WRITE(13,*)(XT(I,1),I=1,NPTS)
	CLOSE(UNIT=13)

	OPEN(UNIT=2,FILE=VNAME,STATUS='OLD')
		READ(2,*)NPT
		READ(2,*)(VX(K),K=1,NPT)
		DO K=1,NPT
			I=K+4
			XT(I,2)=VX(K)
		ENDDO
	CLOSE(UNIT=2)

	OPEN (UNIT=3,FILE=ANAME,STATUS='OLD')
		READ(3,*)NP
		READ(3,*)(AX(L),L=1,NP)
		DO L=1,NP
			I=L+7
			XT(I,3)=AX(L)
		ENDDO
	CLOSE(UNIT=3)

	OPEN (UNIT=4,FILE=ZNAME,STATUS='NEW')
		WRITE(4,*)3
		J=1
		WRITE(4,*)NPTS
		DO I=1,NPTS
			XX(I,J)=I*0.04
			WRITE(4,*)XX(I,J)
		ENDDO
		WRITE(4,*)(XT(I,J),I=1,NPTS)
		J=2
		WRITE(4,*)NPT
		DO I=5,NPTS-4
			XX(I,J)=I*.04
			WRITE(4,*)XX(I,J)
		ENDDO
		WRITE(4,*)(XT(I,J),I=5,NPTS-4)
		J=3
		WRITE(4,*)NP
		DO I=8,NPTS-7
			XX(I,J)=I*.04
			WRITE(4,*)XX(I,J)
		ENDDO
		WRITE(4,*)(XT(I,J),I=8,NPTS-7)
	CLOSE(UNIT=4)
	CALL NORMANG(ONAME)
	RETURN
	END

*******************************************************************

	SUBROUTINE NORMANG(ONAME)

****************************************************************
	PARAMETER NVAL=3250,NINT=250
	common  n(NVAL),x(NVAL),y(NVAL),g(NVAL),vy(NINT),VX(NINT)
	COMMON  AX(NINT),AY(NINT),XA(NINT),XB(NINT),XC(NINT),YA(NINT)
	COMMON  YB(NINT),YC(NINT),AT(NINT),BT(NINT),CT(NINT),COSI(NINT)
	COMMON  THETA(NINT)

* Program to normalise in time the data from the dip
	DIMENSION T(1000),B(1000),XX(1000,10),TT(1000,10),RVX(1000),
     1    XMIN(10),XMAX(10),TXMIN(10),TXMAX(10),RVY(1000),
     1    XAMPL(10),RAX(1000),RAY(1000),
     1    YY(1000,10),VXAMPL(10),AXAMPL(10),
     1    VVX(1000,10),VVY(1000,10),AAX(1000,10),AAY(1000,10),
     1    VXMIN(10),VXMAX(10),TVXMIN(10),TVXMAX(10),
     1    AXMIN(10),AXMAX(10),TAXMIN(10),TAXMAX(10)
	CHARACTER*24 ONAME,NNAME4,NNAME5,NNAME6,NNAME8,
     1    NNAME10,NNAME12

	NNAME4='                        '
	NNAME5='                        '
	NNAME6='                        '
	NNAME8='                        '
	NNAME10='                       '
	NNAME12='                       '
	KK =INDEX(ONAME,'.')
	IF (KK.LE.0)THEN
		KK = INDEX (ONAME, ' ')-1
		NNAME4(1:KK) = ONAME(1:KK)
		NNAME5(1:KK) = ONAME(1:KK)
		NNAME6(1:KK) = ONAME(1:KK)
		NNAME8(1:KK) = ONAME(1:KK)
		NNAME10(1:KK) = ONAME(1:KK)
		NNAME12(1:KK) = ONAME(1:KK)
		NNAME4(KK+1:KK+4) = '.AVE'
		NNAME5(KK+1:KK+4) = '.AAC'
		NNAME6(KK+1:KK+4) = '.ADX'
		NNAME8(KK+1:KK+4) = '.AVX'
		NNAME10(KK+1:KK+4) = '.AAX'
		NNAME12(KK+1:KK+4) = '.AUT'
	ELSE
		NNAME4(1:KK) = ONAME(1:KK)
		NNAME5(1:KK) = ONAME(1:KK)
		NNAME6(1:KK) = ONAME(1:KK)
		NNAME8(1:KK) = ONAME(1:KK)
		NNAME10(1:KK) = ONAME(1:KK)
		NNAME12(1:KK) = ONAME(1:KK)
		NNAME4(KK+1:KK+3)='AVE'
		NNAME5(KK+1:KK+3)='AAC'
		NNAME6(KK+1:KK+3)='ADX'
		NNAME8(KK+1:KK+3)='AVX'
		NNAME10(KK+1:KK+3)='AAX'
		NNAME12(KK+1:KK+3)='AUT'
	ENDIF


* READING OF THE DATA FILE (DISPLACEMENT)
	OPEN(UNIT=1,FILE=ONAME,STATUS='OLD')
	READ(1,*)NPTS
	READ(1,*)(DUMMY,I=1,NPTS)
	READ(1,*)(X(I),I=1,NPTS)
	CLOSE(UNIT=1)

* READING OF THE DATA FILE (VELOCITY)
	OPEN(UNIT=2,FILE=NNAME4,STATUS='OLD')
	READ(2,*)NV
	READ(2,*)(RVX(K),K=1,NV)
	DO K=1,NV
		I=K+5
		VX(I)=RVX(K)
	ENDDO
	CLOSE(UNIT=2)

* READING OF THE DATA FILE (ACCELERATION)
	OPEN(UNIT=2,FILE=NNAME5,STATUS='OLD')
	READ(2,*)NA
	READ(2,*)(RAX(K),K=1,NA)
	DO K=1,NA
		I=K+8
		AX(I)=RAX(K)
	ENDDO
	CLOSE(UNIT=2)

	WRITE(6,80)
80      FORMAT(/' HOW MANY CYCLES DO YOU WANT TO NORMALISE?')
	READ(5,*)MM

	WRITE(6,100)
100     FORMAT(/' ENTER THE VALUE TO BEGIN THE NORMALISATION')
	READ(5,*)IZERO

	M=1
101     WRITE(6,110)
110     FORMAT(/' ENTER THE VALUE TO STOP THE NORMALISATION')
	READ(5,*)IEND

* FOR X WITHIN THE SELECTED CYCLE, FIND THE MAX,MIN AND THE CORRESPONDING TIME
	XMIN(M)=X(IZERO)
	XMAX(M)=X(IZERO)
	VXMIN(M)=VX(IZERO)
	VXMAX(M)=VX(IZERO)
	AXMIN(M)=AX(IZERO)
	AXMAX(M)=AX(IZERO)
	A=FLOAT(IEND-IZERO)
	DO I=IZERO,IEND
		IF(X(I).LT.XMIN(M))THEN
			XMIN(M)=X(I)
			TXMIN(M)=(FLOAT(I-IZERO))/A
		ELSE IF(X(I).GT.XMAX(M))THEN
			XMAX(M)=X(I)
			TXMAX(M)=(FLOAT(I-IZERO))/A
		ELSE
			CONTINUE
		ENDIF

		IF(VX(I).LT.VXMIN(M))THEN
			VXMIN(M)=VX(I)
			TVXMIN(M)=(FLOAT(I-IZERO))/A
		ELSE IF(VX(I).GT.VXMAX(M))THEN
			VXMAX(M)=VX(I)
			TVXMAX(M)=(FLOAT(I-IZERO))/A
		ELSE
			CONTINUE
		ENDIF

		IF(AX(I).LT.AXMIN(M))THEN
			AXMIN(M)=AX(I)
			TAXMIN(M)=(FLOAT(I-IZERO))/A
		ELSE IF(AX(I).GT.AXMAX(M))THEN
			AXMAX(M)=AX(I)
			TAXMAX(M)=(FLOAT(I-IZERO))/A
		ELSE
			CONTINUE
		ENDIF
	ENDDO

	N(M)=IEND-IZERO+1
	I=0
	DO K=IZERO,IEND
		I=I+1
		B(K)=FLOAT(K-IZERO)
		TT(I,M)=B(K)/A
		XX(I,M)=X(K)
		VVX(I,M)=VX(K)
		AAX(I,M)=AX(K)
	ENDDO

* TEST IF THERE ARE STILL SOME POINTS TO READ
	IF(M.LT.MM)THEN
		M=M+1
		IZERO=IEND
		GO TO 101
	ELSE
		CONTINUE
	ENDIF

	NCURVES=MM

* FILE FOR PLOT OF ALL CYCLES IN X
	OPEN (UNIT=4,FILE=NNAME6,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(XX(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

* FILE FOR PLOT OF ALL CYCLES IN VX
	OPEN (UNIT=4,FILE=NNAME8,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(VVX(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

* FILE FOR PLOT OF ALL CYCLES IN AX
	OPEN (UNIT=4,FILE=NNAME10,STATUS='NEW')
	WRITE(4,*)NCURVES
	DO M=1,NCURVES
		WRITE(4,*)N(M)
		WRITE(4,*)(TT(I,M),I=1,N(M))
		WRITE(4,*)(AAX(I,M),I=1,N(M))
	ENDDO
	CLOSE (UNIT=4)

*RESULTS ON PRINTER
	OPEN(UNIT=8,FILE=NNAME12,STATUS='NEW')
	WRITE(8,195)
195     FORMAT(/' FOR ANGLE ')
	WRITE(8,196)
196     FORMAT('_________________')
	WRITE(8,200)
200     FORMAT(/' CURVE        MIN         NORMTIME              MAX
     1     NORMTIME ')
	DO M=1,NCURVES
		XAMPL(M)=XMAX(M)-XMIN(M)
		WRITE(8,261)M,XMIN(M),TXMIN(M),XMAX(M),TXMAX(M)
261     FORMAT(1X,I3,4X,2(F12.6,2X,F12.6,8X))
	ENDDO
	WRITE(8,265)
265     FORMAT(/' CYCLE    AMPLITUDE OF ANGLE')
	DO M=1,NCURVES
		WRITE(8,270)M,XAMPL(M)
270             FORMAT(1X,I3,8X,F12.6)
	ENDDO
	WRITE(8,210)
210     FORMAT('                      ')

	WRITE(8,295)
295     FORMAT(/' FOR VELOCITY ')
	WRITE(8,196)
	WRITE(8,200)
	DO M=1,NCURVES
		VXAMPL(M)=VXMAX(M)-VXMIN(M)
		WRITE(8,261)M,VXMIN(M),TVXMIN(M),VXMAX(M),TVXMAX(M)
	ENDDO
	WRITE(8,365)
365     FORMAT(/' CYCLE    AMPLITUDE OF VELOCITY')
	DO M=1,NCURVES
		WRITE(8,270)M,VXAMPL(M)
	ENDDO
	WRITE(8,210)

	WRITE(8,395)
395     FORMAT(/' FOR ACCELERATION')
	WRITE(8,196)
	WRITE(8,200)
	DO M=1,NCURVES
		AXAMPL(M)=AXMAX(M)-AXMIN(M)
		WRITE(8,261)M,AXMIN(M),TAXMIN(M),AXMAX(M),TAXMAX(M)
	ENDDO
	WRITE(8,465)
465     FORMAT(/' CYCLE    AMPLITUDE OF ACCELERATION')
	DO M=1,NCURVES
	WRITE(8,270)M,AXAMPL(M)
	ENDDO
	CLOSE(UNIT=8)
	RETURN
	END



