#ifndef MATOPS_H
#define MATOPS_H
void nrerror (char error_text[]);
int * ivector(int nl, int nh);
void free_ivector(int *v, int nl, int nh);
double * vector(int nl, int nh);
void free_vector(double *v, int nl, int nh);
double ** matrix(int nrl,int nrh,int ncl,int nch);
void free_matrix(double**m, int nrl,int nrh,int ncl, int nch);
void matMult(double**a,double**b,double**c,int n);
void matAdd(double**a,double**b,double**c,int n);
void matSub(double**a,double**b,double**c,int n);
void matScale( double**a, double **b, double scaleFactor, int n);
void matWeightedDifference (double **a, double **b,double **c,double weight,int n);
void matDisplay(FILE * f,char * label, double ** a, int n);
void display(char * label, double ** a, int n);
void displayRectangle(char * label, double ** a, int rows,int cols);
void matDisplayRectangle(FILE * f, char * label, double ** a, int rows,int cols);
void randomMatrix(double **a, int n);
void matTranspose(double **a, double **b, int n);
int matInput (FILE * f, char * lab, double **a);
void copyMatrix( double ** x, double ** y, int size);
double trace(double ** a, int size);
void tensorProduct(double **x, int rx,int cx, double **y, int ry,int cy, double*** prod);
void gaussj(double ** a, int n, double **b, int m);
int gramSchmidt(double **w, double ** v, int n, int ev);
double determinant(double **z,int n);
double golden(double ax,double bx, double cx, \
       double f(double q), double tol, double * xmin);
#endif


