/*************************************************
* This is module fobm.c                          *
* The functions in the module build two density  *
* matrices, rho1 and rho2, for the configuration *
* where there is a known overlap between the two *
* program qbits.                                 *
* The matrices are assembled from their com-     *
* ponents on the main diagonal. This is (mainly) *
* to provide a test of the code that finds the   *
* "unambiguous" error rate.                      *
* For an explanation see the code pasted in to   *
* vol 2. on 21/4/2011                            *
*************************************************/

double ** xx;
double ** yy;
double ** zz;


extern double ** rho1;
extern double ** rho2;

typedef struct {                 //This holds a projector for one of the
				  int size;      //sub-blocks on the main diagonal of each
				  double** p;    //density matrix
			   } projector;

projector  projector1[16];
projector  projector2[16];

/*******************************************************
* Calculates the integral from 0 to pi/2 of the        *
* function  cos^n(x)sin^m(x),using a recursive method. *
*******************************************************/

double integral(int m, int n)

{
	if (n==1)
		 return (1.0/(m+1));
	else
		return (integral(m,n-2)-integral(m+2,n-2));
}


/************************************************
* Converts a binary number j with n significant *
* digits into a string of length n **           *
************************************************/

char * convertToString(int j, int n)
{
	int k;
	char * z = (char *) malloc((n+4) & 0XFFFC);
	z[n] = 0;
	for (k=0; k<n; k++)
	{
		z[n-1-k]= (j&1)?'1':'0';
		j>>=1;
	}
    return z;
}

/************************************************************
* statelist considers binary integers of length x bits. It  *
* selects all those that contain exactly y 1's, converts    *
* them into strings, and delivers an array of these strings *
************************************************************/

char ** stateList(int x,int y)
{
	int j = nCr(x,y),k,m,p=0;

	char ** list = (char **) malloc(j*sizeof(char *));
    k = 1<<x;
		for(m =0; m<k; m++)
			if (countOnes(m) == y)
                list[p++]=convertToString(m,x);
    return list;
}
/*************************************
*  Deletes the array produced by     *
*  stateList with parameters x and y *
*************************************/

void scrub(char ** z, int x, int y)
{
	int j;
	for (j = 0; j < nCr(x,y);j++)
	free(z[j]);
	free(z);
}

void subMatrix (double ** a,int n, int m, char * p)
{
	int j = nCr(n,m),k,q,x,y;
	char s,t;
	char ** sList = stateList(n,m);
	int * cSign = (int *) malloc(sizeof(int) * j);
	int * cosineCount = (int *)malloc(sizeof(int) *j);

	for (k = 0; k<j; k++)  /* Make the list of codes */
	{
		cSign[k] = 1;
		cosineCount[k] = 0;
		for(q = 0; q<n; q++)
		{
			s = sList[k][q];
			t = p[q];
			if(s == '0' && t == '0') cosineCount[k]++;
			if(s == '1' && t == '1')
			{
				cosineCount[k]++;
                cSign[k] *= (-1);
			}
          }
 	}
	/* Now construct the matrix */
	for (x = 0; x<j;x++)
	    for (y = 0; y < j; y++)
	    {
			int z = cSign[x]*cSign[y];
			int w = cosineCount[x]+cosineCount[y];
			a[x+1][y+1]= 2*z*integral(w+1,(2*n+1-w));
		}
	 free (cSign);
	 free (cosineCount);
	 scrub (sList,n,m);
}


void buildMatrices(int p1, int db,int p2, int z )
{
	int t = p1+p2+db;
	int a,b;
	char qq[100];
	int d = nCr(t,z);
    int j;
    xx= matrix(1,d,1,d);
	yy= matrix(1,d,1,d);
	zz= matrix(1,d,1,d);
    for(a=1;a<=d;a++) for (b=1; b<=d; b++) xx[a][b]=yy[a][b]=zz[a][b] =0.0;
 		  					/* Construct a string with all zeros*/
	qq[0] ='\0';
	for (j=0; j<t; j++)
	    strcat(qq,"0");
	subMatrix(xx,t,z,qq);   /*Matrix with all zeros in p*/
	 					    /* Construct a string with 1's on the right*/
	qq[0] ='\0';
	for (j=0; j<(p2+db); j++)
	    strcat(qq,"0");
	for (j=0; j<p1; j++)
	    strcat(qq,"1");
	subMatrix(yy,t,z,qq);    /* Matrix with 1's on the right*/

							  /* Construct a string with 1's on the left*/
    qq[0] ='\0';
	for (j=0; j<p2; j++)
	    strcat(qq,"1");
	for (j=0; j<(p1+db); j++)
	    strcat(qq,"0");
	subMatrix(zz,t,z,qq);    /*Matrix with 1's on the left*/

}



void makeDensityMatricesForKnownOverlap(int p1, int db, int p2, double beta)
{                          /*1*/

	int origin = 0;        // For rho1, and  rho2
//    int startColumn = 0;
	double cb2,sb2;
	int z,t=p1+p2+db,a,b,c;
	int size = power(2,t);
	for(a=1;a<=size; a++)
	  for(b=1; b<=size; b++)
		  rho1[a][b] = rho2[a][b] = 0;

    for (z=0;z<=t; z++)
	{          /*  2  Walking down the diagonal starts */
         int d = nCr(t,z);
         double ** rhoa= matrix(1,d,1,d);
      	 double ** rhob= matrix(1,d,1,d);
		 for(a=1;a<=d;a++) for (b=1; b<=d; b++) rhoa[a][b]=rhob[a][b]=0.0;
 //        startColumn +=d;

	     buildMatrices(p1,db,p2, z);
	     {   /* 3 */
				{   /* 4 */

			        cb2 = cos(beta/2)*cos(beta/2);
    	            sb2 = sin(beta/2)* sin(beta/2);
    				for(a=1; a<= d; a++)
	                for (b=1;b<=d; b++)
	                {  /* 5 */
		               rhoa[a][b]=cb2*xx[a][b] + sb2*yy[a][b];
	                   rho1[a+origin][b+origin] =rhoa[a][b];
		               rhob[a][b]  = cb2*xx[a][b] + sb2*zz[a][b];
	                   rho2[a+origin][b+origin] =rhob[a][b];

	                }   /* 5 */
	    			origin += d;

		        }  /* 4 */
          }  /* 3 */
//		free_matrix(xx,1,d,1,d);
//  		free_matrix(yy,1,d,1,d);
//   		free_matrix(zz,1,d,1,d);
//		free_matrix(rhoa,1,d,1,d);
//		free_matrix(rhob,1,d,1,d);
	}  /* 2 */
}   /* 1 */

