/*************************************************
* This is module pcbm.c                          *
* The functions in the module build two density  *
* matrices, rho1 and rho2, for the configuration *
* where each program qbit is confined to a polar *
* cap of known size . rho1 and rho have already  *
* had the right amount of memory allocated       *
*************************************************/

extern double ** rho1;
extern double ** rho2;


/*******************************************************
* Calculates the integral which gives the matrix       *
* elements for the density matrices.  See book 3       *
* entry for June 18 2011 for details                   *
*******************************************************/

double integral3(int m,int n,double theta)
{

	if (n>= 3)
	   return(integral3(m,n-2,theta) - integral3(m+2,n-2,theta));
    return (4.0/(m+1)) * (1/(1-cos(theta))) * (1-realpower(cos(theta/2),m+1));
}



/*************************************************************
*  partMatrix calculates the density matrix that corresponds *
*  to mu or lambda in the writeup. The final density matrix  *
*  is the tensor product of mu and lambda.                   *
*  The parameters are as follows:                            *
*  a is the matrix that holds the result                     *
*  n is the number of rows/columns in this matrix            *
*  theta is the size of the cap                              *
*  rightside = 1 if the item is on the right,else 0          *
*************************************************************/

void partMatrix (double ** a,int n, double theta,int rightside)
{
	int x,y,j,k;
	int q = power(2,n);
	int * bitCount = (int *) malloc(sizeof(int) * q);
	//work down a column and

	for (k = 0; k<q; k++)  /* Make the list of codes */
        bitCount[k]=countBits(k);


	/* Now construct the matrix */
	for (x = 0; x<q;x++)
	    for (y = 0; y < q; y++)
	    {
		 if(bitCount[x] != bitCount[y])
		    a[x+1][y+1]=0.0;
		 else
			if (rightside)
			    a[x+1][y+1]= integral3(2*bitCount[x]+1,(2*n+1-2*bitCount[x]), theta);
			else
			   a[x+1][y+1]= integral3((2*n+1-2*bitCount[x]), 2*bitCount[x]+1,theta);
	 }
	 free (bitCount);
}

/**************************************************
*  Parameters p1,db and p2 give the configuration *
*  theta indicates the size of the polar caps,    *
*  which are the same for both poles. We could    *
*  make 'em different, but that would be one      *
*  variable too many!                             *
**************************************************/

void makeDensityMatricesForPolarCaps(int p1, int db, int p2, double theta)
{
	int l1=power(2,p1+db);
	int r1=power(2,p2);
	int l2=power(2,p1);
	int r2=power(2,db+p2);
	double ** aleft = matrix(1,l1,1,l1);
	double ** aright = matrix(1,r1,1,r1);
	double ** bleft = matrix(1,l2,1,l2);
	double ** bright = matrix(1,r2,1,r2);
	partMatrix(aleft,p1+db,theta,0);
	partMatrix(aright,p2,theta,1);
	                // Rho1 and rho2 are already allocated
	tensorProduct(aleft,l1,l1,aright,r1,r1,&rho1);
	partMatrix(bleft,p1,theta,0);
	partMatrix(bright,db+p2,theta,1);
	tensorProduct(bleft,l2,l2,bright,r2,r2,&rho2);
}


