// Best discrimination ona known great circle

#define PI 3.14159265
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

			   /* Convenient to make these global */
double ** rho1;
double ** rho2;
double ** eigenvecs;
double * eigenvals;
double ** lambda;

#include "matops.c"
#include "utilities.c"
#include "jacobi.c"
#include "gcdm.c"
#include "configuration.c"

double findBestDiscrimination(int p1, int d, int p2,double eta)
{
	double total=0;
	int size = power(2,p1+p2+d);
	int j,nrot;
	makeDensityMatricesForGreatCircle(p1,d,p2);
    matWeightedDifference(rho1,rho2,lambda,eta,size);
    jacobi(lambda,size,eigenvals,eigenvecs,&nrot);
    for (j=1; j<=size; j++)
    if (eigenvals[j] >0)
         total += eigenvals[j];
    else
         total -= eigenvals[j];
      return (0.5*(1-total));
}

/*************************************************************
*   Solves the problem for a given configuration of qbits .  *
*   Parameters are as follows:                               *
*         p1: Number of program qbits (left side)            *
*         db: Number of data bits in the middle              *
*         p2: Number of program qbits (right side)           *
*             (so that the total number of qbits is p1_p2_db *
*   rEta: Interval btween steps of eta (must be a sub-       *
*         multiple of 1)                                     *
*   ff : A file handle to write the answers as a matrix      *
*************************************************************/

  void solve(int p1, int db,int p2,double rEta, FILE * ff)
{     //1                     /*1*/
	double ** result;
	double eta,beta;
	int tc =1;
	int ec = floor(1/rEta + 0.0001);
	int z,a,b,nrot,bc;
	char latexSpecifier[] = " &%1.3lf";
	char ordinarySpecifier[16];
    strcpy(ordinarySpecifier," %1.5lf");
                       /*  Print header */

	#ifndef LATEX
	fprintf(ff,"\n\nEta       P.E.\n");
	#else
	fprintf(ff,"\\hline$\\eta$&P.E.\\\\\n\\hline\n");
	#endif
	result = matrix(0,ec,1,tc);
	for (a=0; a<=ec;a++)
	{   //2      a is code for eta
		   eta = a*rEta;
	       for(b=1;b<=tc; b++)
	       {  //3       b is code for theta
	               result[a][b] = findBestDiscrimination(p1,db,p2,eta);
	       }  //3
		}  /* 2 */
                          // All results computed
    for (a=0; a<=ec;a++)
	{  // 2
		printf("*\n");
		#ifndef LATEX
        fprintf(ff, "%0.4lf  ",a*rEta);
        #else
        fprintf(ff, "%0.2lf  ",a*rEta);
        #endif
	    for(b=1;b<=tc; b++)
	    #ifndef LATEX
		{
			ordinarySpecifier[4] = (char)(DECIMALS+'0');
	    	fprintf(ff,ordinarySpecifier,result[a][b]);
	    }
	    #else
        {
			latexSpecifier[5] = (char)(LATEXDECIMALS +'0');
		    fprintf(ff,latexSpecifier,result[a][b]);
        }
        #endif
 	    #ifndef LATEX
	    fprintf(ff,"\n");
	    #else
	    fprintf(ff,"\\\\\n");
	    #endif


	}  //2
}   /* 1 */



void main(int argc, char**argv)
{


	FILE * ff;
	int a,b,size,nrot,ev,j;
	int p1,d,p2;
	#ifdef LATEX
	int columns=1;
	#endif
	time_t startTime = time(NULL);
	time_t endTime;

	char  fileName[100];
	char dump[20];
	readConfiguration2(argc,argv, &p1,&d,&p2);
	strcpy(fileName,"greatcirclebest");
	sprintf(dump,"(%d,%d,%d).txt",p1,d,p2);
	strcat(fileName,dump);
	ff=fopen(fileName,"w");
	if(ff == NULL)
	{
		printf("Could not open file %s\n",fileName);
		exit(1);
	}
	else
	#ifndef LATEX
	    printf("Output will be sent to:\n    %s\n",fileName);
	#else
		    printf("Output will be sent to:\n    %s in LATEX format\n",fileName);
	#endif
    #ifndef LATEX
	fprintf(ff,"Great Circle Optimum {%d,%d,%d}\n",p1,d,p2);
	#else
	fprintf(ff,"\\begin{table}[h]\n  \\begin{center}    \\begin {tabular}");
	{
		char zz[40];
		for (a=0; a<columns; a++) zz[a]='c';
		zz[a] = '\0';
		fprintf(ff,"{|l|%s|}\n",zz);
	}

	#endif
	size=power(2,p1+p2+d);
	rho1=matrix(1,size,1,size);
	rho2=matrix(1,size,1,size);
    lambda=matrix(1,size,1,size);
    eigenvecs=matrix(1,size,1,size);
	eigenvals = vector(1,size);
	solve(p1,d,p2,ETAINTERVAL,ff);
	#ifdef LATEX
	fprintf(ff,"\n\\hline\\end{tabular}\n\\caption{Great Circle Optimum \\{%d,%d,%d\\}}\n",p1,d,p2);
	fprintf(ff,"\\end{center} \n");
	fprintf(ff,"\\end{table} \n");
	#endif
	endTime = time(NULL);
    printf("Elapsed time = %ld seconds\n", endTime-startTime);
    fclose(ff);
}
