// Unambiguous discrimination with fixed overlap

#define PI 3.14159265

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

#include "matops.c"
#include "utilities.c"
#include "jacobi.c"
#include "matrixinversion.c"
#include "gcdm.c"
#include "configuration.c"

/* Convenient to make these global, as Borland C
   doesn't like deleting large matrices
   */
	double ** mat;
	double c;
	double minimum;
	double * gg;
	double ** proj1;
	double ** proj2;
    double ** pr1;
    double ** sump;
    double ** dump;
	double ** eigenvec1;
	double ** eigenvec2;
	double * eigenval1;
	double * eigenval2;
	double ** asyms;
	double ** rho1;
	double ** rho2;
	double** pi0;
	int size;
    double eta,r2,r3;
/**************************************************************
*  This ancilliary functiontakes one of the density matrices  *
*  and finds its eigenvalues and eigenvectors. Then those     *
*  eigenvectors wot have zero eigenvalues are discarded       *
*  and the function returns the number of non-zero            *
*  eigenvectors  Dump and size are predefined globals         *
**************************************************************/

int findEigenvectors(double ** rho, double * eigenval, double** eigenvec)
{
	int m = 0, nrot, a,b;
	copyMatrix(rho,dump,size);   // Find eigenvalues and vectors of rho1
	jacobi(dump,size,eigenval,eigenvec,&nrot);
	            // Count non-zero eigenvalues and squeeze
	            // the corresponding eigenvectors up to the left
	            // Remember that jacobi spoils the input matrix (hence dump!)
	for(a=1;a<=size;a++)
		if (fabs(eigenval[a]) >= 0.0000001)
	   {
		   if (a>m+1)
		     for(b=1;b<=size; b++)
		         eigenvec[b][m+1] = eigenvec[b][a];
		    m++;
   		}
	return m;
}





/********************************************************************
*  This function findPerpendicularComponents is called with three   *
*  parameters:   									                *
*                                                                   *
*  1)  An array A[1:size,1,x] of the non-zero eigenvectors of one   *
*  of the density matrices of the problem                           *
*                                                                   *
*  2) an array B[1,size,1,y] of the non-zero vectors of the other   *
*  density matrix of the problem                                    *
*                                                                   *
*  3) An array C (of undefined dimension) which is used to deliver  *
*  the components of the eigenvectors supplied in B which are       *
*  perpendicular to all the eigenvectors supplied in A.             *
*  On delivery these components are normalised, and ready to be used*
*  in the Gram-Schmidt procedure.									*
*                                                                   *
*  The function returns the number of such components               *
*                                                                   *
*  The job is done as follows:                                      *
*                                                                   *
*  We set up a set of (size+x) simultaneous equations.				*
*  It is supposed that each eigenvector in B is a linear combination*
*  of the eigenvectors in A, plus a residual vector which is per-   *
*  pendicular to every eigenvector in A. The unknowns for a given   *
*  eigenvector in B are therefore 									*
*  x coefficients of the eigenvectors in A                          *
*  size elements of the residual (making size + x in all)           *
*                                                                   *
*  The right hand side of the equations is a vector that consists   *
*  of the eigenvector from B, followed by size zeros                *
*                                                                   *
*  Actually we can use an array of right-hand sides to handle all   *
*  the components of B at the same time.                            *
*  The co-efficient matrix is set up as follows:					*
*                                                                   *
*  The topleft corner (size*x) is a copy of the non-zero			*
*   eigenvectors of A;   											*
*                                                                   *
*  The top right hand corner (size*size) is the unit matrix			*
*																	*
*  the bottom left-hand corner (x*x) is all zeros					*
*																	*
*  the bottom right-hand corner (x * size) is a copy of the			*
*  transposes of the non-zero eigenvectors on A                     *
*                                                                   *
*   The  right-hand sides of the equations are an array with		*
*   size+x rows and y columns; The top part is a copy of the		*
*                                                                   *
*  All this is explained on July 5th 2011 in my notebook.			*
*         	                                                        *
********************************************************************/

int findPerpendicularComponents(double** A, int x, double ** B, int y,double ***C,double ***D)
{
	int a,b,nrot,q,s,z,w;
	int log[256];
	double** A2;
	double** Rhs;
 	A2=matrix(1,size+x,1,size+x);
 	Rhs = matrix(1,size+x,1,y);
    for(a=1;a<=size; a++)
	    for (b=1; b<=x;b++)
	      A2[a][b] = A[a][b];
	 for(a=1; a<=x;a++)
	    for (b=1; b<=x; b++)
	      A2[a+size][b] = 0;
	  for(a=1; a<=size;a++)
	    for(b=1; b<=size; b++)
	      A2[a][b+x] = (a==b);
	  for(a=1;a<=x;a++)
	    for(b=1; b<=size; b++)
	      A2[a+size][b+x] = A[b][a];
	                   // SET UP rhs2
	  for(a=1; a<=size; a++)
	     for(b=1; b<= y; b++)
	        Rhs[a][b]=B[a][b];
	  for (a=1; a<= x; a++)
	     for (b=1; b<= y; b++)
	        Rhs[a+size][b] = 0;
      gaussj(A2,size+x,Rhs,y);

//  Compression follows
	  q=0;
	  for(a=1; a<= y; a++)  // look for non-zero residuals
      {
//  Compression follows
		  for (b = x+1; b<= x+size; b++)
          if (fabs(Rhs[b][a]) >0.0000000001)
              break;
      	  if (b <= x+size)
		    log[++q] = a;   // Mark a non-zero residual
	  }
	  *C = matrix(1,size,1,q);
	  *D = matrix(1,size,1,q);
	  for( a = 1; a<= q; a++)
	  {                    // Copy it to C
		  double tot =0;
		  s = log[a];
		  for ( b = 1; b<=size; b++)
		  {
			  (*C)[b][a] = Rhs[b+x][s];
				tot += (*C)[b][a]* (*C)[b][a];
	      }                // and normalise it
		  tot = sqrt(tot);
		  for(b=1; b<=size; b++)
		      (*C)[b][a] /= tot;
	}
	                                    // Experiment to remove vectors that are not linearly independent
	{
		double d;
		int * indx = ivector(1,size);
		for(a=1;a<=size;a++)
	    for(b=1;b<=size; b++)
	       dump[a][b] = 0.0;
	    for(a=1;a<=size;a++)
	       for(b=1;b<=q;b++)
	        dump[a][b] = (*C)[a][b];
        ludcmp(dump,size,indx,&d);
	    w=0;
 	    for(a=1;a<=size;a++)
 	    if( fabs(dump[a][a]) > 0.000001)
 	    {
			w++;
			for (b=1;b<=size; b++)
			   (*C)[b][w] = (*C) [b][a];
	    }
	    q=w;

     }

      z=gramSchmidt2(*C,*D,size,q);
//    free_matrix(A2,1,size+x,1,size+x)
//    free_matrix (Rhs,1,size+x,1,y);
    return z;
}

/*********************************************
*  This version of the Golden Section search *
*  comes from p298 of Numerical Recipes in C *
*  Given a function f and a bracketing set   *
*  of abscissas ax, bx, and cx such that     *
*  f(bx) is less than both f(cx) and f(ax)   *
*  the routine does a golden section search  *
*  for the minimum.  The abscissa of the     *
*  minimum is returnd as xmin, and the min-  *
*  imum function value is returned as golden *
*  The fractional accuray is set by tol.     *
*********************************************/

#define R 0.61803399
#define C (1-R)
#define SHFT2(a,b,c)    (a)=(b); (b)=(c);
#define SHFT3(a,b,c,d)  (a)=(b); (b)=(c); (c)=(d);

double golden(double ax,double bx, double cx,double f(double q), double tol, double * xmin)
{     //1
	double f0,f1,f2,f3,x0,x1,x2,x3,trial,z1,z2,z3;
	double fax,fbx,fcx;
	z1=f(-1.1);     // Search for decent starting conditions
	z2=f(-1.05);
	for(trial = 0; trial <= 1; trial += 0.05)
	{
			z3=f(trial);
			if(z2 < z1 && z2 < z3)
			   break;
			z1=z2; z2 = z3;
    }

    fax = z1;
    fbx = z2;
    fcx = z3;
    if (fbx >= fax || fbx >= fcx)
        return (-1);
//	{
//		printf("Initial conditions for \"golden\" violated!!!!!\n");
//		printf("ax=%lf,bx=%lf,cx=%lf,fax=%lf,fbx=%lf,fcx=%lf\n",ax,bx,cx,fax,fbx,fcx);
//		exit(1);
//	}
	x0=ax;     // At any given timew keep track of 4 points x0-x3
	x3 = cx;
	if(fabs(cx-bx) > fabs(bx-ax))
	{
		x1=bx;
		x2=bx+C*(cx-bx);
	}
    else
    {
		x2=bx;
		x1 = bx-C*(bx-ax);
	}
	f1=(f)(x1);
	f2=(f)(x2);
	while(fabs(x3-x0) > tol*(fabs(x1) + fabs(x2)))
	{
		if(f2 < f1)
		{
			SHFT3(x0,x1,x2,R*x1+C*x3)
			SHFT2(f1,f2,(f)(x2))
		}
		else
		{
			SHFT3(x3,x2,x1,R*x2+C*x0)
			SHFT2(f2,f1,(f)(x1))
		}
        if(x1==x2) return -1;
	}
	if(f1<f2)
	{
		*xmin = x1;
		return f1;
	}
	else
	{
		*xmin=x2;
		return f2;
	}
}

/*********************************************************************
*  This function uses two density matrices, rho1 and rho2, to make   *
*  projectors p1 and p2, such that tr(rho1,p2) = tr(rho2.p1) = 0.    *
*  The method is taken from  "Optimim meansurement for unambiguously *
*  discrimination two mixed states: General considerations and       *
*  special cases" by Ulrike Herzog and Janos Bergou. JP36(2006) 49-54*
*  The method is explained step by step.                             *
*  rho1, rho2, dump, are globals                                     *
*********************************************************************/
void makeNullProjectors(double **p1,double **p2,int size)
{
	int a,b,c,nrot;
	int s1,s2,m1,m2;  // Numbers of non-zero eigenvalues in rho1-2
	double ** A1;
	double ** A2;
	double ** rhs1;
	double ** rhs2;
	double ** C1;
	double ** C2;
	double **D1;
	double **D2;
	m1=findEigenvectors(rho1,eigenval1,eigenvec1);   // Find non-zero eigenvectors
	m2=findEigenvectors(rho2,eigenval2,eigenvec2);   // of rho1 and rho2
    s1=findPerpendicularComponents(eigenvec1,m1,eigenvec2,m2,&C1, &D1);
    s2=findPerpendicularComponents(eigenvec2,m2,eigenvec1,m1,&C2, &D2);
    for(a=1;a<=size;a++)
       for(b=1; b<=size; b++)
           p1[a][b]=p2[a][b] = 0;   // Set up unit matrices
    for(c=1; c<=s1; c++)
        for(a=1;a<=size;a++)
	       for(b=1; b<=size; b++)
	          p1[a][b] += D1[a][c]*D1[b][c];
    for(c=1; c<=s2; c++)
        for(a=1;a<=size;a++)
	       for(b=1; b<=size; b++)
	          p2[a][b] += D2[a][c]*D2[b][c];
}





/**********************************************
*   This function computes the smallest       *
*   eigenvalue of I - c1*proj1 - c2*proj2     *
**********************************************/
double smallestEigenvalue(double c1, double c2)
{
	int a,b,nrot; double min;
	{
		for(a=1;a<=size; a++)
		   for(b=1;b<=size; b++)
			dump[a][b] = (a==b) -c1*proj1[a][b] - c2*proj2[a][b];
        jacobi(dump, size,eigenval1,eigenvec1,&nrot);
		min = eigenval1[1];
		for(a=2; a<=size;a++)
			if (eigenval1[a] < min)
				min = eigenval1[a];
        return min;
	}
}

/*****************************************
*  Given a parameter c1, this function   *
*  uses a binary chop method to find a   *
*  value of c2 such that                 *
*  smallestEigenvalue(c1,c2) = 0         *
*****************************************/

double lookForZero( double c1)
{
	double x1 ;
	double x2;
	double y1;
	double y2;
	double xnew,ynew;
	int count =0;
	x1 = -0.5;
	x2 = 1.5;
	y1 = smallestEigenvalue(c1,x1);
    y2 = smallestEigenvalue(c1,x2);
    if((y1*y2)>0)
	{
		printf("Initial values don't straddle zero\n");
	    printf("c1 =%15.12lf,x1=%lf, x2 = %lf, y1=%lf,y2 = %lf\n",c1,x1,x2,y1,y2);
	    for(x1=-0.5;x1<1.5;x1+=0.05) printf("%lf,%15.12lf\n",x1,smallestEigenvalue(c1,x1));
	    exit(1);
	}
    while ( count <1000)
	{
		count++;
		xnew = x1 - y1*(x2-x1)/(y2-y1);
		ynew = smallestEigenvalue(c1,xnew);
		if(fabs(ynew) < 0.00001)
		   break;
		if (y1*ynew < 0)
		   {  y2=ynew; x2=xnew;}
		else
		   {y1=ynew; x1 = xnew;};
	}
	return xnew;
}




double faultRate(double c1)
{
	double zx;
	zx=(1 -eta*c1*r2 - (1-eta) * lookForZero(c1)*r3);
	return zx;
}

double findUnambiguousDiscrimination(double r2, double r3,double eta)
{
		double val,xmin;
		val = golden(0,0.5,1,faultRate,0.000001,&xmin);
//		if(val <0 && eta<0.5) val = 1+r2*(eta-1);
//		if (val < 0 && eta > 0.5) val = 1-r3*eta;
		if(val < 0 && eta < 0.5)
		    val = 1-(1-eta)*r3;

 		if(val < 0 && eta > 0.5)
		    val = 1-(eta)*r2;


		return val;
}


/*************************************************************
*   Solves the problem for a given configuration of qbits .  *
*   Parameters are as follows:                               *
*         p1: Number of program qbits (left side)            *
*         db: Number of data bits in the middle              *
*         p2: Number of program qbits (right side)           *
*             (so that the total number of qbits is p1_p2_db *
*   rEta: Interval btween steps of eta (must be a sub-       *
*         multiple of 1)                                     *
*   rBeta Interval btween steps of beta (must be a sub-      *
*         multiple of pi)                                    *
*   ff : A file handle to write the answers as a matrix      *
*************************************************************/

  void solve(int p1, int db,int p2,double rEta, FILE * ff)
{     //1                     /*1*/
	double ** result,r1,r4;
	int ec = floor(1/rEta +1.00001);
	int z,a,b,nrot,bc,tc=1;
	int symmetry = (p1==p2);
	char latexSpecifier[] = " &%1.3lf";
	char ordinarySpecifier[16];
    strcpy(ordinarySpecifier," %1.5lf");
                       /*  Print header */

	#ifndef LATEX
	fprintf(ff,"\n\nEta       P.E.\n");
	#else
	fprintf(ff,"\\hline$\\eta$&P.E.\\\\\n\\hline\n");
	#endif
	result = matrix(1,ec,1,tc);
		eigenvec1 = matrix(1,size,1,size);
		eigenval1 = vector(1,size);
	  	eigenvec2 = matrix(1,size,1,size);
		eigenval2 = vector(1,size);
	 	rho1=matrix(1,size,1,size);
	    dump = matrix(1,size,1,size);

		rho2=matrix(1,size,1,size);
		proj1=matrix(1,size,1,size);
		proj2=matrix(1,size,1,size);
		mat=matrix(1,size,1,size);  // Possible waste of space here (but not much!

		 for(b=1;b<=tc; b++)

	       {  //2       b is code for theta
	       	    printf("\n");
	       	    makeDensityMatricesForGreatCircle(p1,db,p2);

				makeNullProjectors(proj1,proj2, size);
	            matMult(proj1,rho1,mat, size);
				r1 =  trace(mat,size);
				matMult(proj1,rho2,mat, size);
				r2 = trace(mat,size);
				matMult(proj2,rho1,mat, size);
				r3= trace(mat,size);
				matMult(proj2, rho2,mat, size);
				r4=trace(mat,size);

			if (symmetry)
			{
				for (a=1; a<=(ec+2)/2;a++)
			    {   //3      a is code for eta
		           eta = (a-1)*rEta;
		             printf("*");
                   result[a][b] = result[ec-a+1][b]= findUnambiguousDiscrimination(r2,r3,eta);
	            }  //3
	        }
	        else
			{
			for (a=1; a<=ec;a++)
	        {   //3      a is code for eta
		           eta = (a-1)*rEta;
 		 //          printf("Not symmetric:eta=%4.2lf\n",eta);
                     printf("*");
         result[a][b] = findUnambiguousDiscrimination(r2,r3,eta);
	            }  //3
	        }

		}  /* 2 */
//    displayRectangle("Results!",result,ec,tc);                      // All results computed
    for (a=1; a<=ec;a++)
	{  // 2
		#ifndef LATEX
        fprintf(ff, "%0.4lf  ",(a-1)*rEta);
        #else
        fprintf(ff, "%0.2lf  ",(a-1)*rEta);
        #endif
	   for(b=1;b<=tc; b++)
	    #ifndef LATEX
		{
			ordinarySpecifier[4] = (char)(DECIMALS+'0');
	    	fprintf(ff,ordinarySpecifier,result[a][b]);
	    }
	    #else
        {
			latexSpecifier[5] = (char)(LATEXDECIMALS +'0');
		    fprintf(ff,latexSpecifier,result[a][b]);
        }
        #endif
 	    #ifndef LATEX
	    fprintf(ff,"\n");
	    #else
	    fprintf(ff,"\\\\\n");
	    #endif


	}  //2
}   /* 1 */




int main(int argc, char**argv)
{
	FILE * ff;
	int a,b,nrot,ev,j;
    time_t startTime = time(NULL);
    time_t endTime;

	int p1,d,p2;
	#ifdef LATEX
	int columns =1;
	#endif
	char  fileName[100];
	char dump[20];
	a=readConfiguration2(argc,argv,&p1,&d,&p2);
	if (a==0)
	{
		printf("bad parameters\n"); exit(0);
	}
	strcpy(fileName,"greatcircleunambiguous");
	sprintf(dump,"(%d,%d,%d).txt",p1,d,p2);
	strcat(fileName,dump);
	ff=fopen(fileName,"w");
	if(ff == NULL)
	{
		printf("Could not open file %s\n",fileName);
		exit(1);
	}
	else
	#ifndef LATEX
	    printf("Output will be sent to:\n   %s\n",fileName);
	#else
		    printf("Output will be sent to: \n %s in LATEX format\n",fileName);
	#endif
    #ifndef LATEX
	fprintf(ff,"Great Circle Unambiguous {%d,%d,%d}\n",p1,d,p2);
	#else
	fprintf(ff,"\\begin{table}[h]\n  \\begin{center}    \\begin {tabular}");
	{
		char zz[40];
		for (a=0; a<columns; a++) zz[a]='c';
		zz[a] = '\0';
		fprintf(ff,"{|l|%s|}\n",zz);
	}

   #endif
	size=power(2,p1+p2+d);
	solve(p1,d,p2,ETAINTERVAL,ff);
	#ifdef LATEX
	fprintf(ff,"\n\\hline\n\\end{tabular}\n\\caption{Great Circle Unambiguous \\{%d,%d,%d\\}}\n",p1,d,p2);
	fprintf(ff,"\\end{center} \n");
	fprintf(ff,"\\end{table} \n");
	#endif
	endTime = time(NULL);
    printf("\n Elapsed time = %ld seconds \n", endTime-startTime);
    fclose(ff);
    return 1;
}

