/*******************************************************
* Linear equation solution by Gauss-Jordan elimination *
* a[1..n[1..n] is an input matrix of n by n elements.  *
* b[1..n][1..m] is an input matrix of size n by m      *
* containing the m right-hand vectors. On output, a is *
* replaced by its matrix inverse, and b is replaced by *
* the corresponding set of solution vectors.           *
*******************************************************/

#include "matops.h"

#define SWAP(a,b) {double temp = (a); (a) = (b); (b) = temp;}
void gaussj(double ** a, int n, double **b, int m)
{     //1
   int *indxc, *indxr, *ipiv;
   /* The integer arrays ipiv[1..n], indxc [1..n] and indxr[1..n]
      are used for bookkeeping on the pivoting
   */
   int i,icol,irow,j,k,l,ll;
   double big,dum,pivinv;
   indxc = ivector(1,n);
   indxr = ivector(1,n);
   ipiv = ivector(1,n);
   for(j=1;j<=n;j++) ipiv[j] = 0;
   for(i=1; i<=n;i++)
   {   //2
       big = 0.0;
       for(j=1; j<=n; j++)
          if(ipiv[j] != 1)
             for(k=1; k<=n; k++)
             {  //3
                 if( ipiv[k]==0)
                 {  //4
                     if(fabs(a[j][k]) >= big)
                     {   //5
                        big=fabs(a[j][k]);
                        irow = j; icol = k;
                     }  //5
                  }   //4
                  else if (ipiv[k]>1) nrerror("GAUSSJ: Singular matrix-1");
              }   //3
        ++(ipiv[icol]);
        /*   We now have the pivot element, so we interchange rows,
             if needed, to put the pivot element on the diagonal.
             The columns are not physically interchanged, only
             relabeled: indxc[i] is the row in which that pivot
             element was originally located. If indxc[i] !=
             indxr[i] there is an implied column interchange.
             With this form of bookkeeping, the solution b's will
             end up in the correct order, and the inverse matrix
             will be scrambled by columns.
        */
        if (irow != icol)
        {  //3
           for(l=1; l<=n; l++) SWAP(a[irow][l],a[icol][l])
           for(l=1; l<=m; l++) SWAP(b[irow][l],b[icol][l])
        }   //3
        /* We are now ready to divide the pivot row by the pivot element,
           located at irow and icol
        */
        indxr[i] = irow;
        indxc[i] = icol;
        if(a[icol][icol] == 0.0) nrerror("GAUSSJ: Singular matrix-2");
        pivinv=1.0/a[icol][icol];
        a[icol][icol] = 1.0;
        for(l=1;l<=n; l++) a[icol][l] *= pivinv;
        for(l=1;l<=m; l++) b[icol][l] *= pivinv;
        /*  Next we reduce the rows .. except for the pivot one, of course */
        for(ll=1;ll<=n;ll++)
           if(ll != icol)
           {  //3
              dum = a[ll][icol];
              a[ll][icol]=0.0;
              for(l=1;l<=n; l++) a[ll][l] -= a[icol][l]*dum;
              for(l=1;l<=m; l++) b[ll][l] -= b[icol][l]*dum;
           }  //3
       }  //2
       /* This is the end of the main loop over columns of the reduction.
          It only remains to unscramble the solution in view of the
          column interchanges. We do this by interchanging pairs of
          columns in the reverse order that the permutation was built up.
        */
        for(l=n; l>=1; l--)
        { //2
          if(indxr[l] != indxc[l])
              for(k=1; k<=n; k++)     /* This line added to code from the book */
                 SWAP(a[k][indxr[l]],a[k][indxc[l]]);
          }  //3
          free_ivector(ipiv,1,n);
          free_ivector(indxr,1,n);
          free_ivector(indxc,1,n);
}  //2
