/**************************************************************
*  Next pair of functions,taken from pp43-45 of Numerical     *
*  Recipes in C. They find you the inverse of a matrix        *
*  THEY DON'T WORK OR SINGULAR MATRICES! (Surprise,surprise!) *
**************************************************************/
#include "matops.h"

#define TINY 1.0e-20

void ludcmp(double **a, int n, int* indx,double * d)
{
    int i,imax,j,k;
    double big,sum,dum,temp;
    double *vv;
    vv=vector(1,n);
    *d = 1.0;
    for(i=1;i<=n; i++)
    {
        big = 0.0;
        for (j=1; j<=n; j++)
           if ((temp = fabs(a[i][j])) > big)  big = temp;
        if (big == 0.0) nrerror("Singular matrix in routine LUDCMP");
        vv[i] = 1.0/big;
        if (vv[i] > 1000000) vv[i]=1;     // Experiment
    }
    for(j=1; j<=n; j++)
    {
        for(i=1; i<j; i++)
        {
           sum = a[i][j];
           for(k=1; k<i; k++) sum -= a[i][k]*a[k][j];
           a[i][j]=sum;
        }
        big=0.0;
        for(i=j;i<=n;i++)
        {
           sum = a[i][j];
           for(k=1; k<j; k++) sum -= a[i][k]*a[k][j];
           a[i][j]=sum;
           if ((dum=vv[i]* fabs(sum)) >= big)
           {
              big = dum;
              imax = i;
           }
        }

        if(j != imax)
        {
           for(k=1;k<=n;k++)
           {
              dum = a[imax][k];
              a[imax][k]=a[j][k];
              a[j][k]=dum;
           }
           *d = -(*d);
           vv[imax] = vv[j];
        }
        indx[j] = imax;
        if(a[j][j] == 0.0)
        {
			a[j][j] = TINY;/* Another point where singularity is detected*/
		}
        if(j!= n)
        {
          dum = 1.0/(a[j][j]);
          for(i=j+1;i<=n; i++) a[i][j] *= dum;
        }
      }
      free_vector(vv,1,n);
   }
   void lubksb(double **a,int n, int* indx, double b[])
   {
       int i,ii=0,ip,j;
       double sum;
       for (i=1; i<=n;i++)
       {
          ip=indx[i];
          sum = b[ip];
          b[ip]=b[i];
          if(ii) for(j=ii; j<=i-1; j++) sum -=a[i][j]*b[j];
          else if (sum) ii=i;
          b[i]=sum;
       }
       for(i=n; i>=1; i--)
       {
          sum = b[i];
          for(j=i+1;j<=n;j++)  sum -= a[i][j]*b[j];
          b[i] = sum/a[i][i];
       }
  }

   /* Finds the inverse of z and delivers it in b. z is untouched */

  void invert(double** z, double**b, int n)
  {
     int i,j; int *indx;
     double d;
     double **a = matrix(1,n,1,n);
     double * col = vector(1,n);
     for (i=1; i<=n; i++) for (j=1;j<=n;j++) a[i][j] = z[i][j];
     indx = ivector(1,n);
     ludcmp(a,n,indx,&d);
     for(j=1; j<=n; j++)
     {
        for(i=1; i<=n; i++) col[i]=0;
        col[j] = 1.0;
        lubksb(a,n,indx,col);
        for(i=1;i<=n; i++) b[i][j] = col[i];
     }
  }


  /* Finds the determinant of a matrix z of size n;  z is untouched */

  double determinant (double ** z, int n)
  {
      double **a = matrix(1,n,1,n);
	  int * indx = ivector(1,n);
	  double d;
	  int i,j;
	  for (i=1; i<=n; i++) for (j=1;j<=n;j++) a[i][j] = z[i][j];
      ludcmp(a,n,indx,&d);
      for(j=1; j<=n; j++) d*= a[j][j];
      free_matrix(a,1,n,1,n);
      free_ivector(indx,1,n);
      return d;
  }
