/**********************************************
*  This file contains utilities which are not *
*  specifically matrix functions              *
**********************************************/
#include "utilities.h"

/***************************************************************
* The two functions that follow are there                      *
* only to prettify the output: to display 2pi/5, not 4pi/10    *
***************************************************************/
int hcf(int a,int b)
{
	while (a != b)
	{
		if (a>b)
		   a-=b;
		else
		   b-=a;
	}
	return a;
}

void reduce (int *a, int*b)
{
	int j = hcf(*a,*b);
	*a /=j;
	*b /=j;
}


/***************************************
*  Calculates q to the power n. n must *
*  be a non-negative integer           *
***************************************/

double realpower(double q, int n)
{
	double p = 1;
	int j;
	for(j=1; j<=n; j++)
	   p*=q;
	return p;
}

/************************************
* counts the 1 bits in integer j    *
************************************/

int countBits(int j)
{
	int q = 0;
	while (j)
	{
		if (j & 1) q++;
		j>>=1;
	}
    return q;
}


/********************************************************
* function zeroFinder looks for a value of x such that  *
* f(x) = 0. x is known to lie between low and high, and *
* f(x) changes monotonically in this range.             *
*                                                       *
* There is no explicit derivative for f(x), so we use   *
* a kind of binary chop                                 *
********************************************************/


double zeroFinder (double f(double x), double low,double high)
{
   double lowval=0;
   double highval = f(high);
   double mid;
   double midval, oldmidval = highval;
   if (lowval*highval >= 0)
      {
         printf ("Wrong range supplied to zeroFinder\n");
         exit(1);
      }
   while(1)
   {
      mid = (high + low)/2;
      midval = f(mid);
      if ((midval * highval) >= 0)
       {
           high = mid;
           highval = midval;
       }
      else
           low = mid;
       if (fabs(midval-oldmidval) < 0.000000000001)
           return mid;
       oldmidval = midval;
   }
}


/******************************************
*   Counts the number of 1's in a string  *
*   that contains only zeros and ones     *
******************************************/

int countOnes (int w)
{
	int c = 0, j;
	for (j = 1<<16; j!=0; j=j>>1)
		 c+= ((w&j) > 0 );
	return c;
}


/******************************
*  Work out p to the power q  *
******************************/
int power(int p,int q)
{    // Work out p to the power q
     int s=1;
     while(q>0)
     {
		 s*=p; q--;
     }
     return s;
}

/***************************
* The usual meaning of nCr *
***************************/
int nCr(int n,int r)
{
	int j,k=1;
	for (j=1; j<= r; j++)
	k=(k*(n-j+1))/j;
	return k;
}


/**********************************************
*  This version of readConfiguration extracts *
*  the three parameters from a command line   *
*  It returns 1 if all is OK, else 0          *
**********************************************/

int readConfiguration2 (int argc, char**argv, int *p1,int *d, int *p2)
{
	if (argc != 4)
	  return 0;
	*p1 = argv[1][0] - '0';
	*d = argv[2][0] - '0';
	*p2 = argv[3][0] - '0';
	if (*p1==0 || *d ==0 || *p2 == 0)
	   return 0;
	if (*p1 > 8 || *d > 8 || *p2 > 8)
	   return 0;
	if (*p1+*p2+*d >= 12)
	   return 0;
	return 1;
}

