// Best discrimination with fixed overlap

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#define PI 3.141592654
			   /* Convenient to make these global */
double ** rho1;
double ** rho2;
double ** eigenvecs;
double * eigenvals;
double ** lambda;
#include "configuration.c"
#include "matops.c"
#include "utilities.c"
#include "jacobi.c"
#include "fobm.c"


double findBestDiscrimination(int p1, int d, int p2,double eta, double beta)
{
	double total=0;
	int size = power(2,p1+p2+d);
	int j,nrot=0;
	makeDensityMatricesForKnownOverlap(p1,d,p2, beta);
    matWeightedDifference(rho1,rho2,lambda,eta,size);
    jacobi(lambda,size,eigenvals,eigenvecs,&nrot);
    for (j=1; j<=size; j++)
    if (eigenvals[j] >0)
         total += eigenvals[j];
    else
         total -= eigenvals[j];
      return (0.5*(1-total));
}

/*************************************************************
*   Solves the problem for a given configuration of qbits .  *
*   Parameters are as follows:                               *
*         p1: Number of program qbits (left side)            *
*         db: Number of data bits in the middle              *
*         p2: Number of program qbits (right side)           *
*             (so that the total number of qbits is p1_p2_db *
*   rEta: Interval btween steps of eta (must be a sub-       *
*         multiple of 1)                                     *
*   rBeta Interval btween steps of beta (must be a sub-      *
*         multiple of pi)                                    *
*   ff : A file handle to write the answers as a matrix      *
*************************************************************/

  void solve(int p1, int db,int p2,double rEta, double rBeta, FILE * ff)
{     //1                     /*1*/
	double ** result;
	double eta,beta;
	int tc = floor(PI/rBeta + 0.0001);
	int ec = floor(1/rEta + 0.0001);
	int z,a,b,nrot,bc;
	char latexSpecifier[] = " &%1.3lf";
	char ordinarySpecifier[16];
    strcpy(ordinarySpecifier," %1.5lf");
	z = DECIMALS;   // Adjust the specifier if DECIMALS < 5
	while (z++ < 5)
		strcat(ordinarySpecifier," ");
/*  Print header */
	#ifdef LATEX
	   fprintf(ff,"$\\beta$     ");
	#else
	   fprintf(ff,"Beta      ");
	#endif

	for (bc = 1;bc<=tc; bc++)
	{      //2                     /* Lots of nonsense to get a good layout for the heading*/

		char dd[4];char head[20];
		char spaces[] = "          ";
		int a = bc; int b = tc;
	    #ifndef LATEX
		   if (DECIMALS >= 5)
		      spaces [DECIMALS-5] = '\0';
		   else
		      spaces[0] = '\0';
		#else
		   if (LATEXDECIMALS >= 3)
		      spaces [LATEXDECIMALS-3] = '\0';
		   else
		      spaces[0] = '\0';
	    #endif

		reduce(&a,&b);
		head[0]='\0';
		sprintf(head,"%s",spaces);
		if (a > 1)
		{
			sprintf(dd,"%d",a);
			strcat(head,dd);
		}
		else
	    strcat(head," ");
	    #ifndef LATEX
		strcat(head,"pi");
		#else
		strcat(head,"$\\pi$");
		#endif
		if (b>1)
		{ //3
			char tail[10];
			sprintf(tail,"%d",b);
			strcat(head,"/");
			strcat(head,tail);
			if(b<10) strcat (head," ");
		} //3
		else strcat(head,"  ");
		#ifndef LATEX
		fprintf(ff,"%s  ",head);
		#else
		fprintf(ff,"&%s",head);
		#endif

	}  //2
	#ifndef LATEX
	fprintf(ff,"\n\nEta\n");
	#else
	fprintf(ff,"\\\\\n\\hline\n$\\eta$");
	for (b=1; b<=tc; b++)
	   fprintf(ff,"&");
	fprintf(ff,"\\\\\n");
	#endif
	result = matrix(0,ec,1,tc);
	for (a=0; a<=ec;a++)
	{   //2      a is code for eta
		   printf("\n");
		   eta = a*rEta;
	       for(b=1;b<=tc; b++)
	       {  //3       b is code for theta
	           printf("*");
	           if(a==0 || a == ec)
	              result [a][b] = 0;
	            else
	            {
					beta = b*rBeta;
	                result[a][b] = findBestDiscrimination(p1,db,p2,eta,beta);
			   }
	       }  //3
		}  /* 2 */
                          // All results computed
    for (a=0; a<=ec;a++)
	{  // 2
		#ifndef LATEX
		ordinarySpecifier[4] = (char)(4+'0');
        fprintf(ff,ordinarySpecifier,a*rEta);
        #else
        fprintf(ff,"%1.2lf",a*rEta);
        #endif
	   for(b=1;b<=tc; b++)
	    #ifndef LATEX
		{
			ordinarySpecifier[4] = (char)(DECIMALS+'0');
	    	fprintf(ff,ordinarySpecifier,result[a][b]);
	    }
	    #else
        {
			latexSpecifier[5] = (char)(LATEXDECIMALS +'0');
		    fprintf(ff,latexSpecifier,result[a][b]);
        }
        #endif
 	    #ifndef LATEX
	    fprintf(ff,"\n");
	    #else
	    fprintf(ff,"\\\\\n");
	    #endif


	}  //2
}   /* 1 */



void main(int argc, char ** argv)
{


	FILE * ff;
	int a,b,size,nrot,ev,j;
	int p1,d,p2;
	int columns;
	char  fileName[100];
	char dump[20];
	time_t startTime = time(NULL);
	time_t endTime;

	columns = floor((PI+0.0001)/BETAINTERVAL);
	readConfiguration2(argc,argv,&p1,&d,&p2);
//	strcpy(fileName,TARGETFILE);
	strcpy(fileName,"fixedoverlapbest");
	sprintf(dump,"(%d,%d,%d).txt",p1,d,p2);
	strcat(fileName,dump);

	ff=fopen(fileName,"w");
	if(ff == NULL)
	{
		printf("Could not open file %s\n",fileName);
		exit(1);
	}
	else
	#ifndef LATEX
	    printf("Output will be sent to:\n   %s\n",fileName);
	#else
		    printf("Output will be sent to:\n   %s in LATEX format\n",fileName);
	#endif
    #ifndef LATEX
	fprintf(ff,"Fixed Overlap Optimum {%d,%d,%d}\n",p1,d,p2);
	#else
	fprintf(ff,"\\begin{table}[h]\n  \\begin{center}    \\begin {tabular}");
	{
		char zz[40];
		for (a=0; a<columns; a++) zz[a]='c';
		zz[a] = '\0';
		fprintf(ff,"{|l|%s|}\\hline\n",zz);
	}
	#endif
	size=power(2,p1+p2+d);
	rho1=matrix(1,size,1,size);
	rho2=matrix(1,size,1,size);
    lambda=matrix(1,size,1,size);
    eigenvecs=matrix(1,size,1,size);
	eigenvals = vector(1,size);
	solve(p1,d,p2,ETAINTERVAL,BETAINTERVAL,ff);
	#ifdef LATEX
	fprintf(ff,"\n\\hline\n\\end{tabular}\n\\caption{Fixed Overlap Optimum \\{%d,%d,%d\\}}\n",p1,d,p2);
	fprintf(ff,"\\end{center} \n");
	fprintf(ff,"\\end{table} \n");
	#endif
	endTime = time(NULL);
    printf("\nElapsed time = %ld seconds\n", endTime-startTime);
    fclose(ff);
}
