% chirag tanna - MSc. Bioengineering - University of Strathclyde -
% 2004/2005 - #200483574

function varargout = ECGGUIc(varargin)
% ECGGUIC M-file for ECGGUIc.fig
%      ECGGUIC, by itself, creates a new ECGGUIC or raises the existing
%      singleton*.
%
%      H = ECGGUIC returns the handle to a new ECGGUIC or the handle to
%      the existing singleton*.
%
%      ECGGUIC('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in ECGGUIC.M with the given input arguments.
%
%      ECGGUIC('Property','Value',...) creates a new ECGGUIC or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before ECGGUIc_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to ECGGUIc_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help ECGGUIc

% Last Modified by GUIDE v2.5 23-Aug-2005 02:10:20

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @ECGGUIc_OpeningFcn, ...
                   'gui_OutputFcn',  @ECGGUIc_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before ECGGUIc is made visible.
function ECGGUIc_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to ECGGUIc (see VARARGIN)

% Choose default command line output for ECGGUIc
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes ECGGUIc wait for user response (see UIRESUME)
% uiwait(handles.figure1);

set(gcf,'Color',[0 0.502 0.502]) %set background colour

% --- Outputs from this function are returned to the command line.
function varargout = ECGGUIc_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes during object creation, after setting all properties.
function file_input_CreateFcn(hObject, eventdata, handles)
% hObject    handle to file_input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function file_input_Callback(hObject, eventdata, handles)                          %for accepting filename from the user
% hObject    handle to file_input (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of file_input as text
%        str2double(get(hObject,'String')) returns contents of file_input as a double


% --- Executes during object creation, after setting all properties.

function start_t_CreateFcn(hObject, eventdata, handles)
% hObject    handle to start_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


function start_t_Callback(hObject, eventdata, handles)
% hObject    handle to start_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of start_t as text
%        str2double(get(hObject,'String')) returns contents of start_t as a double

start = get(handles.start_t,'String');            %accept start time for the time series representation
xmin = str2double(start);

% --- Executes during object creation, after setting all properties.
function end_t_CreateFcn(hObject, eventdata, handles)
% hObject    handle to end_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function end_t_Callback(hObject, eventdata, handles)
% hObject    handle to end_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of end_t as text
%        str2double(get(hObject,'String')) returns contents of end_t as a double

endd = get(handles.end_t,'String');    %stop time of the signal
xmax = str2double(endd);

% --- Executes on button press in plottime.
function plottime_Callback(hObject, eventdata, handles)
% hObject    handle to plottime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

figure(2)
set(gcf)
filename = get(handles.file_input,'String');     %read filename from the user
H = xlsread(filename);
D = H(:,2);

endd = get(handles.end_t,'String');              %stop time of the signal
xmax = str2double(endd);

start = get(handles.start_t,'String');           %start time of the signal
xmin = str2double(start);

plot(H,'Color',[1 0 0]);                         %plot the signal
box on ;
grid on;
xlim([xmin xmax]);                               %set limits of start and end time
xlabel('Time');
ylabel('Voltage');

Taf = H(2,1) - H(1,1);                           %time delay between 2 consecutive sampled signals
Freq = 1/Taf;                                    %frequency at which the signal is sampled
td = num2str(Taf);
sfq = num2str(Freq);                                    
str1 = sprintf('%s Hz.',sfq);
set(handles.Sampling_f,'String',str1);           %display sampling frequency
str2 = sprintf('%s sec.' ,Taf);
set(handles.delay_t,'String',str2);              %display time delay


% --- Executes during object creation, after setting all properties.
function Sampling_f_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Sampling_f (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function Sampling_f_Callback(hObject, eventdata, handles)                                 %to display the sampling frequency
% hObject    handle to Sampling_f (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Sampling_f as text
%        str2double(get(hObject,'String')) returns contents of Sampling_f as a double


% --- Executes during object creation, after setting all properties.
function delay_t_CreateFcn(hObject, eventdata, handles)
% hObject    handle to delay_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function delay_t_Callback(hObject, eventdata, handles)
% hObject    handle to delay_t (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of delay_t as text
%        str2double(get(hObject,'String')) returns contents of delay_t as a double


% --- Executes on button press in LPphmagnResp.
function LPphmagnResp_Callback(hObject, eventdata, handles)
% hObject    handle to LPphmagnResp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(findobj('Tag', 'loco'), 'Enable','off');
set(findobj('Tag', 'hico'), 'Enable','off');
set(findobj('Tag', 'co'), 'Enable','on');


% --- Executes during object creation, after setting all properties.
function co_CreateFcn(hObject, eventdata, handles)
% hObject    handle to co (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function co_Callback(hObject, eventdata, handles)
% hObject    handle to co (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of co as text
%        str2double(get(hObject,'String')) returns contents of co as a double


% --- Executes on button press in PlotPhMgnResp.
function PlotPhMgnResp_Callback(hObject, eventdata, handles)
% hObject    handle to PlotPhMgnResp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

fp = get(handles.co,'String');
fp = str2double(fp);

filename = get(handles.file_input,'String');               %accept filename from the user
H = xlsread(filename);
D = H(:,2);
Taf = H(2,1) - H(1,1);                           %time delay between 2 consecutive sampled signals
Freq = 1/Taf;                                    %frequency at which the signal is sampled

D = size(H);
K = D(1,1);

fs = Freq;
fsh = fs/2;
[b,a] = butter(12,fp/fsh);
figure(7);
M = 512;
freqz(b,a,M,fs);

% --- Executes on button press in spectrum.
function spectrum_Callback(hObject, eventdata, handles)
% hObject    handle to spectrum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

filename = get(handles.file_input,'String');           %accept filename from the user
H = xlsread(filename);
D = H(:,2);
Taf = H(2,1) - H(1,1);                           %time delay between 2 consecutive sampled signals
Freq = 1/Taf;                                    %frequency at which the signal is sampled

D = size(H);
K = D(1,1);

fs = Freq;
ecgft = fft(H);                                        %fourier transform of the signal
ff = fix(K/2) + 1;
f = [1:ff]*fs/K;
maxft = max(abs(ecgft));
ecgspec = 20*log10(abs(ecgft/maxft));

figure(6);
plot(f,ecgspec(1:ff),'Color',[0.851 0.278 0.035]);
xlabel('Freq. in Hz.');
ylabel('log magnitude spectrum(dB)');
box on;
grid on;


% --- Executes on button press in IIRHPB.
function IIRHPB_Callback(hObject, eventdata, handles)
% hObject    handle to IIRHPB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(findobj('Tag', 'loco'), 'Enable','on');
set(findobj('Tag', 'hico'), 'Enable','off');
set(findobj('Tag', 'co'), 'Enable','off');


% --- Executes on button press in togglebutton6.
function togglebutton6_Callback(hObject, eventdata, handles)
% hObject    handle to togglebutton6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes during object creation, after setting all properties.
function hico_CreateFcn(hObject, eventdata, handles)
% hObject    handle to hico (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function hico_Callback(hObject, eventdata, handles)                          %higher cutoff frequency for IIR LowPass Filter
% hObject    handle to hico (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of hico as text
%        str2double(get(hObject,'String')) returns contents of hico as a double


% --- Executes during object creation, after setting all properties.
function loco_CreateFcn(hObject, eventdata, handles)
% hObject    handle to loco (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end



function loco_Callback(hObject, eventdata, handles)
% hObject    handle to loco (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of loco as text
%        str2double(get(hObject,'String')) returns contents of loco as a double


% --- Executes on button press in IIRLPBUT.
function IIRLPBUT_Callback(hObject, eventdata, handles)
% hObject    handle to IIRLPBUT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

filename = get(handles.file_input,'String');                            %accept filename from the user
H = xlsread(filename);
Taf = H(2,1) - H(1,1);                           %time delay between 2 consecutive sampled signals
Freq = 1/Taf;                                    %frequency at which the signal is sampled

figure(9);
fp = get(handles.hico,'String');
fp = str2double(fp);

alphap = 0.4;                                       % passband attentuation
alphas = 50;                                        % stopband attentuation
fs = fp + 10;                                       % stopband frequency
f = Freq;                                            %sampling frequency
omp = 2*pi*fp/f;
oms = 2*pi*fs/f;
[n, wn] = buttord(omp/pi, oms/pi, alphap, alphas);
[b,a] = butter(n,wn,'low');

filename = get(handles.file_input,'String');            %accept filename from the user
H = xlsread(filename);
for i = 1:5                                             %running the filter 5 times for better effect of cascading
    fd = filter(b,a,H);
end;

endd = get(handles.end_t,'String');                     %accept stop time
xmax = str2double(endd);

start = get(handles.start_t,'String');                  %accept start time     
xmin = str2double(start);

plot(fd,'Color',[0.851 0.278 0.035]);
box on ;
grid on;
xlim([xmin xmax]);
xlabel('Time');
ylabel('Voltage');


% --- Executes on button press in IIRHPBUT.
function IIRHPBUT_Callback(hObject, eventdata, handles)
% hObject    handle to IIRHPBUT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

filename = get(handles.file_input,'String');                            %accept filename from the user
H = xlsread(filename);
Taf = H(2,1) - H(1,1);                           %time delay between 2 consecutive sampled signals
Freq = 1/Taf;                                    %frequency at which the signal is sampled

figure(10);
fp = get(handles.loco,'String');
fp = str2double(fp);
alphap = 0.4;                                                           % passband attentuation
alphas = 50;                                                            % stopband attentuation
fs = 1;                                                                 % stopband frequency
f = Freq;                                                                %sampling frequency
omp = 2*pi*fp/f;
oms = 2*pi*fs/f;
[n, wn] = buttord(omp/pi, oms/pi, alphap, alphas);                      %accept stop time
[b,a] = butter(n,wn,'high');

filename = get(handles.file_input,'String');                            %accept filename from the user
H = xlsread(filename);
for i = 1:5                                                             % running the filter 5 times for better effect of cascading       
    fd = filter(b,a,H);
end;

start = get(handles.start_t,'String');                                 %accept start time          
xmin = str2double(start);

endd = get(handles.end_t,'String');
xmax = str2double(endd);

plot(fd,'Color',[0.851 0.278 0.035]);
box on ;
grid on;
xlim([xmin xmax]);
xlabel('Time');
ylabel('Voltage');


% --- Executes on button press in FIRH.
function FIRH_Callback(hObject, eventdata, handles)
% hObject    handle to FIRH (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

figure(12);
filename = get(handles.file_input,'String');                   %accept filename from the user
H = xlsread(filename);
D = H(:,2);
W = H(:,1);
num = length(H);
fd = D;
for j = 1:5,
    xm2 = 0;
    xm1 = 0;
    for i = 1:num,
        xnt = fd(i);
        ynt = (xnt + 2*xm1 + xm2)/4;
        fd(i) = ynt;
        xm2 = xm1;
        xm1 = xnt;
    end;
end;
Q = [W fd];

endd = get(handles.end_t,'String');                   %accept stop time
xmax = str2double(endd);

start = get(handles.start_t,'String');                %accept start time
xmin = str2double(start);

plot(Q,'Color',[0.851 0.278 0.035]);
box on ;
grid on;
xlim([xmin xmax]);
xlabel('Time');
ylabel('Voltage');

% --- Executes on button press in FIRN.
function FIRN_Callback(hObject, eventdata, handles)
% hObject    handle to FIRN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

figure(13);
filename = get(handles.file_input,'String');                %accept filename from the user
H = xlsread(filename);
D = H(:,2);
W = H(:,1);
num = length(H);
fd = D;
xm2 = 0;
xm1 = 0;
for i = 1:num,
    xnt = fd(i);
    ynt = (xnt+(2*xm1)+xm2)/3;
    fd(i) = ynt;
    xm2 = xm1;
    xm1 = xnt;
end;
Q = [W fd];

endd = get(handles.end_t,'String');                    %accept stop time  
xmax = str2double(endd);

start = get(handles.start_t,'String');                 %accept start time  
xmin = str2double(start);

plot(Q,'Color',[0.851 0.278 0.035]);
box on ;
grid on;
xlim([xmin xmax]);
xlabel('Time');
ylabel('Voltage');

% --- Executes on button press in d1T.
function d1T_Callback(hObject, eventdata, handles)
% hObject    handle to d1T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d1T

set(handles.d1T,'Value',1);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);

% --- Executes on button press in d2T.
function d2T_Callback(hObject, eventdata, handles)
% hObject    handle to d2T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d2T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',1);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);

% --- Executes on button press in d3T.
function d3T_Callback(hObject, eventdata, handles)
% hObject    handle to d3T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d3T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',1);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);

% --- Executes on button press in d4T.
function d4T_Callback(hObject, eventdata, handles)
% hObject    handle to d4T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d4T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',1);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);

% --- Executes on button press in d5T.
function d5T_Callback(hObject, eventdata, handles)
% hObject    handle to d5T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d5T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',1);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);

% --- Executes on button press in d6T.
function d6T_Callback(hObject, eventdata, handles)
% hObject    handle to d6T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d6T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',1);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);


% --- Executes on button press in d8T.
function d8T_Callback(hObject, eventdata, handles)
% hObject    handle to d8T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d8T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',1);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);

% --- Executes on button press in d10T.
function d10T_Callback(hObject, eventdata, handles)
% hObject    handle to d10T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d10T


set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',1);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);


% --- Executes on button press in d16T.
function d16T_Callback(hObject, eventdata, handles)
% hObject    handle to d16T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d16T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',1);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);

% --- Executes on button press in d32T.
function d32T_Callback(hObject, eventdata, handles)
% hObject    handle to d32T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d32T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',1);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',0);


% --- Executes on button press in d64T.
function d64T_Callback(hObject, eventdata, handles)
% hObject    handle to d64T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d64T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',1);
set(handles.d100T,'Value',0);


% --- Executes on button press in d100T.
function d100T_Callback(hObject, eventdata, handles)
% hObject    handle to d100T (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of d100T

set(handles.d1T,'Value',0);
set(handles.d2T,'Value',0);
set(handles.d3T,'Value',0);
set(handles.d4T,'Value',0);
set(handles.d5T,'Value',0);
set(handles.d6T,'Value',0);
set(handles.d8T,'Value',0);
set(handles.d10T,'Value',0);
set(handles.d16T,'Value',0);
set(handles.d32T,'Value',0);
set(handles.d64T,'Value',0);
set(handles.d100T,'Value',1);

% --- Executes on button press in D2.
function D2_Callback(hObject, eventdata, handles)
% hObject    handle to D2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

figure(3)
set(gcf)
filename = get(handles.file_input,'String');            %accept filename from the user
H = xlsread(filename);

%select a multiple of time delay for the signal

     Hli_1 = get(handles.d1T,'Value');
if Hli_1 == 1;
    delay = 1;
else Hli_2 = get(handles.d2T,'Value');
if Hli_2 == 1;
    delay = 2;
else Hli_3 = get(handles.d3T,'Value');
if Hli_3 == 1;
    delay = 3;
else Hli_4 = get(handles.d4T,'Value');
if Hli_4 == 1;
    delay = 4;
else Hli_5 = get(handles.d5T,'Value');
if Hli_5 == 1;
    delay = 5;
else Hli_6 = get(handles.d6T,'Value');
if Hli_6 == 1;
    delay = 6;
else Hli_7 = get(handles.d8T,'Value');
if Hli_7 == 1;
    delay = 8;
else Hli_8 = get(handles.d10T,'Value');
if Hli_8 == 1;
    delay = 10;
else Hli_9 = get(handles.d16T,'Value');
if Hli_9 == 1;
    delay = 16;
else Hli_10 = get(handles.d32T,'Value');
if Hli_10 == 1;
    delay = 32;
else Hli_11 = get(handles.d64T,'Value');
if Hli_11 == 1;
    delay = 64;
else Hli_12 = get(handles.d100T,'Value');
if Hli_12 == 1;
    delay = 100;
end
end
end
end
end
end
end
end
end
end
end
end

%code to represent the 2D state space representation

D = size(H);
K = D(1,1);
B = K-delay;
C = H(1:B,2);
start = delay + 1;
E = H(start:K,2);
F = [C E];
plot (F(:,1),F(:,2),'Color',[1 0 0]);
box on;
grid on;
xlabel('Voltage');
ylabel('Voltage');


% --- Executes on button press in D3.
function D3_Callback(hObject, eventdata, handles)
% hObject    handle to D3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

figure(4)
set(gcf)
filename = get(handles.file_input,'String');         %accept filename from the user
H = xlsread(filename);
D = H(:,2);
Taf = H(2,1) - H(1,1);

%select a multiple of time delay for the signal

    Hli_1 = get(handles.d1T,'Value');
if Hli_1 == 1;
    delay = 1;
else Hli_2 = get(handles.d2T,'Value');
if Hli_2 == 1;
    delay = 2;
else Hli_3 = get(handles.d3T,'Value');
if Hli_3 == 1;
    delay = 3;
else Hli_4 = get(handles.d4T,'Value');
if Hli_4 == 1;
    delay = 4;
else Hli_5 = get(handles.d5T,'Value');
if Hli_5 == 1;
    delay = 5;
else Hli_6 = get(handles.d6T,'Value');
if Hli_6 == 1;
    delay = 6;
else Hli_7 = get(handles.d8T,'Value');
if Hli_7 == 1;
    delay = 8;
else Hli_8 = get(handles.d10T,'Value');
if Hli_8 == 1;
    delay = 10;
else Hli_9 = get(handles.d16T,'Value');
if Hli_9 == 1;
    delay = 16;
else Hli_10 = get(handles.d32T,'Value');
if Hli_10 == 1;
    delay = 32;
else Hli_11 = get(handles.d64T,'Value');
if Hli_11 == 1;
    delay = 64;
else Hli_12 = get(handles.d100T,'Value');
if Hli_12 == 1;
    delay = 100;
end
end
end
end
end
end
end
end
end
end
end
end

%code to represent the 3D state space representation

D = size(H);
K = D(1,1);
start = delay+1;
G = 2*delay;
W = K-G;
P = H(1:W,2);
middle = K-delay;
Q = H(start:middle,2);
last = 1+G;
R = H(last:K,2);
plot3(P,Q,R,'Color',[1 0 0]);
set(gca)
box on;
grid on;
xlabel('Voltage');
ylabel('Voltage');
zlabel('Voltage');



% --- Executes on button press in IIRLPB.
function IIRLPB_Callback(hObject, eventdata, handles)
% hObject    handle to IIRLPB (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

set(findobj('Tag', 'loco'), 'Enable','off');
set(findobj('Tag', 'hico'), 'Enable','on');
set(findobj('Tag', 'co'), 'Enable','off');




