C      THICK SHELL ANALYSIS PROGRAM
C********************************************************************
C
C   THIS PROGRAM CALCULATES THE CELL CENTRE DISPLACEMENTS AND ROTATIONS 
C   IN A THICK CYLINDRICAL SHELL USING TEN DISCRETISED FINITE VOLUME
C   EQUATIONS
C
C*********************************************************************
C    DECLARE DOUBLE PRECISION FOR ALL REAL :IMPLICIT REAL*8 (A-H,O-Z)
C********************************************************

      DIMENSION AA(10,9),BB(10,9),C(10,9),DD(10,9),E(10,9),F(5),
     1     G(16),TM(15),EC1(5,5),EC2(5,5),EC3(5,5),
     1     EC4(5,5),EC5(5,5),EC6(5,5),EC7(5,5),EC8(5,5),EC9(5,5),
     1     BC1(5,5),BC2(5,5),BC3(5,5),BC4(5,5),BC5(5,5),BC6(5,5),
     1     BC7(5,5),BC8(5,5),BC9(5,5),STIFF(1000,1000),
     1     RHSMAT(1000),MCELL(100,500),NCC(500,8),NZ(9,500),
     1     INDX(1000),STIFF1(1000,1000),KANS(5)

      REAL KMOD,KS

      OPEN(UNIT=3,FILE='test.inp',STATUS='UNKNOWN')

      PRINT *,'ENTER NUMBER OF RINGS ON CYLINDER, NX'
      READ *, NX
      PRINT *,'ENTER NUMBER OF CELLS ON EACH RING, NTTA'
      READ *, NTTA
      PRINT *,'ENTER THICKNESS OF CYLINDER, T '
      READ *, T
      PRINT *,'ENTER RADIUS OF CYLINDER, RAD '
      READ *, RAD
      PRINT *,'ENTER ELASTIC MODULUS OF MATERIAL OF CYLINDER,EMOD'
      READ *, EMOD
      PRINT *,'ENTER POISSON RATIO, PNU'
      READ *, PNU
      PRINT *,'ENTER LENGTH OF CYLINDER, CLENTH '
      READ *, CLENTH
      PRINT *,'ENTER VALUE FOR AXIAL PRESSURE, PX '
      READ *, PX
      PRINT *,'ENTER VALUE FOR TANGENTIAL PRESSURE, PTTA '
      READ *, PTTA
      PRINT *,'ENTER VALUE FOR RADIAL PRESSURE, PZ '
      READ *, PZ

C IMPOSING EITHER LOAD OR DISPLACEMENT BOUNDARY CONDITION ON CYLINDER

      PRINT *,'ENTER VALUE FOR FORCE/DISPLACEMENT IN X-DXN, FX'
      READ *, FX
      PRINT *,'IF FX IS A FORCE B.C. ENTER 1 AND IF FX IS A DISPLACEMENT
     1          B.C. ENTER 2'
      READ *, KANS(1)

      PRINT *,'ENTER VALUE FOR FORCE/DISPLACEMENT IN TTA-DXN, FTTAX'
      READ *, FTTAX
      PRINT *,'IF FTTAX IS A FORCE B.C. ENTER 1 AND IF FTTAX IS A DISPLACEMENT
     1          B.C. ENTER 2'
      READ *, KANS(2)

      PRINT *,'ENTER VALUE FOR BENDING MOMENT/DISPLACEMENT IN 
     1          X-DXN,BMX'
      READ *, BMX
      PRINT *,'IF BMX IS A FORCE B.C. ENTER 1 AND IF BMX IS A DISPLACEMENT
     1          B.C. ENTER 2'
      READ *, KANS(3)

      PRINT *,'ENTER VALUE FOR BENDING MOMENT/DISPLACEMENT IN 
     1         TTA-DXN,BMTTAX'
      READ *, BMTTAX
      PRINT *,'IF BMTTAX IS A FORCE B.C. ENTER 1 AND IF BMTTAX IS A 
     1       DISPLACEMENT  B.C. ENTER 2'
      READ *, KANS(4)

      PRINT *,'ENTER VALUE FOR TRANSVERSE FORCE/DISPLACEMENT IN RADIAL-DXN,
     1           QXZ'
      READ *, QXZ
      PRINT *,'IF QXZ IS A FORCE B.C. ENTER 1 AND IF QXZ IS A DISPLACEMENT
     1          B.C. ENTER 2'
      READ *, KANS(5)

  
      PRINT *,'INPUT VALUES ACCEPTED'
      PI=3.1416
      DTTA=2.0*PI/NTTA
      DX=CLENTH/NX


      PRINT *,'  '
C     CREATING RING OF CELLS
      DO 41 J=0,NX+1,1
       DO 41 I=1,NTTA
        MCELL(J+1,I)=J*NTTA+I
41    CONTINUE

C      DO 42 I=1,NTTA
C     WRITE (3,*) (MCELL(J,I),J=1,NX+2)
C42    CONTINUE  

      PRINT *, MCELL(1,10)
C  END OF MESH GENERATOR PROGRAM 

C     SURROUNDING CELL COUNTER FOR FIRST RING
C    CELL NUMBERS I=2 TO NTTA-1, J=1
      DO 43 I=2,NTTA-1
       IF(2 .LE. MCELL(1,I) .AND. MCELL(1,I) .LE. NTTA-1) THEN
          NCC(I,1)=I+1
          NCC(I,2)=NTTA+I    
          NCC(I,3)=I-1
          NCC(I,4)=NX*NTTA+I
          NCC(I,5)=NX*NTTA+I+1
          NCC(I,6)=NTTA+I+1
          NCC(I,7)=NTTA+I-1
          NCC(I,8)=NX*NTTA+I-1
       END IF
43    CONTINUE

C   SURROUNDING CELL COUNTER FOR CELL NUMBER 1
C     J=1, 1=1
       IF (MCELL(1,1) .EQ. 1) THEN
             NCC(1,1)=2
             NCC(1,2)=NTTA+1    
             NCC(1,3)=NTTA
             NCC(1,4)=NX*NTTA+1
             NCC(1,5)=NX*NTTA+2
             NCC(1,6)=NTTA+2
             NCC(1,7)=2*NTTA
             NCC(1,8)=(NX+1)*NTTA
       END IF
C   SURROUNDING CELLS OF CELL NUMBER NTTA
C     J=1 AND I=NTTA
       IF (MCELL(1,NTTA) .EQ. NTTA) THEN
            NCC(NTTA,1)=1
            NCC(NTTA,2)=2*NTTA    
            NCC(NTTA,3)=NTTA-1
            NCC(NTTA,4)=(NX+1)*NTTA
            NCC(NTTA,5)=NX*NTTA+1
            NCC(NTTA,6)=NTTA+1
            NCC(NTTA,7)=2*NTTA-1
            NCC(NTTA,8)=(NX+1)*NTTA-1
       END IF           

C
C   SURROUNDING CELL COUNTER FOR INTERNAL CELLS
      DO 44 J=1,NX-1
       DO 44 I=2,NTTA-1
        IF (NTTA+2 .LE. MCELL(J,I) .AND. MCELL(J,I) .LE.
     1          (NX-1)*NTTA-1) THEN
             IF (MCELL(J,I) .NE. J*NTTA) THEN  
               IF (MCELL(J,I) .NE. J*NTTA+1) THEN 

                 NCC((J-1)*NTTA+I,1)=(J-1)*NTTA+I+1
                 NCC((J-1)*NTTA+I,2)=J*NTTA+I   
                 NCC((J-1)*NTTA+I,3)=(J-1)*NTTA+I-1
                 NCC((J-1)*NTTA+I,4)=(J-2)*NTTA+I 
                 NCC((J-1)*NTTA+I,5)=(J-2)*NTTA+I+1
                 NCC((J-1)*NTTA+I,6)=J*NTTA+I+1
                 NCC((J-1)*NTTA+I,7)=J*NTTA+I-1
                 NCC((J-1)*NTTA+I,8)=(J-2)*NTTA+I-1
               END IF 
             END IF
        END IF   
44     CONTINUE

C   SURROUNDING CELL COUNTER FOR FIRST EDGE CELLS (ALONG CYLINDER)
C    I=1
      DO 45 J=2,NX-1
       IF (NTTA+1 .LE. MCELL(J,1) .AND. MCELL(J,1) .LE.
     1       (NX-2)*NTTA+1) THEN  
               
                NCC((J-1)*NTTA+1,1)=(J-1)*NTTA+2
                NCC((J-1)*NTTA+1,2)=J*NTTA+1   
                NCC((J-1)*NTTA+1,3)=J*NTTA
                NCC((J-1)*NTTA+1,4)=(J-2)*NTTA+1 
                NCC((J-1)*NTTA+1,5)=(J-2)*NTTA+2
                NCC((J-1)*NTTA+1,6)=J*NTTA+2
                NCC((J-1)*NTTA+1,7)=(J+1)*NTTA
                NCC((J-1)*NTTA+1,8)=(J-1)*NTTA

      END IF
45    CONTINUE

C   SURROUNDING CELL COUNTER FOR LAST EDGE CELLS (ALONG CYLINDER)
C    I=NTTA
      DO 46 J=2,NX-1
       IF (2*NTTA .LE. MCELL(J,NTTA) .AND. MCELL(J,NTTA) .LE.
     1      (NX-1)*NTTA) THEN
                 
                   NCC(J*NTTA,1)=(J-1)*NTTA+1
                   NCC(J*NTTA,2)=(J+1)*NTTA   
                   NCC(J*NTTA,3)=J*NTTA-1
                   NCC(J*NTTA,4)=(J-1)*NTTA 
                   NCC(J*NTTA,5)=(J-2)*NTTA+1
                   NCC(J*NTTA,6)=J*NTTA+1
                   NCC(J*NTTA,7)=(J+1)*NTTA-1
                   NCC(J*NTTA,8)=(J-1)*NTTA-1 

       END IF
46    CONTINUE

C   SURROUNDING CELL COUNTER FOR LAST RING CELLS
C   J=NX
      DO 47 I=2,NTTA-1 
       IF ((NX-1)*NTTA+2 .LE. MCELL(NX,I) .AND.
     1     MCELL(NX,I) .LE. NX*NTTA-1) THEN  
               
            NCC((NX-1)*NTTA+I,1)=(NX-1)*NTTA+I+1
            NCC((NX-1)*NTTA+I,2)=(NX+1)*NTTA+I  
            NCC((NX-1)*NTTA+I,3)=(NX-1)*NTTA+I-1
            NCC((NX-1)*NTTA+I,4)=(NX-2)*NTTA+I 
            NCC((NX-1)*NTTA+I,5)=(NX-2)*NTTA+I+1
            NCC((NX-1)*NTTA+I,6)=(NX+1)*NTTA+I+1
            NCC((NX-1)*NTTA+I,7)=(NX+1)*NTTA+I-1
            NCC((NX-1)*NTTA+I,8)=(NX-2)*NTTA+I-1 
       END IF

47    CONTINUE

C   SURROUNDING CELL COUNTER FOR FIRST CELL OF LAST RING
C  I=1, J=NX

      IF (MCELL(NX,1) .EQ. (NX-1)*NTTA+1) THEN
C             
              NCC((NX-1)*NTTA+1,1)=(NX-1)*NTTA+2
              NCC((NX-1)*NTTA+1,2)=(NX+1)*NTTA+1  
              NCC((NX-1)*NTTA+1,3)=NX*NTTA
              NCC((NX-1)*NTTA+1,4)=(NX-2)*NTTA+1 
              NCC((NX-1)*NTTA+1,5)=(NX-2)*NTTA+2
              NCC((NX-1)*NTTA+1,6)=(NX+1)*NTTA+2
              NCC((NX-1)*NTTA+1,7)=(NX+2)*NTTA
              NCC((NX-1)*NTTA+1,8)=(NX-1)*NTTA

       END IF 

C   SURROUNDING CELL COUNTER FOR LAST CELL OF LAST RING
C  I=NTTA , J=NX

      IF (MCELL(NX,NTTA) .EQ. NX*NTTA) THEN
                          
          NCC(NX*NTTA,1)=(NX-1)*NTTA+1
          NCC(NX*NTTA,2)=(NX+2)*NTTA  
          NCC(NX*NTTA,3)=NX*NTTA-1
          NCC(NX*NTTA,4)=(NX-1)*NTTA 
          NCC(NX*NTTA,5)=(NX-2)*NTTA+1
          NCC(NX*NTTA,6)=(NX+1)*NTTA+1
          NCC(NX*NTTA,7)=(NX+2)*NTTA-1
          NCC(NX*NTTA,8)=(NX-1)*NTTA-1
        
      END IF

C   SURROUNDING CELL COUNTER FOR FIRST CELL OF FIRST RING BOUNDARY ELEMENTS
C  I=1  J=NX+1

      IF (MCELL(NX+1,1) .EQ. NX*NTTA+1) THEN
C             
              NCC(NX*NTTA+1,1)=NX*NTTA+2
              NCC(NX*NTTA+1,2)=1
              NCC(NX*NTTA+1,3)=(NX+1)*NTTA
              NCC(NX*NTTA+1,4)=0
              NCC(NX*NTTA+1,5)=0
              NCC(NX*NTTA+1,6)=2
              NCC(NX*NTTA+1,7)=NTTA
              NCC(NX*NTTA+1,8)=0

       END IF 


C   SURROUNDING CELL COUNTER FOR FIRST RING BOUNDARY ELEMENTS
C   J=NX+1
      DO 48 I=2,NTTA-1 
       IF (NX*NTTA+2 .LE. MCELL(NX+1,I) .AND.
     1     MCELL(NX+1,I) .LE. (NX+1)*NTTA-1) THEN  
               
            NCC(NX*NTTA+I,1)=NX*NTTA+I+1
            NCC(NX*NTTA+I,2)=I  
            NCC(NX*NTTA+I,3)=NX*NTTA+I-1
            NCC(NX*NTTA+I,4)=0 
            NCC(NX*NTTA+I,5)=0
            NCC(NX*NTTA+I,6)=I+1
            NCC(NX*NTTA+I,7)=I-1
            NCC(NX*NTTA+I,8)=0 
       END IF

48    CONTINUE



C   SURROUNDING CELL COUNTER FOR LAST CELL OF FIRST RING BOUNDARY ELEMENTS
C  I=NTTA  J=NX+1

      IF (MCELL(NX+1,NTTA) .EQ. (NX+1)*NTTA) THEN
C             
              NCC((NX+1)*NTTA,1)=NX*NTTA+1
              NCC((NX+1)*NTTA,2)=NTTA
              NCC((NX+1)*NTTA,3)=(NX+1)*NTTA-1
              NCC((NX+1)*NTTA,4)=0
              NCC((NX+1)*NTTA,5)=0
              NCC((NX+1)*NTTA,6)=1
              NCC((NX+1)*NTTA,7)=NTTA-1
              NCC((NX+1)*NTTA,8)=0

       END IF 


C   SURROUNDING CELL COUNTER FOR FIRST CELL OF LAST RING BOUNDARY ELEMENTS
C  I=1  J=NX+2

      IF (MCELL(NX+2,1) .EQ. (NX+1)*NTTA+1) THEN

          NCC((NX+1)*NTTA+1,1)=(NX+1)*NTTA+2
          NCC((NX+1)*NTTA+1,2)=0
          NCC((NX+1)*NTTA+1,3)=(NX+2)*NTTA
          NCC((NX+1)*NTTA+1,4)=(NX-1)*NTTA+1
          NCC((NX+1)*NTTA+1,5)=(NX-1)*NTTA+2
          NCC((NX+1)*NTTA+1,6)=0
          NCC((NX+1)*NTTA+1,7)=0
          NCC((NX+1)*NTTA+1,8)=NX*NTTA 
      END IF            

C   SURROUNDING CELL COUNTER FOR LAST RING BOUNDARY ELEMENTS
C   J=NX+2
      DO 49 I=2,NTTA-1 
       IF ((NX+1)*NTTA+2 .LE. MCELL(NX+2,I) .AND.
     1     MCELL(NX+2,I) .LE. (NX+2)*NTTA-1) THEN  
               
         NCC((NX+1)*NTTA+I,1)=(NX+1)*NTTA+I+1
         NCC((NX+1)*NTTA+I,2)=0  
         NCC((NX+1)*NTTA+I,3)=(NX+1)*NTTA+I-1
         NCC((NX+1)*NTTA+I,4)=(NX-1)*NTTA+I 
         NCC((NX+1)*NTTA+I,5)=(NX-1)*NTTA+I+1
         NCC((NX+1)*NTTA+I,6)=0
         NCC((NX+1)*NTTA+I,7)=0
         NCC((NX+1)*NTTA+I,8)=(NX-1)*NTTA+I-1 
       END IF

49    CONTINUE


C   SURROUNDING CELL COUNTER FOR LAST CELL OF LAST RING BOUNDARY ELEMENTS
C  I=NTTA  J=NX+2

      IF (MCELL(NX+2,NTTA) .EQ. (NX+2)*NTTA) THEN

      NCC((NX+2)*NTTA,1)=(NX+1)*NTTA+1
      NCC((NX+2)*NTTA,2)=0  
      NCC((NX+2)*NTTA,3)=(NX+2)*NTTA-1
      NCC((NX+2)*NTTA,4)=NX*NTTA 
      NCC((NX+2)*NTTA,5)=(NX-1)*NTTA+1
      NCC((NX+2)*NTTA,6)=0
      NCC((NX+2)*NTTA,7)=0
      NCC((NX+2)*NTTA,8)=NX*NTTA-1 
      END IF             


C      WRITE (3,*)  'SURROUNDING CELL COUNTER FOR FIRST RING'

C      DO 50 I=2,NTTA-1
C       WRITE (3,*) (NCC(I,K),K=1,8)
C50    CONTINUE

C      WRITE (3,*)  'SURROUNDING CELL COUNTER FOR FIRST CELL'
C       WRITE (3,*) (NCC(1,K),K=1,8)

C      WRITE (3,*) 'SURROUNDING CELL COUNTER FOR LAST CELL ON FIRST RING'
C       WRITE (3,*) (NCC(NTTA,K),K=1,8)

C      WRITE (3,*)  'SURROUNDING CELL COUNTER FOR INTERNAL CELLS'

C       DO 51 J=2,NX-1
C       DO 51 I=2,NTTA-1
C      WRITE (3,*) (NCC((J-1)*NTTA+I,K),K=1,8)
C51    CONTINUE

C      WRITE (3,*)  'SURROUNDING CELL COUNTER FOR FIRST EDGE CELLS'

C      DO 52 J=2,NX-1
    
C       WRITE (3,*) (NCC((J-1)*NTTA+1,K),K=1,8)
C52    CONTINUE

C     WRITE (3,*)  'SURROUNDING CELL COUNTER FOR LAST EDGE CELLS'

C      DO 53 J=2,NX-1
    
C       WRITE (3,*) (NCC(J*NTTA,K),K=1,8)
C53    CONTINUE

C      WRITE (3,*)  'SURROUNDING CELL COUNTER FOR LAST RING'

C      DO 54 I=2,NTTA-1
C       WRITE (3,*) (NCC((NX-1)*NTTA+I,K),K=1,8)
C54    CONTINUE

C      WRITE (3,*) 'SURROUNDING CELL COUNTER FOR FIRST CELL ON LAST RING'
C       WRITE (3,*) (NCC((NX-1)*NTTA+1,K),K=1,8)

C      WRITE (3,*) 'SURROUNDING CELL COUNTER FOR LAST CELL ON LAST RING'
C       WRITE (3,*) (NCC(NX*NTTA,K),K=1,8)



C       DO 55 I=1,(NX+2)*NTTA 
C       WRITE (3,*) (NCC(I,J),J=1,8)
C55   CONTINUE
C ************************************************************************

      PRINT *,'END OF CELL COUNTER'
      PRINT *,'   '
C ASSIGN A VECTOR Z TO EACH COLUMN OF SURROUNDING CELL COUNTER

      DO 56 I=1,(NX+2)*NTTA
       NZ(1,I)=I
       NZ(2,I)=NCC(I,1)
       NZ(4,I)=NCC(I,3)
       IF (NX*NTTA .LT. I .AND. I .LE. (NX+1)*NTTA) THEN
         NZ(5,I)=0
         NZ(6,I)=0
         NZ(9,I)=0
       ELSE
         NZ(5,I)=NCC(I,4)
         NZ(6,I)=NCC(I,5)
         NZ(9,I)=NCC(I,8)
       END IF
       IF ((NX+1)*NTTA .LT. I .AND. I .LE. (NX+2)*NTTA) THEN
         NZ(3,I)=0
         NZ(7,I)=0
         NZ(8,I)=0
       ELSE
         NZ(3,I)=NCC(I,2)
         NZ(7,I)=NCC(I,6)
         NZ(8,I)=NCC(I,7)
       END IF
56    CONTINUE

C     WRITE (3,*) ((NZ(J,I),I=1,(NX+2)*NTTA),J=1,9)      


      PRINT *,'STARTING STIFF'
      PRINT *,'    '

C  INITIALIZATION OF STIFFNESS MATRIX      
      DO 57 I=1,5*NTTA*(NX+2)
       DO 57 J=1,5*NTTA*(NX+2)
         STIFF(I,J)=0.0 
57    CONTINUE



      PRINT *,'STIFF INITIALISED'
      PRINT *,'   '
      DO 670 I=1,(NX+2)*NTTA
      DX2=DX
      DX4=DX
        IF (1 .LE. I .AND. I .LE. NTTA) THEN
          DX4=DX/2
        END IF
         IF ((NX-1)*NTTA+1 .LE. I .AND. I .LE. NX*NTTA) THEN
          DX2=DX/2
         END IF
      DTTAY1=DTTA
      DTTAY3=DTTA
      H=(T/RAD)**2/12.0
      DR=EMOD*T/(1.0-PNU**2)
      DS=EMOD*T/(2.0*(1+PNU))
      KMOD=EMOD*(T**3)/(12.0*(1-PNU**2))
      KS=EMOD*(T**3)/(12.0*(1+PNU))
      FTTAE=DTTA/(DTTA+DTTAY1)
      FTTAW=DTTA/(DTTA+DTTAY3)
      FXN=DX/(DX+DX2)
      FXS=DX/(DX+DX4)
C
C
      G(1)=(1.0-FTTAE)*FXS
      G(2)=(1.0-FTTAE)*(1.0-FXN)
      G(3)=FTTAW*(1.0-FXN)
      G(4)=FTTAW*FXS
      G(5)=FTTAE*FXS
      G(6)=FTTAE*(1.0-FXN)
      G(7)=(1.0-FTTAE)*FXN
      G(8)=FTTAW*FXN
      G(9)=(1.0-FTTAW)*(1.0-FXN)
      G(10)=(1.0-FTTAW)*FXS
      G(11)=FTTAW*(1.0-FXS)
      G(12)=(1.0-FTTAE)*(1.0-FXS)
      G(13)=FTTAE*(1.0-FXS)
      G(14)=FTTAE*FXN
      G(15)=(1.0-FTTAW)*FXN
      G(16)=(1.0-FTTAW)*(1.0-FXS)
C
      TM(1)=PNU*DR-DS-H*DS
      TM(2)=PNU*DR*DTTA/2.0
      TM(3)=DS*H*RAD
      TM(4)=PNU*DR-DS
      TM(5)=DR*DX*(1.0+H)/(2.0*RAD)
      TM(6)=DS*DX*(1.0+H)/(2.0*RAD)
      TM(7)=DS*RAD*DTTA/2.0
      TM(8)=DS*DX*(1.0+H)/2.0
      TM(9)=DS*DX*DTTA*(1.0+H)/4.0
      TM(10)=KMOD*DX/(2.0*RAD**2)
      TM(11)=PNU*KMOD
      TM(12)=RAD*TM(9)
      TM(13)=KS/(2.0*RAD)
      TM(14)=DS*RAD*DTTA*DX/4.0
      TM(15)=PNU*KMOD+KS

      PRINT *,' THIS IS LINE 133'
C 
      AA(1,1)=(DS*DX/(RAD*DTTAY1))+(DS*H*DX/(RAD*DTTAY1))-
     1       (DR*RAD*DTTA/DX2)+(DS*DX/(RAD*DTTAY3))+
     1       (DS*H*DX/(RAD*DTTAY3))-(DR*RAD*DTTA/DX4)
      AA(1,2)=(-DS*DX/(RAD*DTTAY1))*(1.0+H)
      AA(1,3)=DR*RAD*DTTA/DX2
      AA(1,4)=(-DS*DX/(RAD*DTTAY3))*(1.0+H)
      AA(1,5)=DR*RAD*DTTA/DX4
      DO 13 J=6,9
       AA(1,J)=0.0
13    CONTINUE

      PRINT *,' THIS IS LINE 89'

      AA(2,1)=TM(4)*(-G(1)+G(2)-G(3)+G(4))
      AA(2,2)=TM(4)*(-G(5)+G(6))
      AA(2,3)=TM(4)*(G(7)-G(8))
      AA(2,4)=TM(4)*(-G(9)+G(10))
      AA(2,5)=TM(4)*(G(11)-G(12))
      AA(2,6)=TM(4)*-G(13)
      AA(2,7)=TM(4)*G(14)
      AA(2,8)=TM(4)*-G(15)
      AA(2,9)=TM(4)*G(16)
      DO 14 J=1,9
       AA(3,J)=0.0
14    CONTINUE
      DO 15 J=1,9
       AA(4,J)=0.0
15    CONTINUE

      PRINT *,' THIS IS LINE 164'

      AA(5,1)=-(KS*DX/(2.0*(RAD**2)*DTTAY1))-(KMOD*DTTA/DX2)-
     1        (KS*DX/(2.0*(RAD**2)*DTTAY3))-(KMOD*DTTA/DX4)
      AA(5,2)=KS*DX/(2.0*(RAD**2)*DTTAY1)
      AA(5,3)=KMOD*DTTA/DX2
      AA(5,4)=KS*DX/(2.0*(RAD**2)*DTTAY3)
      AA(5,5)=KMOD*DTTA/DX4
      DO 16 J=6,9
       AA(5,J)=0.0
16    CONTINUE
      AA(6,1)=-2.0*DR/DX
      AA(6,2)=0.0
      AA(6,3)=2.0*DR/DX
      DO 17 J=4,9
       AA(6,J)=0.0
17    CONTINUE
      AA(7,1)=0.0
      AA(7,2)=0.0
      AA(7,3)=DS*(1.0+H)*(1.0-FTTAE-FTTAW)/(RAD*DTTA)
      AA(7,4)=0.0
      AA(7,5)=0.0
      AA(7,6)=0.0
      AA(7,7)=DS*(1.0+H)*FTTAE/(RAD*DTTA)
      AA(7,8)=-DS*(1.0+H)*(1.0-FTTAW)/(RAD*DTTA)
      AA(7,9)=0.0
      AA(8,1)=-2*KMOD/(RAD*DX)
      AA(8,2)=0.0
      AA(8,3)=2*KMOD/(RAD*DX)
      DO 18 J=4,9
       AA(8,J)=0.0
18    CONTINUE
      AA(9,1)=0.0
      AA(9,2)=0.0
      AA(9,3)=KS*(-1.0+FTTAE+FTTAW)/(2.0*(RAD**2)*DTTA)
      AA(9,4)=0.0
      AA(9,5)=0.0
      AA(9,6)=0.0
      AA(9,7)=-KS*FTTAE/(2.0*(RAD**2)*DTTA)
      AA(9,8)=KS*(1.0-FTTAW)/(2.0*(RAD**2)*DTTA)
      AA(9,9)=0.0
      DO 19 J=1,9
       AA(10,J)=0.0
19    CONTINUE

      PRINT *,' THIS IS LINE 209, END OF INITIAL CALCULATION'

      BB(1,1)=TM(1)*(-G(1)+G(2)-G(3)+G(4))
      BB(1,2)=TM(1)*(-G(5)+G(6))
      BB(1,3)=TM(1)*(G(7)-G(8))
      BB(1,4)=TM(1)*(-G(9)+G(10))
      BB(1,5)=TM(1)*(G(11)-G(12))
      BB(1,6)=TM(1)*-G(13)
      BB(1,7)=TM(1)*G(14)
      BB(1,8)=TM(1)*-(15)
      BB(1,9)=TM(1)*G(16)
      BB(2,1)=-(DR*DX/(RAD*DTTAY1))-(DR*H*DX/(RAD*DTTAY1))+
     1        (DS*RAD*DTTA/DX2)-(DR*DX/(RAD*DTTAY3))-
     1        (DR*H*DX/(RAD*DTTAY3))+(DS*RAD*DTTA/DX4)
      BB(2,2)=(DR*DX/(RAD*DTTAY1))*(1.0+H)
      BB(2,3)=-DS*RAD*DTTA/DX2
      BB(2,4)=(DR*DX/(RAD*DTTAY3))*(1.0+H)
      BB(2,5)=-DS*RAD*DTTA/DX4
      DO 20 J=6,9
       BB(2,J)=0.0
20    CONTINUE
      BB(3,1)=TM(6)*(-G(1)-G(2)+G(3)+G(4))
      BB(3,2)=TM(6)*(-G(5)-G(6))
      BB(3,3)=TM(6)*(-G(7)+G(8))
      BB(3,4)=TM(6)*(G(9)+G(10))
      BB(3,5)=TM(6)*(G(11)-G(12))
      BB(3,6)=TM(6)*-G(13)
      BB(3,7)=TM(6)*-G(14)
      BB(3,8)=TM(6)*G(15) 
      BB(3,9)=TM(6)*G(16)
      BB(4,1)=TM(9)*(G(1)+G(2)+G(3)+G(4))+(KMOD*DX/((RAD**2)*DTTAY1))+
     1       (KMOD*DX/((RAD**2)*DTTAY3))
      BB(4,2)=TM(9)*(G(5)+G(6))-(KMOD*DX/((RAD**2)*DTTAY1))
      BB(4,3)=TM(9)*(G(7)+G(8))
      BB(4,4)=TM(9)*(G(9)+G(10))-(KMOD*DX/((RAD**2)*DTTAY3))
      BB(4,5)=TM(9)*(G(11)+G(12))
      BB(4,6)=TM(9)*G(13)
      BB(4,7)=TM(9)*G(14)
      BB(4,8)=TM(9)*G(15)
      BB(4,9)=TM(9)*G(16)
      BB(5,1)=TM(13)*(-G(1)+G(2)-G(3)+G(4))
      BB(5,2)=TM(13)*(-G(5)+G(6))
      BB(5,3)=TM(13)*(G(7)-G(8))
      BB(5,4)=TM(13)*(-G(9)+G(10))
      BB(5,5)=TM(13)*(G(11)-G(12))
      BB(5,6)=TM(13)*-G(13)
      BB(5,7)=TM(13)*G(14)
      BB(5,8)=TM(13)*-G(15)
      BB(5,9)=TM(13)*G(16)
      BB(6,1)=0.0
      BB(6,2)=0.0
      BB(6,3)=PNU*DR*(1.0-FTTAE-FTTAW)/(RAD*DTTA)
      BB(6,4)=0.0
      BB(6,5)=0.0
      BB(6,6)=0.0
      BB(6,7)=PNU*DR*FTTAE/(RAD*DTTA)
      BB(6,8)=-PNU*DR*(1.0-FTTAW)/(RAD*DTTA)
      BB(6,9)=0.0
      BB(7,1)=-2.0*DS*(1.0+H)/DX
      BB(7,2)=0.0
      BB(7,3)=2.0*DS*(1.0+H)/DX
      DO 21 J=4,9
       BB(7,J)=0.0
21    CONTINUE
      DO 22 J=1,9
       BB(8,J)=0.0
22    CONTINUE
      BB(9,1)=KS/(RAD*DX)
      BB(9,2)=0.0
      BB(9,3)=-KS/(RAD*DX)
      DO 23 J=4,9
       BB(9,J)=0.0
23    CONTINUE
      DO 24 J=1,9
       BB(10,J)=0.0
24    CONTINUE
C

      PRINT *,' THIS IS LINE 230, END OF B CALCULATION'

      C(1,1)=TM(2)*(-G(1)+G(2)+G(3)-G(4))
      C(1,2)=TM(2)*(-G(5)+G(6))
      C(1,3)=TM(2)*(G(7)+G(8))
      C(1,4)=TM(2)*(G(9)-G(10))
      C(1,5)=TM(2)*(-G(11)-G(12))
      C(1,6)=TM(2)*-G(13)
      C(1,7)=TM(2)*G(14)
      C(1,8)=TM(2)*G(15)
      C(1,9)=TM(2)*-G(16)
      C(2,1)=TM(5)*(G(1)+G(2)-G(3)-G(4))
      C(2,2)=TM(5)*(G(5)+G(6))
      C(2,3)=TM(5)*(G(7)-G(8))
      C(2,4)=TM(5)*(-G(9)-G(10))
      C(2,5)=TM(5)*(-G(11)+G(12))
      C(2,6)=TM(5)*G(13)
      C(2,7)=TM(5)*G(14)
      C(2,8)=TM(5)*-G(15)
      C(2,9)=TM(5)*-G(16)
      C(3,1)=(-DS*DX*(1.0+H)/(RAD*DTTAY1))+(DS*RAD*DTTA/DX2)-
     1       (DS*DX*(1.0+H)/(RAD*DTTAY3))+(DS*RAD*DTTA/DX4)
      C(3,2)=DS*DX*(1.0+H)/(RAD*DTTAY1)
      C(3,3)=-DS*RAD*DTTA/DX2
      C(3,4)=DS*DX*(1.0+H)/(RAD*DTTAY3)
      C(3,5)=-DS*RAD*DTTA/DX4
      DO 25 J=6,9
       C(3,J)=0.0
25    CONTINUE
      C(4,1)=TM(10)*(-G(1)-G(2)+G(3)+G(4))+
     1       (DS*DX*DTTA*(1.0+H)/(2.0*DTTAY1))-
     1       (DS*DX*DTTA*(1.0+H)/(2.0*DTTAY3))
      C(4,2)=TM(10)*(-G(5)-G(6))-(DS*DX*DTTA*(1.0+H)/(2.0*DTTAY1))
      C(4,3)=TM(10)*(-G(7)+G(8))
      C(4,4)=TM(10)*(G(9)+G(10))+(DS*DX*DTTA*(1.0+H)/(2.0*DTTAY3))
      C(4,5)=TM(10)*(G(11)-G(12))
      C(4,6)=TM(10)*-G(13)
      C(4,7)=TM(10)*-G(14)
      C(4,8)=TM(10)*G(15)
      C(4,9)=TM(10)*G(16)
      C(5,1)=-(DS*RAD*DTTA*DX/(2.0*DX2))+
     1        (DS*RAD*DTTA*DX/(2.0*DX4))
      C(5,2)=0.0
      C(5,3)=DS*RAD*DTTA*DX/(2.0*DX2)
      C(5,4)=0.0
      C(5,5)=-DS*RAD*DTTA*DX/(2.0*DX4)
      DO 26 J=6,9
       C(5,J)=0.0
26    CONTINUE
      C(6,1)=0.0
      C(6,2)=0.0
      C(6,3)=PNU*DR*(1.0-FTTAE+FTTAW)/(2.0*RAD)
      C(6,4)=0.0
      C(6,5)=0.0
      C(6,6)=0.0
      C(6,7)=PNU*DR*FTTAE/(2.0*RAD)
      C(6,8)=PNU*DR*(1.0-FTTAW)/(2.0*RAD)
      C(6,9)=0.0
      DO 27 K=7,9
       DO 27 J=1,9
       C(K,J)=0.0
27    CONTINUE
      C(10,1)=-2.0*DS/DX
      C(10,2)=0.0
      C(10,3)=2.0*DS/DX
      DO 28 J=4,9
       C(10,J)=0.0
28    CONTINUE
C
      PRINT *,' THIS IS LINE 727, END OF C CALCULATION'


      DD(1,1)=-DR*(T**2)*DTTA*((1.0/DX2)+(1.0/DX4))/12.0
      DD(1,2)=0.0
      DD(1,3)=DR*(T**2)*DTTA/(12.0*DX2) 
      DD(1,4)=0.0
      DD(1,5)=DR*(T**2)*DTTA/(12.0*DX4)
      DO 29 J=6,9
       DD(1,J)=0.0
29    CONTINUE
      DO 30 J=1,9
       DD(2,J)=0.0
30    CONTINUE
      DD(3,1)=TM(7)*(G(1)-G(2)-G(3)+G(4))
      DD(3,2)=TM(7)*(G(5)-G(6))
      DD(3,3)=TM(7)*(-G(7)-G(8))
      DD(3,4)=TM(7)*(-G(9)+G(10))    
      DD(3,5)=TM(7)*(G(11)+G(12))    
      DD(3,6)=TM(7)*G(13)     
      DD(3,7)=TM(7)*-G(14)   
      DD(3,8)=TM(7)*-G(15)     
      DD(3,9)=TM(7)*G(16)
      DD(4,1)=TM(11)*(-G(1)+G(2)-G(3)+G(4))
      DD(4,2)=TM(11)*(-G(5)+G(6))
      DD(4,3)=TM(11)*(G(7)-G(8))
      DD(4,4)=TM(11)*(-G(9)+G(10))    
      DD(4,5)=TM(11)*(G(11)-G(12))    
      DD(4,6)=TM(11)*-G(13)     
      DD(4,7)=TM(11)*G(14)   
      DD(4,8)=TM(11)*-G(15)     
      DD(4,9)=TM(11)*G(16)     
      DD(5,1)=(TM(14)*(G(1)+G(2)+G(3)+G(4)))-(KMOD*RAD*DTTA/DX2)-
     1       (KMOD*RAD*DTTA/DX4)
      DD(5,2)=TM(14)*(G(5)+G(6))
      DD(5,3)=TM(14)*(G(7)+G(8))+(KMOD*RAD*DTTA/DX2)
      DD(5,4)=TM(14)*(G(9)+G(10))    
      DD(5,5)=TM(14)*(G(11)+G(12))+(KMOD*RAD*DTTA/DX4)    
      DD(5,6)=TM(14)*G(13)     
      DD(5,7)=TM(14)*G(14)   
      DD(5,8)=TM(14)*G(15)     
      DD(5,9)=TM(14)*G(16)       
      DD(6,1)=-DR*(T**2)/(6.0*RAD*DX)  
      DD(6,2)=0.0
      DD(6,3)=DR*(T**2)/(6.0*RAD*DX) 
      DO 31 J=4,9
       DD(6,J)=0.0
31    CONTINUE
      DO 32 J=1,9
       DD(7,J)=0.0
32    CONTINUE   
      DD(8,1)=-2.0*KMOD/DX   
      DD(8,2)=0.0 
      DD(8,3)=2.0*KMOD/DX 
      DO 33 J=4,9
       DD(8,J)=0.0
33    CONTINUE  
      DO 34 J=1,9
       DD(9,J)=0.0
34    CONTINUE      
      DD(10,1)=0.0
      DD(10,2)=0.0      
      DD(10,3)=DS*(1.0-FTTAE+FTTAW)/2.0
      DD(10,4)=0.0
      DD(10,5)=0.0
      DD(10,6)=0.0
      DD(10,7)=DS*FTTAE/2.0 
      DD(10,8)=DS*(1.0-FTTAW)/2.0
      DD(10,9)=0.0
C
      PRINT *,' THIS IS LINE 369, END OF D CALCULATION'
 
      E(1,1)=TM(3)*(G(1)-G(2)+G(3)-G(4))
      E(1,2)=TM(3)*(G(5)-G(6))
      E(1,3)=TM(3)*(-G(7)+G(8))      
      E(1,4)=TM(3)*(G(9)-G(10))      
      E(1,5)=TM(3)*(-G(11)+G(12))        
      E(1,6)=TM(3)*G(13)     
      E(1,7)=TM(3)*-G(14)     
      E(1,8)=TM(3)*G(15)     
      E(1,9)=TM(3)*-G(16)  
      E(2,1)=H*((DR*DX/DTTAY1)-(DS*(RAD**2)*DTTA/DX2)+
     1       (DR*DX/DTTAY3)-(DS*(RAD**2)*DTTA/DX4))     
      E(2,2)=-DR*H*DX/DTTAY1    
      E(2,3)=DS*(T**2)*DTTA/(12.0*DX2)       
      E(2,4)=-DR*H*DX/DTTAY3    
      E(2,5)=DS*(T**2)*DTTA/(12.0*DX4)       
      DO 35 J=6,9
       E(2,J)=0.0
35    CONTINUE        
      E(3,1)=TM(8)*(G(1)+G(2)-G(3)-G(4))
      E(3,2)=TM(8)*(G(5)+G(6))
      E(3,3)=TM(8)*(G(7)-G(8))      
      E(3,4)=TM(8)*(-G(9)-G(10))      
      E(3,5)=TM(8)*(-G(11)+G(12))        
      E(3,6)=TM(8)*G(13)     
      E(3,7)=TM(8)*G(14)     
      E(3,8)=TM(8)*-G(15)     
      E(3,9)=TM(8)*-G(16)     
      E(4,1)=-TM(12)*(1.0+H)*(G(1)+G(2)+G(3)+G(4))-
     1        (KMOD*DX/(RAD*DTTAY1))-(KS*RAD*DTTA/DX2)-
     1        (KMOD*DX/(RAD*DTTAY3))-(KS*RAD*DTTA/DX4)
      E(4,2)=-TM(12)*(G(5)+G(6))+(KMOD*DX/(RAD*DTTAY1))
      E(4,3)=-TM(12)*(G(7)+G(8))+ (KS*RAD*DTTA/DX2)     
      E(4,4)=-TM(12)*(G(9)+G(10))+(KMOD*DX/(RAD*DTTAY3))      
      E(4,5)=-TM(12)*(G(11)+G(12))+(KS*RAD*DTTA/DX4)        
      E(4,6)=-TM(12)*G(13)     
      E(4,7)=-TM(12)*G(14)     
      E(4,8)=-TM(12)*G(15)     
      E(4,9)=-TM(12)*G(16)             
      E(5,1)=TM(15)*(-G(1)+G(2)-G(3)+G(4))
      E(5,2)=TM(15)*(-G(5)+G(6))
      E(5,3)=TM(15)*(G(7)-G(8))      
      E(5,4)=TM(15)*(-G(9)+G(10))      
      E(5,5)=TM(15)*(G(11)-G(12))        
      E(5,6)=TM(15)*-G(13)     
      E(5,7)=TM(15)*G(14)     
      E(5,8)=TM(15)*-G(15)     
      E(5,9)=TM(15)*G(16)             
      DO 36 J=1,9
       E(6,J)=0.0
36    CONTINUE    
      E(7,1)=-DS*(T**2)/(6.0*RAD*DX)    
      E(7,2)=0.0     
      E(7,3)=DS*(T**2)/(6.0*RAD*DX)      
      DO 37 J=4,9
       E(7,J)=0.0
37    CONTINUE        
      E(8,1)=0.0        
      E(8,2)=0.0         
      E(8,3)=PNU*KMOD*(1.0-FTTAE-FTTAW)/(RAD*DTTA)        
      E(8,4)=0.0        
      E(8,5)=0.0            
      E(8,6)=0.0        
      E(8,7)=PNU*KMOD*FTTAE/(RAD*DTTA)        
      E(8,8)=-PNU*KMOD*(1.0-FTTAW)/(RAD*DTTA)                
      E(8,9)=0.0
      E(9,1)=2.0*KS/DX     
      E(9,2)=0.0        
      E(9,3)=-2.0*KS/DX           
      DO 38 J=4,9
       E(9,J)=0.0
38    CONTINUE      
      DO 39 J=1,9
       E(10,J)=0.0
39    CONTINUE           
C 
      PRINT *,' THIS IS LINE 445, END OF E CALCULATION'

      PRINT *,'FIRST PART FINISHED'
      PRINT *,'  '
C    FORMATION OF BLOCK MATRICES IN STIFFNESS MATRIX
     
C      EQUILIBRIUM EQUATION BLOCK MATRICES


C       J=1
       DO 40 M=1,3
        EC1(M,1)=AA(M,1)
        EC1(M,2)=BB(M,1)
        EC1(M,3)=C(M,1)
        EC1(M,4)=DD(M,1)
        EC1(M,5)=E(M,1)     
C       J=2
        EC2(M,1)=AA(M,2)
        EC2(M,2)=BB(M,2)
        EC2(M,3)=C(M,2)
        EC2(M,4)=DD(M,2)
        EC2(M,5)=E(M,2)     
C      J=3
        EC3(M,1)=AA(M,3)
        EC3(M,2)=BB(M,3)
        EC3(M,3)=C(M,3)
        EC3(M,4)=DD(M,3)
        EC3(M,5)=E(M,3)     
C      J=4
        EC4(M,1)=AA(M,4)
        EC4(M,2)=BB(M,4)
        EC4(M,3)=C(M,4)
        EC4(M,4)=DD(M,4)
        EC4(M,5)=E(M,4)     
C      J=5
        EC5(M,1)=AA(M,5)
        EC5(M,2)=BB(M,5)
        EC5(M,3)=C(M,5)
        EC5(M,4)=DD(M,5)
        EC5(M,5)=E(M,5)     
C      J=6
        EC6(M,1)=AA(M,6)
        EC6(M,2)=BB(M,6)
        EC6(M,3)=C(M,6)
        EC6(M,4)=DD(M,6)
        EC6(M,5)=E(M,6)     
C       J=7
        EC7(M,1)=AA(M,7)
        EC7(M,2)=BB(M,7)
        EC7(M,3)=C(M,7)
        EC7(M,4)=DD(M,7)
        EC7(M,5)=E(M,7)     
C       J=8
        EC8(M,1)=AA(M,8)
        EC8(M,2)=BB(M,8)
        EC8(M,3)=C(M,8)
        EC8(M,4)=DD(M,8)
        EC8(M,5)=E(M,8)     
C      J=9
        EC9(M,1)=AA(M,9)
        EC9(M,2)=BB(M,9)
        EC9(M,3)=C(M,9)
        EC9(M,4)=DD(M,9)
        EC9(M,5)=E(M,9) 
40     CONTINUE 


C       J=1
        EC1(4,1)=AA(5,1)
        EC1(4,2)=BB(5,1)
        EC1(4,3)=C(5,1)
        EC1(4,4)=DD(5,1)
        EC1(4,5)=E(5,1) 

        EC1(5,1)=AA(4,1)
        EC1(5,2)=BB(4,1)
        EC1(5,3)=C(4,1)
        EC1(5,4)=DD(4,1)
        EC1(5,5)=E(4,1) 

C       J=2
        EC2(4,1)=AA(5,2)
        EC2(4,2)=BB(5,2)
        EC2(4,3)=C(5,2)
        EC2(4,4)=DD(5,2)
        EC2(4,5)=E(5,2) 

        EC2(5,1)=AA(4,2)
        EC2(5,2)=BB(4,2)
        EC2(5,3)=C(4,2)
        EC2(5,4)=DD(4,2)
        EC2(5,5)=E(4,2) 

C       J=3
        EC3(4,1)=AA(5,3)
        EC3(4,2)=BB(5,3)
        EC3(4,3)=C(5,3)
        EC3(4,4)=DD(5,3)
        EC3(4,5)=E(5,3) 

        EC3(5,1)=AA(4,3)
        EC3(5,2)=BB(4,3)
        EC3(5,3)=C(4,3)
        EC3(5,4)=DD(4,3)
        EC3(5,5)=E(4,3)


C       J=4
        EC4(4,1)=AA(5,4)
        EC4(4,2)=BB(5,4)
        EC4(4,3)=C(5,4)
        EC4(4,4)=DD(5,4)
        EC4(4,5)=E(5,4) 

        EC4(5,1)=AA(4,4)
        EC4(5,2)=BB(4,4)
        EC4(5,3)=C(4,4)
        EC4(5,4)=DD(4,4)
        EC4(5,5)=E(4,4)

C       J=5
        EC5(4,1)=AA(5,5)
        EC5(4,2)=BB(5,5)
        EC5(4,3)=C(5,5)
        EC5(4,4)=DD(5,5)
        EC5(4,5)=E(5,5) 

        EC5(5,1)=AA(4,5)
        EC5(5,2)=BB(4,5)
        EC5(5,3)=C(4,5)
        EC5(5,4)=DD(4,5)
        EC5(5,5)=E(4,5)

C       J=6
        EC6(4,1)=AA(5,6)
        EC6(4,2)=BB(5,6)
        EC6(4,3)=C(5,6)
        EC6(4,4)=DD(5,6)
        EC6(4,5)=E(5,6) 

        EC6(5,1)=AA(4,6)
        EC6(5,2)=BB(4,6)
        EC6(5,3)=C(4,6)
        EC6(5,4)=DD(4,6)
        EC6(5,5)=E(4,6)

C       J=7
        EC7(4,1)=AA(5,7)
        EC7(4,2)=BB(5,7)
        EC7(4,3)=C(5,7)
        EC7(4,4)=DD(5,7)
        EC7(4,5)=E(5,7) 

        EC7(5,1)=AA(4,7)
        EC7(5,2)=BB(4,7)
        EC7(5,3)=C(4,7)
        EC7(5,4)=DD(4,7)
        EC7(5,5)=E(4,7)

C       J=8
        EC8(4,1)=AA(5,8)
        EC8(4,2)=BB(5,8)
        EC8(4,3)=C(5,8)
        EC8(4,4)=DD(5,8)
        EC8(4,5)=E(5,8) 

        EC8(5,1)=AA(4,8)
        EC8(5,2)=BB(4,8)
        EC8(5,3)=C(4,8)
        EC8(5,4)=DD(4,8)
        EC8(5,5)=E(4,8)

C       J=9
        EC9(4,1)=AA(5,9)
        EC9(4,2)=BB(5,9)
        EC9(4,3)=C(5,9)
        EC9(4,4)=DD(5,9)
        EC9(4,5)=E(5,9) 

        EC9(5,1)=AA(4,9)
        EC9(5,2)=BB(4,9)
        EC9(5,3)=C(4,9)
        EC9(5,4)=DD(4,9)
        EC9(5,5)=E(4,9)

   
C     BOUNDARY EQUATIONS
C       J=1
       DO 401 M=1,5 
        BC1(M,1)=AA(M+5,1)
        BC1(M,2)=BB(M+5,1)
        BC1(M,3)=C(M+5,1)
        BC1(M,4)=DD(M+5,1)
        BC1(M,5)=E(M+5,1)     
C       J=2
        BC2(M,1)=AA(M+5,2)
        BC2(M,2)=BB(M+5,2)
        BC2(M,3)=C(M+5,2)
        BC2(M,4)=DD(M+5,2)
        BC2(M,5)=E(M+5,2)     
C       J=3
        BC3(M,1)=AA(M+5,3)
        BC3(M,2)=BB(M+5,3)
        BC3(M,3)=C(M+5,3)
        BC3(M,4)=DD(M+5,3)
        BC3(M,5)=E(M+5,3)     
C       J=4
        BC4(M,1)=AA(M+5,4)
        BC4(M,2)=BB(M+5,4)
        BC4(M,3)=C(M+5,4)
        BC4(M,4)=DD(M+5,4)
        BC4(M,5)=E(M+5,4)     
C       J=5
        BC5(M,1)=AA(M+5,5)
        BC5(M,2)=BB(M+5,5)
        BC5(M,3)=C(M+5,5)
        BC5(M,4)=DD(M+5,5)
        BC5(M,5)=E(M+5,5)     
C       J=6
        BC6(M,1)=AA(M+5,6)
        BC6(M,2)=BB(M+5,6)
        BC6(M,3)=C(M+5,6)
        BC6(M,4)=DD(M+5,6)
        BC6(M,5)=E(M+5,6)   
C       J=7
        BC7(M,1)=AA(M+5,7)
        BC7(M,2)=BB(M+5,7)
        BC7(M,3)=C(M+5,7)
        BC7(M,4)=DD(M+5,7)
        BC7(M,5)=E(M+5,7)     
C       J=8
        BC8(M,1)=AA(M+5,8)
        BC8(M,2)=BB(M+5,8)
        BC8(M,3)=C(M+5,8)
        BC8(M,4)=DD(M+5,8)
        BC8(M,5)=E(M+5,8)     
C       J=9
        BC9(M,1)=AA(M+5,9)
        BC9(M,2)=BB(M+5,9)
        BC9(M,3)=C(M+5,9)
        BC9(M,4)=DD(M+5,9)
        BC9(M,5)=E(M+5,9)     
401    CONTINUE 



       DO 70 J=1,9 
        IF (NZ(J,I) .EQ. 0) THEN
           GO TO 70
        END IF
 
         IF (J .EQ. 1) THEN
            IF (I .LE. NX*NTTA) THEN
              DO 59 K=1,5
                DO 59 L=1,5
                 STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC1(K,L)
59            CONTINUE
            ELSE
              DO 60 K=1,5
               IF (KANS(K) .EQ. 2) THEN
                 STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+K)=1.0
                  GO TO 60
               END IF
                DO 61 L=1,5
                 STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC1(K,L)
61              CONTINUE
60            CONTINUE
          END IF     
        END IF


         IF (J .EQ. 2) THEN
            DO 62 K=1,5
              DO 62 L=1,5
               IF (I .LE. NX*NTTA) THEN
                 STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC2(K,L)
               ELSE
                 IF (KANS(K) .NE. 2) THEN
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC2(K,L)
                 END IF     
               END IF
62          CONTINUE
         END IF

         IF (J .EQ. 3) THEN
            DO 63 K=1,5
               DO 63 L=1,5
                IF (I .LE. NX*NTTA) THEN            
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC3(K,L)
                ELSE
                  IF (KANS(K) .NE. 2) THEN
                    STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC3(K,L)
                  END IF
                END IF
63          CONTINUE
         END IF

         IF (J .EQ. 4) THEN
            DO 64 K=1,5
               DO 64 L=1,5
                IF (I .LE. NX*NTTA) THEN            
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC4(K,L)
                ELSE
                  IF (KANS(K) .NE. 2) THEN
                    STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC4(K,L)
                  END IF
                END IF
64          CONTINUE
         END IF

         IF (J .EQ. 5) THEN
             DO 65 K=1,5
               DO 65 L=1,5
                IF (I .LE. NX*NTTA) THEN            
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC5(K,L)
                ELSE
                  IF (KANS(K) .NE. 2) THEN
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC5(K,L)
                  END IF
                END IF
65           CONTINUE
         END IF

         IF (J .EQ. 6) THEN
             DO 66 K=1,5
               DO 66 L=1,5
                IF (I .LE. NX*NTTA) THEN            
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC6(K,L)
                ELSE
                  IF (KANS(K) .NE. 2) THEN
                    STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC6(K,L)
                  END IF
                END IF
66           CONTINUE
         END IF

         IF (J .EQ. 7) THEN
             DO 67 K=1,5
               DO 67 L=1,5
                IF (I .LE. NX*NTTA) THEN            
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC7(K,L)
                ELSE
                  IF (KANS(K) .NE. 2) THEN
                    STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC7(K,L)
                  END IF
                END IF
67           CONTINUE
         END IF

         IF (J .EQ. 8) THEN
             DO 68 K=1,5
               DO 68 L=1,5
                IF (I .LE. NX*NTTA) THEN            
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC8(K,L)
                ELSE
                  IF (KANS(K) .NE. 2) THEN
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC8(K,L)
                  END IF
                END IF
68           CONTINUE
         END IF

         IF (J .EQ. 9) THEN
             DO 69 K=1,5
               DO 69 L=1,5
                IF (I .LE. NX*NTTA) THEN            
                   STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=EC9(K,L)
                ELSE
                  IF (KANS(K) .NE. 2) THEN
                    STIFF(5*(I-1)+K,5*(NZ(J,I)-1)+L)=BC9(K,L)
                  END IF
                END IF
69           CONTINUE
         END IF
      
70    CONTINUE
670   CONTINUE                  

C  WRITING STIFFNESS MATRIX      
      DO 71 I=1,5*(NX+2)*NTTA
        WRITE (3,*) (I)
        WRITE (3,*) (STIFF(I,J),J=1,5*(NX+2)*NTTA)
71    CONTINUE

      WRITE (3,*) 'END OF STIFFNESS MATRIX '

      WRITE (3,*) '   '


      PRINT *,' END OF STIFFNESS MATRIX'

      PRINT *,' '

C GENERATING RIGHT HAND SIDE MATRIX

      DO 72 I=0,NX*NTTA-1
       RHSMAT(5*I+1)=(PX)*DX*RAD*DTTA
       RHSMAT(5*I+2)=(PTTA)*DX*RAD*DTTA
       RHSMAT(5*I+3)=(-PZ)*DX*RAD*DTTA
       RHSMAT(5*I+4)=0.0
       RHSMAT(5*I+5)=0.0
72    CONTINUE

C FRONT END BOUNDARY ELEMENT FORCES
      DO 73 I=NX*NTTA,(NX+1)*NTTA-1     
       RHSMAT(5*I+1)=FX
       RHSMAT(5*I+2)=FTTAX
       RHSMAT(5*I+3)=BMX
       RHSMAT(5*I+4)=BMTTAX
       RHSMAT(5*I+5)=QXZ
73    CONTINUE

C  OUTER END BOUNDARY ELEMENT FORCES 

      DO 74 I=(NX+1)*NTTA,(NX+2)*NTTA-1     
       RHSMAT(5*I+1)=FX
       RHSMAT(5*I+2)=FTTAX
       RHSMAT(5*I+3)=BMX
       RHSMAT(5*I+4)=BMTTAX
       RHSMAT(5*I+5)=QXZ
74    CONTINUE

       
C       DO 75 I=1,5*(NX+2)*NTTA
C       WRITE (3,*) (RHSMAT(I))
C75     CONTINUE 
      N1=5*(NX+2)*NTTA

C CREATE A COPY OF THE STIFFNESS MARIX
      DO 76 I=1,N1
       DO 76 J=1,N1
        STIFF1(I,J)=STIFF(I,J)
76    CONTINUE



      PRINT *,' RIGHT HAND SIDE MATRIX GENERATED'

      PRINT *,' '

      PRINT *,' ENTERING SUBROUTINE LUDCMP'

      CALL LUDCMP (STIFF1,N1,N1,INDX,D)

      PRINT *,' LEAVING SUBROUTINE LUDCMP'
 

      PRINT *,' ENTERING SUBROUTINE LUBKSB  ', I

      WRITE (3,*) '  '
          
      WRITE (3,*) 'MATRIX AFTER LU DECOMPOSITION'

      WRITE (3,*) '  '          

      DO 77 I=1,N1
        WRITE (3,*) (I)
        WRITE (3,*) (STIFF1(I,J),J=1,N1)
77    CONTINUE

      
      CALL LUBKSB (STIFF1,N1,N1,INDX,RHSMAT)

 
      PRINT *,' LEAVING SUBROUTINE LUBKSB  ', I

      WRITE (3,*) '  '          

      WRITE (3,*) '  '          
 
      WRITE (3,*) 'CELL CENTRE DISPLACEMENTS VALUES'
      WRITE (3,*) '  '          
      WRITE (3,78) 
      WRITE (3,*) (RHSMAT(I),I=1,N1)


      PRINT *,'CELL CENTRE DISPLACEMENTS CALCULATED'

78    FORMAT('',T1,'UDISP (MM)',T15,'VDISP (MM)',T28,'WDISP (MM)',
     1      T42,'XROT (RAD)',T57,'TTAROT (RAD)',/,T1,10('_')
     1    ,TR4,10('_'),TR3,10('_'),TR4,10('_'),TR5,10('_'))


   
      PRINT *,'END OF PROGRAM'

      CLOSE(3)
      STOP
      END






	subroutine ludcmp(a,n,np,indx,d)
c	implicit real*8(a-h,o-z)
	parameter(nmax=1000,tiny=1.0e-20)
	dimension a(np,np),indx(n),vv(nmax)

       PRINT *,'THIS IS LINE 1240 IN LUDCMP'
       PRINT *,' '
	d=1.0
	do 12 i=1,n
	  aamax=0.0
	  do 11 j=1,n
	    if(abs(a(i,j)).gt.aamax) aamax=abs(a(i,j))
11	  continue
	  if(aamax.eq.0.0) print*,'singular matrix'
	  vv(i)=1.0/aamax
12	continue
       PRINT *,'THIS IS LINE 1251 IN LUDCMP'
       PRINT *,' '

	do 19 j=1,n
	  if(j.gt.1) then
	    do 14 i=1,j-1
            sum=a(i,j)
	      if(i.gt.1) then
	        do 13 k=1,i-1
	          sum=sum-a(i,k)*a(k,j)
13	        continue
              a(i,j)=sum
            endif
14	    continue
	  endif
	  aamax=0.0
	  do 16 i=j,n
	    sum=a(i,j)
	    if(j.gt.1) then
	      do 15 k=1,j-1
	        sum=sum-a(i,k)*a(k,j)
15	      continue
	      a(i,j)=sum
	    endif
		dum=vv(i)*abs(sum)
	    if(dum.ge.aamax) then
	      imax=i
	      aamax=dum
	    endif
16	  continue
        if(j.ne.imax) then
	    do 17 k=1,n
	      dum=a(imax,k)
	      a(imax,k)=a(j,k)
	      a(j,k)=dum
17	    continue
        d=-d
	  vv(imax)=vv(j)
	  endif
	  indx(j)=imax
	  if(j.ne.n) then
	    if(a(i,j).eq.0.0) a(i,j)=tiny
	    dum=1.0/a(j,j)
	    do 18 i=j+1,n
	      a(i,j)=a(i,j)*dum
18	    continue

        endif
       PRINT *,'THIS IS LINE 1299 IN LUDCMP  ',J
       PRINT *,' '

19	continue
	if(a(n,n).eq.0) a(n,n)=tiny
	return
	end



	subroutine lubksb(a,n,np,indx,b)
C	implicit real*8(a-h,o-z)
	dimension a(np,np),indx(n),b(n)
	ii=0
	do 12 i=1,n
	  ll=indx(i)
	  sum=b(ll)
	  b(ll)=b(i)
	  if(ii.ne.0) then
	    do 11 j=ii,i-1
	      sum=sum-a(i,j)*b(j)
11	    continue
        else if(sum.ne.0.0) then
	      ii=i
	  endif
	  b(i)=sum
12	continue
	do 14 i=n,1,-1
	  sum=b(i)
	  if(i.lt.n) then
	    do 13 j=i+1,n
	      sum=sum-a(i,j)*b(j)
13	    continue
        endif
	  b(i)=sum/a(i,i)
14	continue
	return
	end

