function [xx,yy,numpt] = cs(xcntp,ycntp)

xp=xcntp;	%control points
yp=ycntp;
[r,c]=size(xp);

M = [4 1 0 1; 1 4 1 0; 0 1 4 1; 0 0 1 4];
M2 = [1 0 0 0; 0 0 1 0; -3 3 -2 -1; 2 -2 1 1];

xx = [];
yy = [];

for i = 1:r

x=xp(i,:);
y=yp(i,:);

xdif = [(x(2)-x(4)) (x(3)-x(1)) (x(4)-x(2)) (x(1)-x(3))]';
ydif = [(y(2)-y(4)) (y(3)-y(1)) (y(4)-y(2)) (y(1)-y(3))]';

dx = inv(M)*3*xdif;
dy = inv(M)*3*ydif;

coefx1 = M2*[x(1) x(2) dx(1) dx(2)]';   % a1 to d1
coefx2 = M2*[x(2) x(3) dx(2) dx(3)]';
coefx3 = M2*[x(3) x(4) dx(3) dx(4)]';
coefx4 = M2*[x(4) x(1) dx(4) dx(1)]';
coefy1 = M2*[y(1) y(2) dy(1) dy(2)]';   
coefy2 = M2*[y(2) y(3) dy(2) dy(3)]';
coefy3 = M2*[y(3) y(4) dy(3) dy(4)]';
coefy4 = M2*[y(4) y(1) dy(4) dy(1)]';

x1 = []; x2 = []; x3 = []; x4 = [];
y1 = []; y2 = []; y3 = []; y4 = [];

numpt = 0;

for t = 0:.025:1

	x1 = [x1; coefx1(4)*t^3 + coefx1(3)*t^2 + coefx1(2)*t + coefx1(1)];
	x2 = [x2; coefx2(4)*t^3 + coefx2(3)*t^2 + coefx2(2)*t + coefx2(1)];
	x3 = [x3; coefx3(4)*t^3 + coefx3(3)*t^2 + coefx3(2)*t + coefx3(1)];
	x4 = [x4; coefx4(4)*t^3 + coefx4(3)*t^2 + coefx4(2)*t + coefx4(1)];

	y1 = [y1; coefy1(4)*t^3 + coefy1(3)*t^2 + coefy1(2)*t + coefy1(1)];
	y2 = [y2; coefy2(4)*t^3 + coefy2(3)*t^2 + coefy2(2)*t + coefy2(1)];
	y3 = [y3; coefy3(4)*t^3 + coefy3(3)*t^2 + coefy3(2)*t + coefy3(1)];
	y4 = [y4; coefy4(4)*t^3 + coefy4(3)*t^2 + coefy4(2)*t + coefy4(1)];

numpt=numpt+1;
end


xcntp1 =round(1*[x1 x2 x3 x4]);
ycntp1 =round(1*[y1 y2 y3 y4]);

xx = [xx; xcntp1];
yy = [yy; ycntp1];

end

