;;;   COPYR3D.LSP
;;;   Copyright (C) 2000 by FARID MANAWEL SHOMALI
;;; Permission to use, copy, modify, and distribute this software
;;; for any purpose and without fee is illegal and will leeds to
;;; criminal penalties (This software is copyrighted and all rights  
;;; reserved).

(defun g:dtr(a)
(* pi (/ a 180.0))
)

(defun g:rot3d (ss1 bp ap r_ang)
(command ".ucs" "s" "$delme$") 
(command ".ucs" "w")
(setvar "gridmode" 0)
(setq oldech (getvar "cmdecho")
      oldgrid (getvar "gridmode")
)
(setvar "cmdecho" 0)
(command "ucs" "3point" bp (polar bp (- (angle bp ap) (g:dtr 90)) 1) ap)
(command "ucs" "x" "90") 
(setq ww (list 0.0 0.0 0.0))
(command "rotate" ss1 "" ww r_ang) 
(command "ucs" "r" "$delme$") 
(command "ucs" "d" "$delme$")
(setvar "cmdecho" oldech)
(setvar "gridmode" oldgrid)
(princ)
)

(defun g:at (stuff)
(command "copy" stuff "" "@" "@")
)

(defun c:rot3d ()  
(setq ss1 (ssget))
(initget 16)
(setq bp (getpoint "\nSelect Rotation Base Point: "))
(initget 16)
(setq ap (getpoint bp "\nSelect Rotation Axis: ")
      r_ang (getint "\nSelect Rotation Angle: ")
      )
      (g:at ss1)
       (g:rot3d ss1 bp ap r_ang) 
       
)

