;;;   PCUBE.LSP
;;;   Copyright (C) 2000 by FARID MANAWEL SHOMALI
;;; Permission to use, copy, modify, and distribute this software
;;; for any purpose and without fee is illegal and will leeds to
;;; criminal penalties (This software is copyrighted and all rights  
;;; reserved.
(defun myerror (s)                    ; If an error (such as CTRL-C) occurs
                                      ; while this command is active...
  (if (/= s "Function cancelled")
    (princ (strcat "\nError: " s))
  )
  (setvar "cmdecho" ocmd)             ; Restore saved modes
  (setvar "blipmode" oblp)
  (setq *error* olderr)               ; Restore old *error* handler
  (princ)
)
;***********************************
(defun c:pcube (/ pt1 pt2 pt3 pt4 pt5 len2 len el)
  (setq olderr  *error*
        *error* myerror)
  (setq ocmd (getvar "cmdecho"))
  (setq oblp (getvar "blipmode"))
  (setvar "cmdecho" 0)
  (setvar "blipmode" 0) 
(setq pt1 (getpoint "\nLower left corner: "))
(setq len (getdist pt1 "\nLenght of one side: "))
(setq sos (getstring "\nEnter the name of the faces: ")) 
(setq sos1 (getstring "\nEnter the name of the vertices: "))
(setq sos2 (getstring "\nEnter the name of the edges: "))
(setq pt2 (polar pt1 0.0 len))
(setq pt3 (polar pt2 (/ pi 2.0) len))
(setq pt4 (polar pt3 pi len))
(setq ptx (polar pt1 0.0 (/ len 2.0)))
(setq pty (polar ptx (/ pi 2.0) (/ len 2.0))) 
(setq pto (list (car pty) (cadr pty) (/ len 2.0))) 
(command "circle" pto 0.3)
(setq pto1 (list (car pty) (cadr pty) len)) 
(setq pto0 (polar pto pi (/ len 2.0))) 
(setq pto2 (list (car pt1) (cadr pt1) (/ len 2.0))) 
(setq pto3 (list (car ptx) (cadr ptx) (/ len 2.0)))
(setq pto4 (list (car pt2) (cadr pt2) (/ len 2.0)))
;;--------------------------------
(command "3dface" pt1 pt2 pt3 pt4 "")
(command "block" sos pto "l" "") 
(command "insert" sos pto "" "" "") 
(command "insert" sos pto "" "" "")
(setq wow (entlast))
(g:rot3d wow pto pto0 90)
(command "array" "l" "" "p" pto 4 360 "y")
(command "insert" sos pto "" "" "") 
(setq wow (entlast))
(g:rot3d wow pto pto0 180)  
;;-------------------------------- 
(command "point" pt1)
(command "block" sos1 pto "l" "") 
(command "insert" sos1 pto "" "" "") 
(command "array" "l" "" "p" pto 4 360 "y")
(command "insert" sos1 pto "" "" "")
(setq wow (entlast))
(g:rot3d wow pto pto2 180)
(command "array" "l" "" "p" pto 4 360 "y")
;;-------------------------------- 
(command "line" pt1 pt2 "")
(command "block" sos2 pto "l" "") 
(command "insert" sos2 pto "" "" "") 
(command "array" "l" "" "p" pto 4 360 "y")  
(command "insert" sos2 pto "" "" "")
(setq wow (entlast))
(g:rot3d wow pto pto3 180)
(command "array" "l" "" "p" pto 4 360 "y")
(command "insert" sos2 pto "" "" "") 
(setq wow (entlast))
(g:rot3d wow pto pto3 90)  
(command "array" "l" "" "p" pto 4 360 "y") 
;;-------------------------------- 
(setvar "cmdecho" ocmd)
(setvar "blipmode" oblp)
(setq *error* olderr)               ; Restore old *error* handler
(command "redraw")
(princ)
)

