;;;   POLAR_S.LSP
;;;   Copyright (C) 2000 by FARID MANAWEL SHOMALI
;;; Permission to use, copy, modify, and distribute this software
;;; for any purpose and without fee is illegal and will leeds to
;;; criminal penalties (This software is copyrighted and all rights  
;;; reserved.
(defun myerror (s)                    ; If an error (such as CTRL-C) occurs
                                      ; while this command is active...
  (if (/= s "Function cancelled")
    (princ (strcat "\nError: " s))
  )
  (setvar "cmdecho" ocmd)             ; Restore saved modes
  (setvar "blipmode" oblp)
  (setq *error* olderr)               ; Restore old *error* handler
  (princ)
)

(defun dttr (a)
(* pi (/ a 180.0))
)
(defun c:polar_s ()
  (setq olderr  *error*
        *error* myerror)
  (setq ocmd (getvar "cmdecho"))
  (setq oblp (getvar "blipmode"))
  (setvar "cmdecho" 0)
  (setvar "blipmode" 0) 
(setq n (getint "\nDetermine the titness: ")) 
(setq ct1 (getpoint "\nEnter the center of the circle: "))
(setq len (getdist ct1 "\nEnter the radius of the circle: "))  
(command "ucs" "o" ct1)
(setq a0 (list 0.0 0.0 0.0))  
(setq pt1 (list 0.0 0.0 0.0))
(command "circle" pt1 len)
(setq t 0)
;;; (the angle=180 for odd and angle=360 for even)
(while (<= t 360) 
(setq r (* len (cos (dttr t))))
(setq x2 (* r (cos (dttr t))))
(setq y2 (* r (sin (dttr t))))
(setq pt2 (list x2 y2 0.0))
(command "pline" pt1 pt2 "")
(if (= t 0) (command "erase" "l" ""))
(setq t (+ 1 t))
(setq pt1 pt2)
)
(command "ucs" "w")
(setvar "cmdecho" ocmd)
(setvar "blipmode" oblp)
(setq *error* olderr)               ; Restore old *error* handler
(princ)
)
