/*
 * Decompiled with CFR 0.152.
 */
package ejb.dataAccess;

import ejb.dataAccess.DataSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DataEJB
implements SessionBean {
    Connection con;

    public void ejbCreate() throws CreateException {
    }

    public void ejbCreate(String string) throws CreateException {
        try {
            this.makeConnection(string);
        }
        catch (Exception exception) {
            throw new EJBException("DataEJB.ejbCreate(), unable to connect to database. " + exception.getMessage());
        }
    }

    private void makeConnection(String string) throws NamingException, SQLException {
        System.out.println("DataEJB.makeConnection()");
        if (this.con == null) {
            InitialContext initialContext = new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup(string);
            this.con = dataSource.getConnection();
        }
    }

    public void setTypeMap(String string, String string2) {
        try {
            Map<String, Class<?>> map = this.con.getTypeMap();
            map.put(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("DataEJB.setTypeMap(), ClassNotFoundException");
            classNotFoundException.printStackTrace();
        }
        catch (SQLException sQLException) {
            System.out.println("DataEJB.setTypeMap(), java.sql.SQLException");
            sQLException.printStackTrace();
        }
    }

    private void closeConnection() {
        System.out.println("DataEJB.closeConnection()");
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException sQLException) {
            throw new EJBException("DataEJB.closeConnection(), unsetEntityContext: " + sQLException.getMessage());
        }
    }

    private int executeUpdate(String string, String string2) {
        int n = 0;
        System.out.println("DataEJB.executeUpdate(String,String)");
        try {
            this.makeConnection(string2);
        }
        catch (Exception exception) {
            throw new EJBException("DataEJB.executeUpdate(String,String), unable to connect to database. " + exception.getMessage());
        }
        try {
            PreparedStatement preparedStatement = this.con.prepareStatement(string);
            n = preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("DataEJB.executeUpdate(String,String) : " + sQLException.toString());
        }
        return n;
    }

    private int executeUpdate(String string, String string2, Object object) {
        int n = 0;
        System.out.println("DataEJB.executeUpdate(String,String,Object)");
        System.out.println("query : " + string);
        System.out.println("ObjectString : " + object.toString());
        try {
            this.makeConnection(string2);
        }
        catch (Exception exception) {
            throw new EJBException("DataEJB.executeUpdate(String, String, Object), Unable to connect to database. " + exception.getMessage());
        }
        try {
            PreparedStatement preparedStatement = this.con.prepareStatement(string);
            preparedStatement.setObject(1, object);
            n = preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("DataEJB.executeUpdate(String,String,Object) : " + sQLException.toString());
        }
        return n;
    }

    public int insert(String string, String string2) {
        System.out.println("DataEJB.insert(String,String)");
        return this.executeUpdate(string, string2);
    }

    public int insert(String string, String string2, Object object) {
        System.out.println("DataEJB.insert(String,String,Object)");
        return this.executeUpdate(string, string2, object);
    }

    public int update(String string, String string2) {
        System.out.println("DataEJB.update(String,String)");
        return this.executeUpdate(string, string2);
    }

    public int update(String string, String string2, Object object) {
        System.out.println("DataEJB.update(String,String,Object)");
        return this.executeUpdate(string, string2, object);
    }

    public int delete(String string, String string2) {
        System.out.println("DataEJB.delete(String,String)");
        return this.executeUpdate(string, string2);
    }

    public DataSet select(String string, String string2) throws Exception, SQLException {
        System.out.println("DataEJB.select(), selectStatement : " + string);
        if (string2 == null) {
            throw new Exception("DataEJB.select(), Null database name not allowed");
        }
        try {
            this.makeConnection(string2);
        }
        catch (Exception exception) {
            throw new EJBException("DataEJB.select(), Unable to connect to database. " + exception.getMessage());
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.con.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            System.out.println("DataEJB.select() : " + sQLException.toString());
        }
        DataSet dataSet = new DataSet(string, this.getColumnNamesVector(resultSet), this.getRowDataVector(resultSet));
        return dataSet;
    }

    private Vector getColumnNamesVector(ResultSet resultSet) {
        System.out.println("DataEJB.getColumnNamesVector()");
        Vector<String> vector = new Vector<String>();
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = 1;
            while (n <= resultSetMetaData.getColumnCount()) {
                vector.addElement(resultSetMetaData.getColumnName(n));
                ++n;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            System.out.println("DataEJB.getColumnNamesVector(), SQLException occured");
            return null;
        }
        return vector;
    }

    private Vector getRowDataVector(ResultSet resultSet) {
        System.out.println("DataEJB.getRowDataVector()");
        Vector<Vector> vector = new Vector<Vector>();
        long l = 0L;
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                System.out.println(l++);
                vector.addElement(this.getNextRow(resultSet, resultSetMetaData));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            System.out.println("DataEJB.getRowDataVector(), SQLException occured");
            return null;
        }
        return vector;
    }

    private Vector getNextRow(ResultSet resultSet, ResultSetMetaData resultSetMetaData) throws SQLException {
        Vector<Object> vector = new Vector<Object>();
        int n = 1;
        while (n <= resultSetMetaData.getColumnCount()) {
            switch (resultSetMetaData.getColumnType(n)) {
                case 12: {
                    vector.addElement(resultSet.getString(n));
                    break;
                }
                case 1: {
                    vector.addElement(resultSet.getString(n));
                    break;
                }
                case 4: {
                    vector.addElement(new Integer(resultSet.getInt(n)));
                    break;
                }
                case -5: {
                    vector.addElement(new Long(resultSet.getLong(n)));
                    break;
                }
                case 8: {
                    vector.addElement(new Double(resultSet.getDouble(n)));
                    break;
                }
                case 6: {
                    vector.addElement(new Float(resultSet.getFloat(n)));
                    break;
                }
                case 1111: {
                    vector.addElement(resultSet.getObject(n));
                    break;
                }
                case 93: {
                    vector.addElement(Timestamp.valueOf(resultSet.getString(n)));
                    break;
                }
                default: {
                    System.out.println("Type was: " + resultSetMetaData.getColumnTypeName(n) + "," + resultSetMetaData.getColumnType(n));
                }
            }
            ++n;
        }
        return vector;
    }

    public void ejbRemove() {
        this.closeConnection();
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void setSessionContext(SessionContext sessionContext) {
    }
}

