/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.Activator;
import com.sun.corba.ee.ActivationIDL.ActivatorHelper;
import com.sun.corba.ee.ActivationIDL.LocatorHelper;
import com.sun.corba.ee.internal.Activation.InitialNamingImpl;
import com.sun.corba.ee.internal.Activation.POAIdMapImpl;
import com.sun.corba.ee.internal.Activation.RepositoryImpl;
import com.sun.corba.ee.internal.Activation.ServerManagerImpl;
import com.sun.corba.ee.internal.CosNaming.BootstrapServer;
import com.sun.corba.ee.internal.CosNaming.TransientNameService;
import com.sun.corba.ee.internal.POA.POAORB;
import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;

public class BootStrapActivation {
    private POAORB orb;
    static final String DefaultDbDir = "orb.db";
    static final String InitialObjectsDb = "initial.db";
    private String dbDirName;
    private File dbDir;
    private InitialNamingImpl ins;

    public BootStrapActivation(POAORB pOAORB) {
        this.orb = pOAORB;
    }

    private void createSystemDirs(String string) {
        File file;
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("file.separator");
        this.dbDir = new File(properties.getProperty("com.sun.corba.ee.internal.Activation.DbDir", String.valueOf(properties.getProperty("user.dir")) + string2 + string));
        this.dbDirName = this.dbDir.getAbsolutePath();
        ((Hashtable)properties).put("com.sun.corba.ee.internal.Activation.DbDir", this.dbDirName);
        if (!this.dbDir.exists()) {
            this.dbDir.mkdir();
        }
        if (!(file = new File(this.dbDir, "logs")).exists()) {
            file.mkdir();
        }
    }

    private void initializeBootNaming() {
        try {
            this.createSystemDirs(DefaultDbDir);
            Properties properties = new Properties();
            String string = System.getProperty("file.separator");
            File file = new File(this.dbDir, String.valueOf(string) + InitialObjectsDb);
            int n2 = this.orb.getORBInitialPort();
            BootstrapServer bootstrapServer = new BootstrapServer(this.orb, n2, file, properties);
            bootstrapServer.start();
            this.ins = new InitialNamingImpl(this.orb, bootstrapServer);
        }
        catch (Exception exception) {
            System.err.println("Exception in Initialize BootNaming");
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public void start() {
        try {
            java.lang.Object object;
            this.initializeBootNaming();
            POAIdMapImpl pOAIdMapImpl = (POAIdMapImpl)this.orb.getInitialService("POAIdMapper");
            if (pOAIdMapImpl == null) {
                pOAIdMapImpl = new POAIdMapImpl(this.orb, this.dbDir, this.orb.orbdDebugFlag);
            }
            this.ins.bind("POAIdMapper", pOAIdMapImpl, false);
            RepositoryImpl repositoryImpl = (RepositoryImpl)this.orb.getInitialService("ServerRepository");
            if (repositoryImpl == null) {
                repositoryImpl = new RepositoryImpl(this.orb, this.dbDir, this.orb.orbdDebugFlag);
            }
            this.ins.bind("ServerRepository", repositoryImpl, false);
            ServerManagerImpl serverManagerImpl = (ServerManagerImpl)this.orb.getInitialService("ServerLocator");
            if (serverManagerImpl == null) {
                object = this.orb.getServerGIOP();
                object.initEndpoints();
                int n2 = object.getDefaultEndpoint().getPort();
                serverManagerImpl = new ServerManagerImpl(this.orb, (short)n2, repositoryImpl, this.dbDirName, this.orb.orbdDebugFlag);
            }
            object = LocatorHelper.narrow(serverManagerImpl);
            this.ins.bind("ServerLocator", (Object)object, false);
            Activator activator = ActivatorHelper.narrow(serverManagerImpl);
            this.ins.bind("ServerActivator", activator, false);
            NamingContext namingContext = (NamingContext)this.orb.getInitialService("NameService");
            if (namingContext == null) {
                TransientNameService transientNameService = new TransientNameService(this.orb);
                namingContext = transientNameService.initialNamingContext();
            }
            this.ins.bind("NameService", namingContext, false);
        }
        catch (Exception exception) {
            System.err.println("Exception during startActivation Objects..");
            System.err.println(exception);
            System.err.flush();
        }
    }
}

