/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.Activation;

import com.sun.corba.ee.ActivationIDL.ActivatorHelper;
import com.sun.corba.ee.ActivationIDL.RepositoryHelper;
import com.sun.corba.ee.ActivationIDL.ServerNotActive;
import com.sun.corba.ee.ActivationIDL.ServerNotRegistered;
import com.sun.corba.ee.internal.Activation.CommandHandler;
import com.sun.corba.ee.internal.Activation.ServerTool;
import java.io.PrintStream;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.IDLEntity;

class UnRegisterServer
implements CommandHandler {
    static final int illegalServerId = -1;

    UnRegisterServer() {
    }

    public String getCommandName() {
        return "unregister";
    }

    public void printCommandHelp(PrintStream printStream, boolean bl2) {
        if (!bl2) {
            printStream.println("\tunregister [ -serverid <server id> | -applicationName <name> ]\n");
        } else {
            printStream.println("unregister a registered server");
        }
    }

    public boolean processCommand(String[] stringArray, ORB oRB, PrintStream printStream) {
        int n2 = -1;
        if (stringArray.length == 2) {
            if (stringArray[0].equals("-serverid")) {
                n2 = Integer.valueOf(stringArray[1]);
            } else if (stringArray[0].equals("-applicationName")) {
                n2 = ServerTool.getServerIdForAlias(oRB, stringArray[1]);
            }
        }
        if (n2 == -1) {
            return true;
        }
        try {
            IDLEntity iDLEntity;
            try {
                iDLEntity = ActivatorHelper.narrow(oRB.resolve_initial_references("ServerActivator"));
                iDLEntity.shutdown(n2);
            }
            catch (ServerNotActive serverNotActive) {}
            iDLEntity = RepositoryHelper.narrow(oRB.resolve_initial_references("ServerRepository"));
            iDLEntity.unregisterServer(n2);
            printStream.println("\tserver unregistered.");
        }
        catch (ServerNotRegistered serverNotRegistered) {
            printStream.println("\tno such server found.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }
}

