/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.CosNaming;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

final class BootstrapServiceProperties {
    private File propFile;
    private long fileModified;
    private Properties savedProps;
    private Properties allProps;

    public BootstrapServiceProperties(File file, Properties properties) {
        this.propFile = file;
        this.savedProps = properties;
        this.allProps = new Properties(this.savedProps);
    }

    protected void check() {
        block4: {
            if (this.propFile == null) {
                return;
            }
            long l2 = this.propFile.lastModified();
            if (l2 <= this.fileModified) break block4;
            try {
                FileInputStream fileInputStream = new FileInputStream(this.propFile);
                ((Hashtable)this.savedProps).clear();
                this.savedProps.load(fileInputStream);
                fileInputStream.close();
                this.fileModified = l2;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("BootstrapServer: could not open \"" + this.propFile.getAbsolutePath() + "\" for reading: file not found!");
            }
            catch (IOException iOException) {
                System.err.println("BootstrapServer: caught exception while loading Properties from file \"" + this.propFile.getAbsolutePath() + "\": " + iOException);
            }
        }
    }

    public synchronized String get(String string) {
        this.check();
        return this.allProps.getProperty(string);
    }

    public synchronized String[] keys() {
        this.check();
        String[] stringArray = null;
        int n2 = ((Hashtable)this.allProps).size() + ((Hashtable)this.savedProps).size();
        if (n2 > 0) {
            stringArray = new String[n2];
            Enumeration<?> enumeration = this.allProps.propertyNames();
            int n3 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n3] = (String)enumeration.nextElement();
                ++n3;
            }
        }
        return stringArray;
    }

    public synchronized String put(String string, String string2, boolean bl2) {
        String string3;
        block4: {
            if (!bl2) {
                return ((Hashtable)this.allProps).put(string, string2);
            }
            string3 = ((Hashtable)this.savedProps).put(string, string2);
            if (this.propFile == null) break block4;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.propFile);
                this.savedProps.save(fileOutputStream, null);
                fileOutputStream.close();
                this.fileModified = this.propFile.lastModified();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("BootstrapServer: could not open \"" + this.propFile.getAbsolutePath() + "\" for writing: file not found!");
            }
            catch (IOException iOException) {
                System.err.println("BootstrapServer: caught exception while saving Properties to file \"" + this.propFile.getAbsolutePath() + "\": " + iOException);
            }
        }
        return string3;
    }
}

