/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.sun.corba.ee.internal.corba.ORB;
import com.sun.corba.ee.internal.iiop.CDRInputStream;
import com.sun.corba.ee.internal.iiop.CDROutputStream;
import com.sun.corba.ee.internal.util.Utility;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class ServiceContext {
    protected InputStream in = null;

    protected ServiceContext() {
    }

    protected ServiceContext(InputStream inputStream) throws SystemException {
        ORB oRB = (ORB)((CDRInputStream)inputStream).getORB();
        if (oRB.serviceContextDebugFlag) {
            this.dprint("Reading service context from stream");
        }
        int n2 = inputStream.read_long();
        if (oRB.serviceContextDebugFlag) {
            this.dprint("Service context length = " + n2);
        }
        byte[] byArray = new byte[n2];
        inputStream.read_octet_array(byArray, 0, n2);
        CDRInputStream cDRInputStream = new CDRInputStream(inputStream.orb(), byArray, byArray.length);
        cDRInputStream.consumeEndian();
        this.in = cDRInputStream;
    }

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public abstract int getId();

    public String toString() {
        return "ServiceContext[ id=" + this.getId() + " ]";
    }

    public void write(OutputStream outputStream) throws SystemException {
        CDROutputStream cDROutputStream = new CDROutputStream(outputStream.orb());
        cDROutputStream.putEndian();
        this.writeData(cDROutputStream);
        byte[] byArray = cDROutputStream.toByteArray();
        outputStream.write_long(this.getId());
        outputStream.write_long(byArray.length);
        outputStream.write_octet_array(byArray, 0, byArray.length);
    }

    protected abstract void writeData(OutputStream var1);
}

