/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.iiop.CancelRequestMessage;
import com.sun.corba.ee.internal.iiop.LocateReplyMessage;
import com.sun.corba.ee.internal.iiop.LocateRequestMessage;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.ReplyMessage;
import com.sun.corba.ee.internal.iiop.RequestMessage;
import com.sun.corba.ee.internal.util.Utility;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class Message {
    protected boolean debug = false;
    static final int defaultBufferSize = 1024;
    static final int GIOPBigEndian = 0;
    static final int GIOPLittleEndian = 1;
    static final int GIOPBigMagic = 1195986768;
    static final int GIOPLittleMagic = 1347373383;
    static final int GIOPMajor = 1;
    static final int GIOPMinor = 0;
    public static final int GIOPMessageHeaderLength = 12;
    public static final int GIOPRequest = 0;
    public static final int GIOPReply = 1;
    public static final int GIOPCancelRequest = 2;
    public static final int GIOPLocateRequest = 3;
    public static final int GIOPLocateReply = 4;
    public static final int GIOPCloseConnection = 5;
    public static final int GIOPMessageError = 6;
    public static final int GIOPLocateReplyUnknownObject = 0;
    public static final int GIOPLocateReplyObjectHere = 1;
    public static final int GIOPLocateReplyObjectForward = 2;
    private int magic;
    private byte major;
    private byte minor;
    private byte byteOrder;
    private byte type;
    private int size;
    protected int requestId;

    protected Message(boolean bl2) {
        this.debug = bl2;
    }

    public static Message createFromStream(ORB oRB, byte[] byArray, java.io.InputStream inputStream) throws SystemException, IOException {
        Message message;
        boolean bl2 = oRB.transportDebugFlag;
        Message.readFully(inputStream, byArray, 0, 12);
        if (bl2) {
            Utility.dprint("Message", "createFromStream: type is " + byArray[7]);
        }
        switch (byArray[7]) {
            case 0: {
                if (bl2) {
                    Utility.dprint("Message", "createFromStream: creating RequestMessage");
                }
                message = new RequestMessage(bl2);
                break;
            }
            case 3: {
                message = new LocateRequestMessage(bl2);
                break;
            }
            case 2: {
                message = new CancelRequestMessage(bl2);
                break;
            }
            case 1: {
                message = new ReplyMessage(bl2);
                break;
            }
            case 4: {
                message = new LocateReplyMessage(bl2);
                break;
            }
            case 5: 
            case 6: {
                message = new Message(bl2);
                break;
            }
            default: {
                if (bl2) {
                    Utility.dprint("Message", "createFromStream: fell off end!");
                }
                throw new INTERNAL(1398079499, CompletionStatus.COMPLETED_NO);
            }
        }
        int n2 = byArray[0] << 24 & 0xFF000000;
        int n3 = byArray[1] << 16 & 0xFF0000;
        int n4 = byArray[2] << 8 & 0xFF00;
        int n5 = byArray[3] & 0xFF;
        message.magic = n2 | n3 | n4 | n5;
        message.major = byArray[4];
        message.minor = byArray[5];
        message.byteOrder = byArray[6];
        message.type = byArray[7];
        if (message.byteOrder == 0) {
            n2 = byArray[8] << 24 & 0xFF000000;
            n3 = byArray[9] << 16 & 0xFF0000;
            n4 = byArray[10] << 8 & 0xFF00;
            n5 = byArray[11] & 0xFF;
        } else {
            n2 = byArray[11] << 24 & 0xFF000000;
            n3 = byArray[10] << 16 & 0xFF0000;
            n4 = byArray[9] << 8 & 0xFF00;
            n5 = byArray[8] & 0xFF;
        }
        message.size = (n2 | n3 | n4 | n5) + 12;
        if (bl2) {
            Utility.dprint("Message", "createFromStream: message construction complete.");
        }
        return message;
    }

    byte getByteOrder() {
        return this.byteOrder;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getSize() {
        return this.size;
    }

    public final int getType() {
        return this.type;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean isLittleEndian() {
        return this.byteOrder == 1;
    }

    public void read(InputStream inputStream) throws SystemException {
    }

    public static void readFully(java.io.InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            int n6 = 0;
            while (true) {
                try {
                    n5 = inputStream.read(byArray, n2 + n4, n3 - n4);
                }
                catch (IOException iOException) {
                    if (n6++ < 5) continue;
                    throw iOException;
                }
                break;
            }
            if (n5 < 0) {
                throw new IOException();
            }
            n4 += n5;
        }
    }

    public void setSize(byte[] byArray, int n2) {
        this.size = n2;
        int n3 = n2 - 12;
        if (this.byteOrder == 0) {
            byArray[8] = (byte)(n3 >>> 24 & 0xFF);
            byArray[9] = (byte)(n3 >>> 16 & 0xFF);
            byArray[10] = (byte)(n3 >>> 8 & 0xFF);
            byArray[11] = (byte)(n3 & 0xFF);
        } else {
            byArray[8] = (byte)(n3 & 0xFF);
            byArray[9] = (byte)(n3 >>> 8 & 0xFF);
            byArray[10] = (byte)(n3 >>> 16 & 0xFF);
            byArray[11] = (byte)(n3 >>> 24 & 0xFF);
        }
    }

    protected void setType(int n2) {
        this.type = (byte)n2;
    }

    public void write(OutputStream outputStream) throws SystemException {
        outputStream.write_long(1195986768);
        outputStream.write_octet((byte)1);
        outputStream.write_octet((byte)0);
        outputStream.write_boolean(false);
        outputStream.write_octet(this.type);
        outputStream.write_long(0);
    }
}

