/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.RequestHandler;
import com.sun.corba.ee.internal.core.ServerRequest;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.IIOPInputStream;
import com.sun.corba.ee.internal.iiop.IIOPOutputStream;
import com.sun.corba.ee.internal.iiop.LocateReplyMessage;
import com.sun.corba.ee.internal.iiop.LocateRequestMessage;
import com.sun.corba.ee.internal.iiop.Message;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.corba.ee.internal.iiop.ORBThread;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;

public class WorkerThread
extends ORBThread {
    private Connection conn = null;
    private IIOPInputStream request = null;
    private IIOPOutputStream response = null;
    private int msgType;
    private RequestHandler handler;

    public WorkerThread(RequestHandler requestHandler, Connection connection, IIOPInputStream iIOPInputStream) {
        this.conn = connection;
        this.request = iIOPInputStream;
        this.handler = requestHandler;
    }

    public void run() {
        Message message = this.request.getMessage();
        ORB oRB = this.request.getConnection().getORB();
        this.conn.requestBegins();
        switch (message.getType()) {
            case 0: {
                ServerRequest serverRequest = (ServerRequest)((Object)this.request);
                try {
                    this.response = (IIOPOutputStream)((Object)this.handler.process(serverRequest));
                    if (!serverRequest.isOneWay()) break;
                    this.conn.requestEnds();
                    Thread.currentThread().stop();
                    break;
                }
                catch (SystemException systemException) {
                    try {
                        this.response = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(systemException, null));
                        break;
                    }
                    catch (Exception exception) {
                        this.conn.requestEnds();
                        return;
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    UNKNOWN uNKNOWN = new UNKNOWN(1398079492, CompletionStatus.COMPLETED_MAYBE);
                    try {
                        this.response = (IIOPOutputStream)((Object)serverRequest.createSystemExceptionResponse(uNKNOWN, null));
                        break;
                    }
                    catch (Exception exception) {
                        this.conn.requestEnds();
                        return;
                    }
                }
            }
            case 3: {
                LocateReplyMessage locateReplyMessage;
                LocateRequestMessage locateRequestMessage = (LocateRequestMessage)message;
                int n2 = message.getRequestId();
                IOR iOR = null;
                try {
                    iOR = this.handler.locate(locateRequestMessage.getObjectKey());
                    locateReplyMessage = iOR == null ? new LocateReplyMessage(n2, 1, oRB.transportDebugFlag) : new LocateReplyMessage(n2, 2, oRB.transportDebugFlag);
                }
                catch (Exception exception) {
                    locateReplyMessage = new LocateReplyMessage(n2, 0, oRB.transportDebugFlag);
                }
                this.response = new IIOPOutputStream(oRB, this.request.getConnection());
                locateReplyMessage.write(this.response);
                this.response.setMessage(locateReplyMessage);
                if (iOR == null) break;
                iOR.write(this.response);
                break;
            }
            case 2: {
                this.conn.requestEnds();
                return;
            }
            default: {
                this.conn.requestEnds();
                return;
            }
        }
        try {
            this.conn.sendReply(this.response);
            this.conn.requestEnds();
        }
        catch (Exception exception) {
            this.conn.requestEnds();
            return;
        }
    }
}

