/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.io;

import com.sun.corba.ee.internal.io.ObjectStreamClass;
import java.lang.reflect.Field;

public class ObjectStreamField
implements Comparable {
    private String name;
    private String signature;
    private char type;
    private Field field;
    private String typeString;
    private Class clazz;
    private ObjectStreamClass osc;
    private long fieldID = -1L;
    private int isAny = -1;
    static /* synthetic */ Class class$java$lang$Object;

    ObjectStreamField() {
    }

    ObjectStreamField(String string, char c10, Field field, String string2) {
        this.name = string;
        this.type = c10;
        this.field = field;
        this.typeString = string2;
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    ObjectStreamField(String string, Class clazz) {
        this.name = string;
        this.clazz = clazz;
        this.osc = ObjectStreamClass.lookup(clazz);
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.type = (char)73;
            } else if (clazz == Byte.TYPE) {
                this.type = (char)66;
            } else if (clazz == Long.TYPE) {
                this.type = (char)74;
            } else if (clazz == Float.TYPE) {
                this.type = (char)70;
            } else if (clazz == Double.TYPE) {
                this.type = (char)68;
            } else if (clazz == Short.TYPE) {
                this.type = (char)83;
            } else if (clazz == Character.TYPE) {
                this.type = (char)67;
            } else if (clazz == Boolean.TYPE) {
                this.type = (char)90;
            }
        } else if (clazz.isArray()) {
            this.type = (char)91;
            this.typeString = ObjectStreamClass.getSignature(clazz);
        } else {
            this.type = (char)76;
            this.typeString = ObjectStreamClass.getSignature(clazz);
        }
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    ObjectStreamField(Field field) {
        this(field.getName(), field.getType());
        this.field = field;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int compareTo(Object object) {
        boolean bl2;
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        boolean bl3 = this.typeString == null;
        boolean bl4 = bl2 = objectStreamField.typeString == null;
        if (bl3 != bl2) {
            return bl3 ? -1 : 1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    public Class getClazz() {
        return this.clazz;
    }

    Field getField() {
        return this.field;
    }

    public long getFieldID(Class clazz) {
        if (this.fieldID == -1L) {
            this.fieldID = this.typeString != null ? ObjectStreamField.getFieldIDNative(clazz, this.getName(), this.typeString) : ObjectStreamField.getFieldIDNative(clazz, this.getName(), this.getSignature());
        }
        return this.fieldID;
    }

    private static native long getFieldIDNative(Class var0, String var1, String var2);

    public String getName() {
        return this.name;
    }

    public ObjectStreamClass getObjectStreamClass() {
        if (this.osc == null) {
            this.osc = ObjectStreamClass.lookup(this.clazz);
        }
        return this.osc;
    }

    public String getSignature() {
        return this.signature;
    }

    public Class getType() {
        if (this.clazz != null) {
            return this.clazz;
        }
        switch (this.type) {
            case 'B': {
                this.clazz = Byte.TYPE;
                break;
            }
            case 'C': {
                this.clazz = Character.TYPE;
                break;
            }
            case 'S': {
                this.clazz = Short.TYPE;
                break;
            }
            case 'I': {
                this.clazz = Integer.TYPE;
                break;
            }
            case 'J': {
                this.clazz = Long.TYPE;
                break;
            }
            case 'F': {
                this.clazz = Float.TYPE;
                break;
            }
            case 'D': {
                this.clazz = Double.TYPE;
                break;
            }
            case 'Z': {
                this.clazz = Boolean.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.clazz = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ObjectStreamField.class$("java.lang.Object"));
                break;
            }
        }
        return this.clazz;
    }

    public char getTypeCode() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public boolean isAny() {
        if (this.isAny == -1) {
            this.isAny = this.typeString != null && (this.typeString.equals("Ljava/lang/Object;") || this.typeString.equals("Ljava/io/Serializable;") || this.typeString.equals("Ljava/io/Externalizable;")) ? 1 : 0;
        }
        return this.isAny == 1;
    }

    public boolean isPrimitive() {
        return this.type != '[' && this.type != 'L';
    }

    void setField(Field field) {
        this.field = field;
        this.fieldID = -1L;
    }

    public String toString() {
        if (this.typeString != null) {
            return String.valueOf(this.typeString) + " " + this.name;
        }
        return String.valueOf(this.type) + " " + this.name;
    }

    public boolean typeEquals(ObjectStreamField objectStreamField) {
        if (objectStreamField == null || this.type != objectStreamField.type) {
            return false;
        }
        if (this.typeString == null && objectStreamField.typeString == null) {
            return true;
        }
        return ObjectStreamClass.compareClassNames(this.typeString, objectStreamField.typeString, '/');
    }
}

