/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ejbstore;

import com.sun.ejb.ComponentContext;
import com.sun.ejb.Container;
import com.sun.ejb.EJBStore;
import com.sun.ejb.Recycler;
import com.sun.ejb.containers.BaseContainer;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class SimpleSessionStore
implements EJBStore {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$ejb$ejbstore$SimpleSessionStore != null ? class$com$sun$ejb$ejbstore$SimpleSessionStore : (class$com$sun$ejb$ejbstore$SimpleSessionStore = SimpleSessionStore.class$("com.sun.ejb.ejbstore.SimpleSessionStore")));
    private static final int KEYLENGTH = 8;
    private static final int EJB_OFFSET = 4;
    private static final double LOW_WATER_MARK = 0.25;
    private final boolean debug = false;
    private Recycler recycler;
    private Hashtable table = new Hashtable();
    private Hashtable passiveTable = new Hashtable();
    private long instanceCount = 1L;
    private File tmpFile = null;
    private File tmpDir = null;
    private RandomAccessFile dataFile = null;
    private int nHoles = 0;
    static /* synthetic */ Class class$com$sun$ejb$ejbstore$SimpleSessionStore;

    public SimpleSessionStore(Recycler recycler) {
        this.recycler = recycler;
        String hostname = Utility.getLocalHost();
        String relPath = "repository" + File.separator + hostname + File.separator + "sessionstore";
        String absPath = FileUtil.getAbsolutePath(relPath);
        this.tmpDir = new File(absPath);
        if (!this.tmpDir.exists() && !this.tmpDir.mkdirs()) {
            RuntimeException ex2 = new RuntimeException("Unable to create directory " + absPath);
            Log.err.println(ex2);
            throw ex2;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private synchronized void compactDataFile() {
        try {
            Hashtable hashtable = this.passiveTable;
            synchronized (hashtable) {
                if (this.dataFile == null) {
                    this.dataFile = new RandomAccessFile(this.tmpFile, "rw");
                }
                File newTmp = this.createTempFile();
                RandomAccessFile newData = new RandomAccessFile(newTmp, "rw");
                long offset = 0L;
                int totrecords = 0;
                int copyrecords = 0;
                while (offset < this.dataFile.length()) {
                    this.dataFile.seek(offset);
                    int len = this.dataFile.readInt();
                    long key = this.dataFile.readLong();
                    Long lkey = new Long(key);
                    Object offsetInfo = this.passiveTable.get(lkey);
                    if (offsetInfo != null && (Long)offsetInfo == offset) {
                        this.passiveTable.put(lkey, new Long(newData.getFilePointer()));
                        newData.writeInt(len);
                        newData.writeLong(key);
                        byte[] data = new byte[len];
                        this.dataFile.read(data);
                        newData.write(data);
                        ++copyrecords;
                    }
                    offset += (long)(len + 4 + 8);
                    ++totrecords;
                }
                this.dataFile.close();
                this.tmpFile.delete();
                this.tmpFile = newTmp;
                this.dataFile = newData;
                this.nHoles = 0;
            }
        }
        catch (Exception exception) {}
    }

    private File createTempFile() throws Exception {
        File tmp = File.createTempFile("SessionStore", null, this.tmpDir);
        tmp.deleteOnExit();
        return tmp;
    }

    public void deleteEJB(Object key, Container container) {
        Long lkey = new Long(Utility.bytesToLong((byte[])key, 0));
        this.table.remove(lkey);
        Hashtable hashtable = this.passiveTable;
        synchronized (hashtable) {
            if (this.passiveTable.remove(lkey) != null) {
                ++this.nHoles;
            }
        }
    }

    public Enumeration listActiveEJBKeys() {
        Enumeration lkeys = this.table.keys();
        Vector<byte[]> bkeys = new Vector<byte[]>();
        while (lkeys.hasMoreElements()) {
            byte[] bkey = new byte[8];
            Long lkey = (Long)lkeys.nextElement();
            Utility.longToBytes(lkey, bkey, 0);
            bkeys.add(bkey);
        }
        return bkeys.elements();
    }

    private synchronized byte[] loadState(Object passiveEJBInfo) throws Exception {
        if (this.dataFile == null) {
            this.dataFile = new RandomAccessFile(this.tmpFile, "rw");
        }
        long offset = (Long)passiveEJBInfo;
        this.dataFile.seek(offset);
        int len = this.dataFile.readInt();
        long key = this.dataFile.readLong();
        byte[] data = new byte[len];
        this.dataFile.read(data);
        return data;
    }

    public Object lookupEJB(Object key, Container cont) {
        BaseContainer container = (BaseContainer)cont;
        Long lkey = new Long(Utility.bytesToLong((byte[])key, 0));
        Object obj = this.table.get(lkey);
        if (obj != null) {
            return obj;
        }
        if (this.table.size() % 10 == 0) {
            this.recycler.recycle();
        }
        Hashtable hashtable = this.passiveTable;
        synchronized (hashtable) {
            Long passiveEJBInfo = (Long)this.passiveTable.get(lkey);
            if (passiveEJBInfo == null) {
                Object var6_8 = null;
                Object var8_12 = null;
                return var6_8;
            }
            try {
                byte[] data = this.loadState(passiveEJBInfo);
                obj = container.deserializeObject(data);
            }
            catch (Exception ex2) {
                Log.err.println(ex2);
                Object var6_9 = null;
                Object var8_13 = null;
                return var6_9;
            }
            catch (Error ex3) {
                Log.err.println(ex3);
                Object var6_10 = null;
                Object var8_14 = null;
                return var6_10;
            }
            this.table.put(lkey, obj);
            try {
                container.activateEJB(obj, key);
            }
            catch (RemoteException ex4) {
                Log.err.println(ex4);
                this.table.remove(lkey);
                Object var6_11 = null;
                Object var8_15 = null;
                return var6_11;
            }
            this.passiveTable.remove(lkey);
            ++this.nHoles;
        }
        return obj;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void passivateEJBs(Enumeration toPassivate) {
        if (this.nHoles > this.passiveTable.size()) {
            this.compactDataFile();
        }
        try {
            if (this.dataFile == null) {
                if (this.tmpFile == null) {
                    this.tmpFile = this.createTempFile();
                }
                this.dataFile = new RandomAccessFile(this.tmpFile, "rw");
            }
        }
        catch (Exception ex) {
            Log.err.println(ex);
            return;
        }
        while (true) lbl-1000:
        // 6 sources

        {
            if (!toPassivate.hasMoreElements()) {
                ** try [egrp 5[TRYBLOCK] [7 : 341->351)] { 
lbl15:
                // 1 sources

                ** break;
            }
            bkey = (byte[])toPassivate.nextElement();
            key = Utility.bytesToLong(bkey, 0);
            lkey = new Long(key);
            ctx = (ComponentContext)this.table.get(lkey);
            container = (BaseContainer)ctx.getContainer();
            try {
                var8_8 = ctx;
                synchronized (var8_8) {
                    block23: {
                        var10_12 = this.passiveTable;
                        synchronized (var10_12) {
                            block22: {
                                passivateOK = container.passivateEJB(ctx);
                                if (!passivateOK) {
                                    var11_13 = null;
                                    break block22;
                                }
                                data = container.serializeObject(ctx);
                                passiveEJBInfo = this.saveState(data, key);
                                this.table.remove(lkey);
                                this.passiveTable.put(lkey, passiveEJBInfo);
                                break block23;
                            }
                        }
                        var9_11 = null;
                        break;
                    }
                }
            }
            catch (Exception ex) {
                Log.err.println(ex);
            }
            catch (OutOfMemoryError v2) {
                try {
                    this.dataFile.close();
                    this.dataFile = new RandomAccessFile(this.tmpFile, "rw");
                    data = container.serializeObject(ctx);
                    passiveEJBInfo = this.saveState(data, key);
                    this.passiveTable.put(lkey, passiveEJBInfo);
                    this.table.remove(lkey);
                }
                catch (Exception v3) {}
                continue;
            }
            catch (Error ex) {
                Log.err.println(ex);
                throw ex;
            }
            break;
        }
        {
            ** GOTO lbl-1000
lbl72:
            // 1 sources

            this.dataFile.close();
        }
lbl74:
        // 1 sources

        catch (Exception v4) {}
        this.dataFile = null;
    }

    private synchronized Object saveState(byte[] data, long key) throws Exception {
        long len = this.dataFile.length();
        this.dataFile.seek(len);
        long beginOffset = this.dataFile.getFilePointer();
        this.dataFile.writeInt(data.length);
        this.dataFile.writeLong(key);
        this.dataFile.write(data);
        return new Long(beginOffset);
    }

    public Object storeEJB(Object obj, Container container) {
        long key;
        if (this.table.size() % 10 == 0) {
            this.recycler.recycle();
        }
        SimpleSessionStore simpleSessionStore = this;
        synchronized (simpleSessionStore) {
            key = this.instanceCount++;
        }
        long containerId = container.getContainerId();
        Long lkey = new Long(key |= containerId << 32);
        this.table.put(lkey, obj);
        byte[] instanceKey = new byte[8];
        Utility.longToBytes(key, instanceKey, 0);
        return instanceKey;
    }

    public void storeEJB(Object obj, Object key, Container container) {
        throw new RuntimeException(localStrings.getLocalString("ejbstore.sessionstore_notimpl", "SimpleSessionStore.storeEJB(obj, key) not implemented"));
    }
}

