/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.activation;

import com.sun.enterprise.log.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ServerMain {
    public static final int VALID_SERVER_DEF = 0;
    public static final int MAIN_CLASS_NOT_FOUND = 1;
    public static final int NO_MAIN_METHOD = 2;
    public static final int APPLICATION_ERROR = 3;
    public static final int UNKNOWN_ERROR = 4;
    public static final String LOG_FILE = "system";
    public static final String OUTPUT_LOG = "system.out";
    public static final String ERROR_LOG = "system.err";
    private static final boolean debug = false;

    public static void main(String[] args) {
        ServerMain server = new ServerMain();
        server.run(args);
    }

    private void run(String[] args) {
        boolean verify = Boolean.getBoolean("com.sun.enterprise.activation.ServerVerify");
        try {
            Class<?> serverClass = Class.forName(System.getProperty("com.sun.enterprise.activation.ServerName"));
            Method[] methods = serverClass.getMethods();
            Method mainMethod = null;
            int i2 = 0;
            while (i2 < methods.length) {
                Class<?>[] parmTypes;
                int modifiers;
                Method method = methods[i2];
                if (method.getName().equals("main") && Modifier.isPublic(modifiers = method.getModifiers()) && Modifier.isStatic(modifiers) && method.getExceptionTypes().length == 0 && method.getReturnType().equals(Void.TYPE) && (parmTypes = method.getParameterTypes()).length == 1 && parmTypes[0].isArray() && parmTypes[0].getComponentType().getName().equals("java.lang.String")) {
                    mainMethod = method;
                    break;
                }
                ++i2;
            }
            if (verify) {
                if (mainMethod == null) {
                    System.exit(2);
                } else {
                    System.exit(0);
                }
            }
            try {
                String server = System.getProperty("EJBServer.EJB_SERVER_ID");
                String appname = System.getProperty("com.sun.enterprise.appname");
                if (appname == null || appname.equals("")) {
                    appname = server;
                }
                File logDir = LogUtil.getLogDirectory(appname, "ejb");
                FileOutputStream foutStream = new FileOutputStream(new File(logDir, OUTPUT_LOG).getAbsolutePath(), true);
                FileOutputStream ferrStream = new FileOutputStream(new File(logDir, ERROR_LOG).getAbsolutePath(), true);
                PrintStream pSout = new PrintStream(foutStream, true);
                PrintStream pSerr = new PrintStream(ferrStream, true);
                LogUtil.printInfo(pSout);
                LogUtil.printInfo(pSerr);
                System.setOut(pSout);
                System.setErr(pSerr);
            }
            catch (Exception exception) {}
            Object[] params = new Object[]{args};
            mainMethod.invoke(null, params);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.exit(1);
        }
        catch (Exception exception) {
            System.exit(3);
        }
    }
}

