/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.activation;

import com.sun.enterprise.activation.Server;
import com.sun.enterprise.activation.ServerDef;

public class ServerTableEntry {
    private static final boolean debug = false;
    private static final int DE_ACTIVATED = 0;
    private static final int ACTIVATING = 1;
    private static final int ACTIVATED = 2;
    private static final int RUNNING = 3;
    private static final int HELD_DOWN = 4;
    private static final long waitTime = 2000L;
    private static final int ActivationRetryMax = 5;
    private int state;
    private int serverId;
    private int serverPort;
    private Server serverObj;
    private ServerDef serverDef;
    private Process process;
    private int activateRetryCount = 0;
    private String activationCmd;
    private static String javaHome = System.getProperty("java.home");
    private static String classPath = System.getProperty("java.class.path");
    private static String fileSep = System.getProperty("file.separator");
    private static String pathSep = System.getProperty("path.separator");
    private static String ioser = System.getProperty("ioser");

    ServerTableEntry(int serverId, ServerDef serverDef, int initialPort, String dbDirName, boolean verify, int ejbdPort, boolean usePoa) {
        this.serverId = serverId;
        this.serverDef = serverDef;
        this.activateRetryCount = 0;
        this.state = 1;
        this.activationCmd = String.valueOf(javaHome) + fileSep + "bin" + fileSep + "java " + serverDef.serverVmArgs + " " + "" + "-Dcom.sun.enterprise.home=" + System.getProperty("com.sun.enterprise.home", "") + " " + "-Dorg.omg.CORBA.ORBInitialPort=" + initialPort + " " + "-D" + "com.sun.enterprise.activation.DbDir" + "=" + dbDirName + " " + "-D" + "com.sun.enterprise.activation.EJBServerId" + "=" + serverId + " " + "-D" + "com.sun.enterprise.activation.EJBDaemonPort" + "=" + ejbdPort + " " + "-D" + "com.sun.enterprise.appname" + "=" + serverDef.alias + " " + "-D" + "com.sun.enterprise.activation.ServerName=" + serverDef.serverName + " " + "-classpath " + classPath + (serverDef.serverClassPath.equals("") ? "" : pathSep) + serverDef.serverClassPath + " com.sun.enterprise.activation.ServerMain " + serverDef.serverArgs;
    }

    synchronized void activate() {
        try {
            this.process = Runtime.getRuntime().exec(this.activationCmd);
        }
        catch (Exception exception) {
            this.deActivate();
            throw new RuntimeException("unable_to_start_process");
        }
        this.state = 2;
    }

    synchronized void deActivate() {
        this.state = 0;
        this.notifyAll();
    }

    void destroy() {
        this.deActivate();
        try {
            if (this.serverObj != null) {
                this.serverObj.shutdown();
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        try {
            if (this.process != null) {
                this.process.destroy();
            }
        }
        catch (Exception ex3) {
            ex3.printStackTrace();
        }
    }

    int getPort() {
        return this.serverPort;
    }

    public ServerDef getServerDef() {
        return this.serverDef;
    }

    int getServerId() {
        return this.serverId;
    }

    synchronized void holdDown() {
        this.state = 4;
        this.notifyAll();
    }

    boolean isActive() {
        return this.state == 3 || this.state == 2;
    }

    synchronized boolean isValid() {
        if (this.state == 1 || this.state == 4) {
            return true;
        }
        try {
            int exitVal = this.process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return true;
        }
        if (this.state == 2) {
            if (this.activateRetryCount < 5) {
                ++this.activateRetryCount;
                this.activate();
                return true;
            }
            this.holdDown();
            return true;
        }
        this.deActivate();
        return false;
    }

    synchronized int lookup() {
        while (this.state == 1 || this.state == 2) {
            try {
                this.wait(2000L);
                if (this.isValid()) continue;
                break;
            }
            catch (Exception exception) {}
        }
        if (this.state == 3) {
            return this.serverPort;
        }
        throw new RuntimeException("SERVER_IS_HELD_DOWN");
    }

    private void printDebug(String method, String msg) {
        System.out.println("method  =" + method);
        System.out.println("server  =" + this.serverId);
        System.out.println("state   =" + this.printState());
        System.out.println("message =" + msg);
        System.out.println();
    }

    private String printState() {
        String str = "UNKNOWN";
        switch (this.state) {
            case 0: {
                str = "DE_ACTIVATED";
                break;
            }
            case 1: {
                str = "ACTIVATING  ";
                break;
            }
            case 2: {
                str = "ACTIVATED   ";
                break;
            }
            case 3: {
                str = "RUNNING     ";
                break;
            }
            case 4: {
                str = "HELD_DOWN   ";
                break;
            }
        }
        return str;
    }

    synchronized void register(Server server) {
        if (this.state == 2) {
            this.serverObj = server;
            try {
                this.serverPort = server.getEndpoint(0);
            }
            catch (Exception exception) {}
        } else {
            throw new RuntimeException("SERVER_NOT_EXPECTED_TO_REGISTER");
        }
        this.state = 3;
        this.notifyAll();
    }
}

