/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class EjbEntityDescriptor
extends EjbDescriptor {
    private Set allSqlStatementedMethods = null;
    private Set persistentFields = new HashSet();
    private boolean isReentrant = false;
    private String primaryKeyClassName;
    private FieldDescriptor primaryKeyField = null;
    private String persistenceType;
    public static String TYPE = "Entity";
    public static String BEAN_PERSISTENCE = "Bean";
    public static String CONTAINER_PERSISTENCE = "Container";
    private ResourceReferenceDescriptor resourceReference;
    private Hashtable methodSqlMap = new Hashtable();
    private String tableCreateSqlStatement;
    private String tableRemoveSqlStatement;
    private boolean createTableOnDeployment = true;
    private boolean deleteTableOnUndeployment = true;
    public static String TRUE = "True";
    public static String FALSE = "False";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbEntityDescriptor != null ? class$com$sun$enterprise$deployment$EjbEntityDescriptor : (class$com$sun$enterprise$deployment$EjbEntityDescriptor = EjbEntityDescriptor.class$("com.sun.enterprise.deployment.EjbEntityDescriptor")));
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbEntityDescriptor;
    static /* synthetic */ Class class$java$lang$Object;

    public EjbEntityDescriptor() {
    }

    public EjbEntityDescriptor(EjbDescriptor other) {
        super(other);
        if (other instanceof EjbEntityDescriptor) {
            EjbEntityDescriptor entity = (EjbEntityDescriptor)other;
            this.getPersistentFields().addAll(entity.getPersistentFields());
            this.isReentrant = entity.isReentrant;
            this.resourceReference = entity.getResourceReference();
            this.methodSqlMap = new Hashtable(entity.getMethodSqlMap());
            this.tableCreateSqlStatement = entity.tableCreateSqlStatement;
            this.tableRemoveSqlStatement = entity.tableRemoveSqlStatement;
            this.deleteTableOnUndeployment = entity.deleteTableOnUndeployment;
        }
    }

    public EjbEntityDescriptor(String name, String homeClassName, String remoteClassName, String ejbClassName, String primaryKeyClassName) {
        super(name, homeClassName, remoteClassName, ejbClassName);
        this.primaryKeyClassName = primaryKeyClassName;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public boolean classesChanged() {
        boolean superChanged;
        boolean iChanged = false;
        if (this.getPersistenceType().equals(CONTAINER_PERSISTENCE)) {
            Vector newFieldDescriptors = this.getFieldDescriptors();
            Iterator itr = this.persistentFields.iterator();
            while (itr.hasNext()) {
                FieldDescriptor field = (FieldDescriptor)itr.next();
                if (newFieldDescriptors.contains(field)) continue;
                itr.remove();
                iChanged = true;
            }
        }
        if (!(superChanged = super.classesChanged()) && iChanged) {
            this.changed();
        }
        return iChanged || superChanged;
    }

    Set getAllMethodDescriptors() {
        Set all = super.getAllMethodDescriptors();
        all.addAll(this.getSqlStatementedMethods());
        return all;
    }

    public Set getAllSqlStatementedMethods() {
        if (this.allSqlStatementedMethods == null) {
            try {
                Archivist ar2 = this.getEjbBundleDescriptor().getArchivist();
                ClassLoader loader = ((EjbBundleArchivist)ar2).getClassLoader();
                Class<?> ejbClass = loader.loadClass(this.getEjbClassName());
                Class<?> homeIntf = loader.loadClass(this.getHomeClassName());
                this.allSqlStatementedMethods = new HashSet();
                MethodDescriptor md = new MethodDescriptor("ejbCreate", null, MethodDescriptor.EJB_BEAN);
                this.allSqlStatementedMethods.add(md);
                md = new MethodDescriptor(ejbClass.getMethod("ejbRemove", null), this, loader);
                this.allSqlStatementedMethods.add(md);
                md = new MethodDescriptor(ejbClass.getMethod("ejbStore", null), this, loader);
                this.allSqlStatementedMethods.add(md);
                md = new MethodDescriptor(ejbClass.getMethod("ejbLoad", null), this, loader);
                this.allSqlStatementedMethods.add(md);
                Method[] homeMethods = homeIntf.getMethods();
                int i2 = 0;
                while (i2 < homeMethods.length) {
                    if (homeMethods[i2].getName().startsWith("find")) {
                        md = new MethodDescriptor(homeMethods[i2], this, loader);
                        this.allSqlStatementedMethods.add(md);
                    }
                    ++i2;
                }
            }
            catch (Exception ex2) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbldngsqlstatementmthds", "Error building allSqlStatementedMethods {0}", new Object[]{ex2}));
            }
        }
        return this.allSqlStatementedMethods;
    }

    public boolean getCreateTableOnDeployment() {
        return this.createTableOnDeployment;
    }

    public boolean getDeleteTableOnUndeployment() {
        return this.deleteTableOnUndeployment;
    }

    private Hashtable getMethodSqlMap() {
        if (this.methodSqlMap == null) {
            this.methodSqlMap = new Hashtable();
        }
        return this.methodSqlMap;
    }

    public String getPersistenceType() {
        if (this.persistenceType == null) {
            this.persistenceType = BEAN_PERSISTENCE;
        }
        return this.persistenceType;
    }

    public Set getPersistentFields() {
        if (this.persistentFields == null) {
            this.persistentFields = new HashSet();
        }
        return this.persistentFields;
    }

    public String getPrimaryKeyClassName() {
        if (this.primaryKeyClassName == null) {
            this.primaryKeyClassName = (class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = EjbEntityDescriptor.class$("java.lang.Object"))).getName();
        }
        return this.primaryKeyClassName;
    }

    public FieldDescriptor getPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public ResourceReferenceDescriptor getResourceReference() {
        return this.resourceReference;
    }

    public String getSqlStatementFor(MethodDescriptor methodDescriptor) {
        Object statement = this.getMethodSqlMap().get(methodDescriptor);
        if (statement == null) {
            statement = "";
        }
        return (String)statement;
    }

    public String getSqlStatementFor(Method method) {
        return this.getSqlStatementFor(new MethodDescriptor(method, this, ((EjbBundleArchivist)this.getEjbBundleDescriptor().getArchivist()).getClassLoader()));
    }

    public Set getSqlStatementedMethods() {
        return this.getMethodSqlMap().keySet();
    }

    public String getTableCreateSqlStatement() {
        if (this.tableCreateSqlStatement == null) {
            this.tableCreateSqlStatement = "";
        }
        return this.tableCreateSqlStatement;
    }

    public String getTableRemoveSqlStatement() {
        if (this.tableRemoveSqlStatement == null) {
            this.tableRemoveSqlStatement = "";
        }
        return this.tableRemoveSqlStatement;
    }

    public String getTransactionType() {
        if (this.transactionType == null) {
            this.transactionType = EjbDescriptor.CONTAINER_TRANSACTION_TYPE;
        }
        return this.transactionType;
    }

    public String getType() {
        return TYPE;
    }

    public boolean hasCMPData() {
        if (this.methodSqlMap.size() != this.allSqlStatementedMethods.size()) {
            return false;
        }
        return !this.getTableCreateSqlStatement().equals("") && !this.getTableRemoveSqlStatement().equals("");
    }

    public boolean isPersistent(Field field) {
        return this.getPersistentFields().contains(new FieldDescriptor(field));
    }

    public boolean isReentrant() {
        return this.isReentrant;
    }

    public String isReentrantAsString() {
        if (this.isReentrant()) {
            return TRUE;
        }
        return FALSE;
    }

    public void setCreateTableOnDeployment(boolean createTableOnDeployment) {
        this.createTableOnDeployment = createTableOnDeployment;
        this.changed();
    }

    public void setDeleteTableOnUndeployment(boolean deleteTableOnUndeployment) {
        this.deleteTableOnUndeployment = deleteTableOnUndeployment;
        this.changed();
    }

    public void setPersistenceType(String persistenceType) {
        boolean isValidChange;
        boolean bl2 = isValidChange = BEAN_PERSISTENCE.equals(persistenceType) || CONTAINER_PERSISTENCE.equals(persistenceType);
        if (isValidChange || !Descriptor.isBoundsChecking()) {
            if (this.getPersistenceType().equals(CONTAINER_PERSISTENCE) && persistenceType.equals(BEAN_PERSISTENCE)) {
                this.getPersistentFields().clear();
            }
        } else {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionpersistenceisnotallowedtype", "{0} is not an allowed persistence type", new Object[]{persistenceType}));
        }
        this.persistenceType = persistenceType;
        super.changed();
    }

    public void setPersistentFields(Set persistentFields) {
        boolean isInvalidChange;
        boolean bl2 = isInvalidChange = this.getPersistenceType().equals(BEAN_PERSISTENCE) && persistentFields != null && !persistentFields.isEmpty();
        if (isInvalidChange && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannothavepersistentfieldsonbeanwithbmp", "Cannot have persistent fields {0} on a bean with bean managed persistence", new Object[]{persistentFields}));
        }
        this.persistentFields = persistentFields;
        super.changed();
    }

    public void setPrimaryKeyClassName(String primaryKeyClassName) {
        this.primaryKeyClassName = primaryKeyClassName;
        super.changed();
    }

    public void setPrimaryKeyField(FieldDescriptor primaryKeyField) {
        if (Descriptor.isBoundsChecking() && this.getPersistenceType().equals(BEAN_PERSISTENCE) && primaryKeyField != null) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionentitybeanwithbmpcannothaveprimaryfield", "Entity beans with bean persistence cannot have a primary key field"));
        }
        this.primaryKeyField = primaryKeyField;
        this.changed();
    }

    public void setReentrant(String reentrantString) {
        if (TRUE.equals(reentrantString)) {
            this.setReentrant(true);
            return;
        }
        if (FALSE.equals(reentrantString)) {
            this.setReentrant(false);
            return;
        }
        if (Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionstringnotlegalvalue", "{0} is not a legal value for entity reentrancy", new Object[]{reentrantString}));
        }
    }

    public void setReentrant(boolean isReentrant) {
        this.isReentrant = isReentrant;
        super.changed();
    }

    public void setResourceReference(ResourceReferenceDescriptor resourceReference) {
        this.resourceReference = resourceReference;
        this.changed();
    }

    public void setSqlStatementFor(MethodDescriptor methodDescriptor, String sqlStatement) {
        this.getMethodSqlMap().put(methodDescriptor, sqlStatement);
        this.changed();
    }

    public void setTableCreateSqlStatement(String tableCreateSqlStatement) {
        this.tableCreateSqlStatement = tableCreateSqlStatement;
        this.changed();
    }

    public void setTableRemoveSqlStatement(String tableRemoveSqlStatement) {
        this.tableRemoveSqlStatement = tableRemoveSqlStatement;
        this.changed();
    }

    public void setTransactionType(String transactionType) {
        if (!EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType) && Descriptor.isBoundsChecking()) {
            throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionentitybeancanonlyhavecntnrtxtype", "Entity beans can only have Container transaction type. The type was being set to {0}", new Object[]{transactionType}));
        }
        this.transactionType = transactionType;
    }

    public void setType(String type) {
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptioncannotsettypeonentitybean", "Cannon set type on an entity bean"));
    }

    public String toString() {
        String s2 = super.toString();
        s2 = String.valueOf(s2) + "\n Entity descriptor";
        s2 = String.valueOf(s2) + "\n persistentFields " + this.persistentFields;
        s2 = String.valueOf(s2) + "\n isReentrant " + this.isReentrant;
        s2 = String.valueOf(s2) + "\n primaryKeyClassName " + this.primaryKeyClassName;
        s2 = String.valueOf(s2) + "\n primaryKeyField " + this.primaryKeyField;
        s2 = String.valueOf(s2) + "\n persistenceType " + this.persistenceType;
        s2 = String.valueOf(s2) + "\n resourceReference " + this.resourceReference;
        s2 = String.valueOf(s2) + "\n methodSqlMap " + this.methodSqlMap;
        s2 = String.valueOf(s2) + "\n tableCreateSqlStatement " + this.tableCreateSqlStatement;
        s2 = String.valueOf(s2) + "\n tableRemoveSqlStatement " + this.tableRemoveSqlStatement;
        return s2;
    }
}

