/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbExternalDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.DescriptorNodeUtils;
import com.sun.enterprise.deployment.xml.EjbNode;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.util.DescriptorGenerator;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class EjbBundleNode
extends ElementNode {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static String SYSTEM_ID = "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$EjbBundleNode;

    public EjbBundleNode() {
        this.setTag("ejb-jar");
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public EjbBundleDescriptor getDescriptor() throws ContentTransformationException {
        ElementNode currentNode = this;
        try {
            Enumeration e10;
            EjbBundleDescriptor ejbBundleDescriptor = new EjbBundleDescriptor();
            DescriptorNodeUtils.setDescriptorAttributes(this, ejbBundleDescriptor, DescriptorNodeUtils.EJB_STYLE);
            HashSet<EjbNode> ejbNodes = new HashSet<EjbNode>();
            Enumeration e11 = XMLUtils.getNodesUnder((Node)this, EjbNode.getTags());
            while (e11.hasMoreElements()) {
                EjbNode nextEjbNode = (EjbNode)e11.nextElement();
                ejbNodes.add(nextEjbNode);
                EjbDescriptor ejbDescriptor = nextEjbNode.getDescriptor();
                ejbBundleDescriptor.addEjb(ejbDescriptor);
            }
            if (XMLUtils.hasNodesUnder(this, "ejb-client-jar")) {
                ejbBundleDescriptor.setEjbClientJarUri(XMLUtils.getTextFor(this, "ejb-client-jar"));
            }
            if (XMLUtils.hasNodesUnder(this, "assembly-descriptor")) {
                Role role;
                ElementNode assemblyDescriptorNode = XMLUtils.getFirstNodeUnder(this, "assembly-descriptor");
                Enumeration e12 = XMLUtils.getNodesUnder((Node)assemblyDescriptorNode, "security-role");
                while (e12.hasMoreElements()) {
                    ElementNode nextRoleNode = (ElementNode)e12.nextElement();
                    currentNode = nextRoleNode;
                    String optionalDescription = "";
                    if (XMLUtils.hasNodesUnder(nextRoleNode, "description")) {
                        optionalDescription = XMLUtils.getTextFor(nextRoleNode, "description");
                    }
                    role = new Role(XMLUtils.getTextFor(nextRoleNode, "role-name"));
                    role.setDescription(optionalDescription);
                    ejbBundleDescriptor.addRole(role);
                }
                if (!ejbBundleDescriptor.areResourceReferencesValid()) {
                    throw new IllegalArgumentException("Incorrectly resolved role references");
                }
                Enumeration e13 = XMLUtils.getNodesUnder((Node)assemblyDescriptorNode, "method-permission");
                while (e13.hasMoreElements()) {
                    ElementNode methodPermissionNode = (ElementNode)e13.nextElement();
                    currentNode = methodPermissionNode;
                    role = new Role(XMLUtils.getTextFor(methodPermissionNode, "role-name"));
                    Enumeration ee2 = XMLUtils.getNodesUnder((Node)methodPermissionNode, "method");
                    while (ee2.hasMoreElements()) {
                        MethodDescriptorNode methodDescriptorNode = (MethodDescriptorNode)ee2.nextElement();
                        String ejbName = methodDescriptorNode.getEjbName();
                        EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(ejbName);
                        MethodDescriptor md = methodDescriptorNode.getDescriptor(ejbDescriptor);
                        ejbDescriptor.addPermissionedRoleFor(role, md);
                    }
                }
                Hashtable methodContainerTransactions = new Hashtable();
                e10 = XMLUtils.getNodesUnder((Node)assemblyDescriptorNode, "container-transaction");
                while (e10.hasMoreElements()) {
                    ElementNode containerTransactionNode = (ElementNode)e10.nextElement();
                    currentNode = containerTransactionNode;
                    String optionalDescription = "";
                    if (XMLUtils.hasNodesUnder(containerTransactionNode, "description")) {
                        optionalDescription = XMLUtils.getTextFor(containerTransactionNode, "description");
                    }
                    Enumeration mdns = XMLUtils.getNodesUnder((Node)containerTransactionNode, "method");
                    while (mdns.hasMoreElements()) {
                        MethodDescriptorNode methodDescriptorNode = (MethodDescriptorNode)mdns.nextElement();
                        String methodNameSymbol = XMLUtils.getTextFor(methodDescriptorNode, "method-name");
                        String ejbName = methodDescriptorNode.getEjbName();
                        EjbDescriptor ejbDescriptor = ejbBundleDescriptor.getEjbByName(ejbName);
                        MethodDescriptor md = methodDescriptorNode.getDescriptor(ejbDescriptor);
                        ContainerTransaction containerTransaction = new ContainerTransaction(XMLUtils.getTextFor(containerTransactionNode, "trans-attribute"), optionalDescription);
                        ejbDescriptor.getMethodContainerTransactions().put(md, containerTransaction);
                    }
                }
            }
            Iterator itr = ejbNodes.iterator();
            while (itr.hasNext()) {
                EjbNode nextEjbNode = (EjbNode)itr.next();
                String nameOfReferingBean = XMLUtils.getTextFor(nextEjbNode, "ejb-name");
                EjbDescriptor referingBean = ejbBundleDescriptor.getEjbByName(nameOfReferingBean);
                e10 = XMLUtils.getNodesUnder((Node)nextEjbNode, "ejb-ref");
                while (e10.hasMoreElements()) {
                    EjbReferenceDescriptor ejbRef;
                    EjbExternalDescriptor ejbExternalDescriptor;
                    ElementNode ejbReferenceNode = (ElementNode)e10.nextElement();
                    currentNode = ejbReferenceNode;
                    String description = "";
                    if (XMLUtils.getFirstNodeUnder(ejbReferenceNode, "description") != null) {
                        description = XMLUtils.getTextFor(ejbReferenceNode, "description");
                    }
                    String ejbReferenceName = XMLUtils.getTextFor(ejbReferenceNode, "ejb-ref-name");
                    String homeClassName = XMLUtils.getTextFor(ejbReferenceNode, "home");
                    String remoteClassName = XMLUtils.getTextFor(ejbReferenceNode, "remote");
                    String referenceType = XMLUtils.getTextFor(ejbReferenceNode, "ejb-ref-type");
                    if (XMLUtils.hasNodesUnder(ejbReferenceNode, "ejb-link")) {
                        String ejbRefereeName = XMLUtils.getTextFor(ejbReferenceNode, "ejb-link");
                        if (!ejbBundleDescriptor.hasEjbByName(ejbRefereeName)) {
                            ejbExternalDescriptor = new EjbExternalDescriptor(ejbRefereeName, homeClassName, remoteClassName, referenceType);
                            ejbExternalDescriptor.setLinkName(ejbRefereeName);
                            ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, ejbExternalDescriptor);
                            referingBean.addEjbReferenceDescriptor(ejbRef);
                            continue;
                        }
                        EjbDescriptor refereeBean = ejbBundleDescriptor.getEjbByName(ejbRefereeName);
                        DescriptorNodeUtils.checkEjbReference(refereeBean, referenceType, homeClassName, remoteClassName, ejbRefereeName);
                        ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, refereeBean);
                        referingBean.addEjbReferenceDescriptor(new EjbReferenceDescriptor(ejbReferenceName, description, refereeBean));
                        continue;
                    }
                    String uniqueName = Descriptor.createUniqueNameAmongstNamedDescriptors("ExternalRef", referingBean.getEjbReferenceDescriptors());
                    ejbExternalDescriptor = new EjbExternalDescriptor(uniqueName, homeClassName, remoteClassName, referenceType);
                    ejbRef = new EjbReferenceDescriptor(ejbReferenceName, description, ejbExternalDescriptor);
                    referingBean.addEjbReferenceDescriptor(ejbRef);
                }
            }
            return ejbBundleDescriptor;
        }
        catch (IllegalArgumentException iae) {
            throw new ContentTransformationException(iae.getMessage(), currentNode.toString());
        }
    }

    public static XmlDocument getDocument(EjbBundleDescriptor ejbBundleDescriptor) {
        XmlDocument xmlDocument = new XmlDocument();
        xmlDocument.setDoctype(PUBLIC_DTD_ID, SYSTEM_ID, null);
        EjbBundleNode n2 = new EjbBundleNode();
        xmlDocument.appendChild(n2);
        n2.setDescriptor(ejbBundleDescriptor);
        return xmlDocument;
    }

    public static void main(String[] args) {
        try {
            EjbBundleNode.write();
            EjbBundleNode.read();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    private static void read() throws Exception {
        Vector ejbBundleNodes = EjbBundleNode.readEjbBundleNodes(new FileInputStream(new File("ejbBundle.xml")));
        EjbBundleNode n2 = (EjbBundleNode)ejbBundleNodes.elementAt(0);
        System.out.println(n2.getDescriptor());
    }

    public static EjbBundleNode read(InputStream is) throws ParseException {
        Vector ejbBundleNodes = EjbBundleNode.readEjbBundleNodes(is);
        if (ejbBundleNodes.size() > 0) {
            return (EjbBundleNode)ejbBundleNodes.elementAt(0);
        }
        throw new ParseException("No Ejb bundle nodes could be found");
    }

    public static Vector readEjbBundleNodes(InputStream is) throws ParseException {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put("ejb-jar", "com.sun.enterprise.deployment.xml.EjbBundleNode");
            nodeToClass.put("session", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put("entity", "com.sun.enterprise.deployment.xml.EjbNode");
            nodeToClass.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$EjbBundleNode != null ? class$com$sun$enterprise$deployment$xml$EjbBundleNode : (class$com$sun$enterprise$deployment$xml$EjbBundleNode = EjbBundleNode.class$("com.sun.enterprise.deployment.xml.EjbBundleNode")), nodeToClass, is);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new ParseException(se);
        }
        catch (Throwable t2) {
            throw new ParseException(t2.getMessage());
        }
    }

    public void setDescriptor(EjbBundleDescriptor bundleDescriptor) {
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(this.getOwnerDocument());
        DescriptorNodeUtils.appendDescriptorAttributes(factory, bundleDescriptor, this, DescriptorNodeUtils.EJB_STYLE);
        ElementNode ejbsNode = factory.getNode("enterprise-beans");
        this.appendChild(ejbsNode);
        Iterator itr = bundleDescriptor.getEjbs().iterator();
        while (itr.hasNext()) {
            EjbDescriptor nextEjbDescriptor = (EjbDescriptor)itr.next();
            EjbNode ejbNode = new EjbNode();
            ejbsNode.appendChild(ejbNode);
            ejbNode.setDescriptor(nextEjbDescriptor);
        }
        if (bundleDescriptor.hasAssemblyInformation()) {
            Enumeration e10;
            ElementNode assemblyDescriptorNode = factory.getNode("assembly-descriptor");
            this.appendChild(assemblyDescriptorNode);
            Iterator itr2 = bundleDescriptor.getRoles().iterator();
            while (itr2.hasNext()) {
                Role nextRole = (Role)itr2.next();
                ElementNode roleNode = factory.getNode("security-role");
                assemblyDescriptorNode.appendChild(roleNode);
                if (!nextRole.getDescription().equals("")) {
                    roleNode.appendChild(factory.getTextNode("description", nextRole.getDescription()));
                }
                roleNode.appendChild(factory.getTextNode("role-name", nextRole.getName()));
            }
            Iterator itr3 = bundleDescriptor.getEjbs().iterator();
            while (itr3.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)itr3.next();
                Hashtable permissionedMethodsByRole = ejbDescriptor.getPermissionedMethodsByRole();
                e10 = permissionedMethodsByRole.keys();
                while (e10.hasMoreElements()) {
                    Role nextRole = (Role)e10.nextElement();
                    Set permissionedMethods = (Set)permissionedMethodsByRole.get(nextRole);
                    if (permissionedMethods.isEmpty()) continue;
                    ElementNode methodPermissionNode = factory.getNode("method-permission");
                    assemblyDescriptorNode.appendChild(methodPermissionNode);
                    methodPermissionNode.appendChild(factory.getTextNode("role-name", nextRole.getName()));
                    Iterator pmbr = permissionedMethods.iterator();
                    while (pmbr.hasNext()) {
                        MethodDescriptor nextMethodDescriptor = (MethodDescriptor)pmbr.next();
                        MethodDescriptorNode methodDescriptorNode = new MethodDescriptorNode();
                        methodPermissionNode.appendChild(methodDescriptorNode);
                        methodDescriptorNode.setDescriptor(nextMethodDescriptor, ejbDescriptor);
                    }
                }
            }
            Iterator ejbs = bundleDescriptor.getEjbs().iterator();
            while (ejbs.hasNext()) {
                EjbDescriptor ejbDescriptor = (EjbDescriptor)ejbs.next();
                if (ejbDescriptor.getMethodContainerTransactions().isEmpty()) continue;
                e10 = ejbDescriptor.getMethodContainerTransactions().keys();
                while (e10.hasMoreElements()) {
                    MethodDescriptor nextMethodDescriptor = (MethodDescriptor)e10.nextElement();
                    ContainerTransaction methodContainerTransaction = (ContainerTransaction)ejbDescriptor.getMethodContainerTransactions().get(nextMethodDescriptor);
                    ElementNode containerTransactionNode = factory.getNode("container-transaction");
                    assemblyDescriptorNode.appendChild(containerTransactionNode);
                    if (!methodContainerTransaction.getDescription().equals("")) {
                        containerTransactionNode.appendChild(factory.getTextNode("description", methodContainerTransaction.getDescription()));
                    }
                    MethodDescriptorNode methodDescriptorNode = new MethodDescriptorNode();
                    containerTransactionNode.appendChild(methodDescriptorNode);
                    methodDescriptorNode.setDescriptor(nextMethodDescriptor, ejbDescriptor);
                    containerTransactionNode.appendChild(factory.getTextNode("trans-attribute", methodContainerTransaction.getTransactionAttribute()));
                }
            }
        }
        if (!"".equals(bundleDescriptor.getEjbClientJarUri())) {
            this.appendChild(factory.getTextNode("ejb-client-jar", bundleDescriptor.getEjbClientJarUri()));
        }
    }

    private static void write() throws Throwable {
        StringWriter sw = new StringWriter();
        XmlDocument document = EjbBundleNode.getDocument(DescriptorGenerator.getDefaultEjbBundleDescriptor());
        XMLUtils.writeDocumentToFile(document, new File("ejbBundle.xml"));
        XMLUtils.writeDocument(document, sw);
        System.out.println("*******************************");
        System.out.println(sw.toString());
        System.out.println("*******************************");
    }
}

