/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.xml;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.xml.ContentTransformationException;
import com.sun.enterprise.deployment.xml.MethodDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Group;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.util.DescriptorGenerator;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.XmlDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Node;

public class RuntimeDescriptorNode
extends ElementNode {
    public static String PUBLIC_DTD_ID = "-//Sun Microsystems Inc.//DTD J2EE Reference Implementation 1.0//EN";
    public static String RUNTIME_TAG = "j2ee-ri-specific-information";
    private static String ROLEMAPPING = "rolemapping";
    private static String ROLE_ENTRY = "role";
    private static String GROUPS = "groups";
    private static String GROUP = "group";
    private static String JNDI_NAME = "jndi-name";
    private static String EJBS = "enterprise-beans";
    private static String EJB = "ejb";
    private static String EJB_NAME = "ejb-name";
    private static String RESOURCE_PRINCIPAL_MAP = "resource-principal-mapping";
    private static String RESOURCE_PRINCIPAL = "resource-principal";
    private static String DEFAULT_RESOURCE_PRINCIPAL = "default-resource-principal";
    private static String PASSWORD = "password";
    private static String PRINCIPALS = "principals";
    private static String PRINCIPAL = "principal";
    private static String NAME = "name";
    private static String APPLICATION_CLIENT = "app-client";
    private static String SERVER_NAME = "server-name";
    private static String CMP = "cmp";
    private static String DATA_SOURCE_JNDI_NAME = "ds-jndi-name";
    private static String SQL_STATEMENT = "sql-statement";
    private static String SQL = "sql";
    private static String TABLE_CREATE = "table-create-sql";
    private static String TABLE_REMOVE = "table-remove-sql";
    private static String CREATE_TABLE_DEPLOY = "create-table-deploy";
    private static String DELETE_TABLE_UNDEPLOY = "delete-table-undeploy";
    private static String MAIL_CONFIG = "mail-configuration";
    private static String MAIL_FROM = "mail-from";
    private static String MAIL_HOST = "mail-host";
    static /* synthetic */ Class class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode;

    public RuntimeDescriptorNode() {
        this.setTag(RUNTIME_TAG);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static XmlDocument getDocument(Application application) {
        XmlDocument document = new XmlDocument();
        RuntimeDescriptorNode rdn = new RuntimeDescriptorNode();
        document.appendChild(rdn);
        rdn.setDescriptor(application);
        return document;
    }

    static ElementNode getResourceReferenceNodeFor(ResourceReferenceDescriptor resourceReference, XMLUtils factory) {
        ElementNode resourceReferenceNode = factory.getNode("resource-ref");
        resourceReferenceNode.appendChild(factory.getTextNode("res-ref-name", resourceReference.getName()));
        resourceReferenceNode.appendChild(factory.getTextNode(JNDI_NAME, resourceReference.getJndiName()));
        if (resourceReference.getResourcePrincipal() != null) {
            ElementNode defaultResourcePrincipalNode = factory.getNode(DEFAULT_RESOURCE_PRINCIPAL);
            resourceReferenceNode.appendChild(defaultResourcePrincipalNode);
            defaultResourcePrincipalNode.appendChild(factory.getTextNode(NAME, resourceReference.getResourcePrincipal().getName()));
            defaultResourcePrincipalNode.appendChild(factory.getTextNode(PASSWORD, resourceReference.getResourcePrincipal().getPassword()));
        }
        if (resourceReference.getMailConfiguration() != null) {
            ElementNode mailNode = factory.getNode(MAIL_CONFIG);
            resourceReferenceNode.appendChild(mailNode);
            mailNode.appendChild(factory.getTextNode(NAME, resourceReference.getMailConfiguration().getUsername()));
            mailNode.appendChild(factory.getTextNode(MAIL_FROM, resourceReference.getMailConfiguration().getMailFrom()));
            mailNode.appendChild(factory.getTextNode(MAIL_HOST, resourceReference.getMailConfiguration().getMailHost()));
        }
        return resourceReferenceNode;
    }

    public static void main(String[] args) {
        try {
            RuntimeDescriptorNode.write();
            RuntimeDescriptorNode.read();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
    }

    private static void read() throws Throwable {
        Vector runtimeDescriptorNodes = RuntimeDescriptorNode.readRuntimeDescriptorNodes(new FileInputStream(new File("rt.xml")));
        RuntimeDescriptorNode n2 = (RuntimeDescriptorNode)runtimeDescriptorNodes.elementAt(0);
        Application application = DescriptorGenerator.getDefaultApplication();
        n2.updateRuntimeInformation(application);
        System.out.println(application);
    }

    public static RuntimeDescriptorNode read(InputStream is) {
        Vector v2 = RuntimeDescriptorNode.readRuntimeDescriptorNodes(is);
        if (v2 == null) {
            return null;
        }
        RuntimeDescriptorNode n2 = (RuntimeDescriptorNode)v2.elementAt(0);
        return n2;
    }

    public static Vector readRuntimeDescriptorNodes(InputStream is) {
        try {
            Hashtable<String, String> nodeToClass = new Hashtable<String, String>();
            nodeToClass.put(RUNTIME_TAG, "com.sun.enterprise.deployment.xml.RuntimeDescriptorNode");
            nodeToClass.put(MethodDescriptorNode.METHOD_TAG, "com.sun.enterprise.deployment.xml.MethodDescriptorNode");
            return XMLUtils.getNodesByType(class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode != null ? class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode : (class$com$sun$enterprise$deployment$xml$RuntimeDescriptorNode = RuntimeDescriptorNode.class$("com.sun.enterprise.deployment.xml.RuntimeDescriptorNode")), nodeToClass, is);
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            return new Vector();
        }
    }

    public void setDescriptor(Application application) {
        if (this.getOwnerDocument() == null) {
            throw new IllegalArgumentException("Cannot set the descriptor unless this node has been added to a document");
        }
        XMLUtils factory = new XMLUtils(this.getOwnerDocument());
        this.appendChild(factory.getTextNode(SERVER_NAME, application.getServerName()));
        ElementNode principalsNode = null;
        Enumeration groups = null;
        ElementNode roleMappingNode = factory.getNode(ROLEMAPPING);
        this.appendChild(roleMappingNode);
        RoleMapper rm = application.getRoleMapper();
        if (rm != null) {
            Enumeration roles = rm.getRoles();
            while (roles.hasMoreElements()) {
                Role nextRole = (Role)roles.nextElement();
                ElementNode roleNode = factory.getNode(ROLE_ENTRY, "name", nextRole.getName());
                roleMappingNode.appendChild(roleNode);
                Enumeration principals = rm.getUsersAssignedTo(nextRole);
                if (principals.hasMoreElements()) {
                    principalsNode = factory.getNode(PRINCIPALS);
                    roleNode.appendChild(principalsNode);
                    while (principals.hasMoreElements()) {
                        Principal principal = (Principal)principals.nextElement();
                        ElementNode principalNode = factory.getNode(PRINCIPAL);
                        principalsNode.appendChild(principalNode);
                        principalNode.appendChild(factory.getTextNode(NAME, principal.getName()));
                    }
                }
                if (!(groups = rm.getGroupsAssignedTo(nextRole)).hasMoreElements()) continue;
                ElementNode groupsNode = factory.getNode(GROUPS);
                roleNode.appendChild(groupsNode);
                while (groups.hasMoreElements()) {
                    Group group = (Group)groups.nextElement();
                    groupsNode.appendChild(factory.getNode(GROUP, "name", group.getName()));
                }
            }
        }
        Iterator itr = application.getWebBundleDescriptors().iterator();
        while (itr.hasNext()) {
            WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
            ElementNode webNode = factory.getNode("web");
            this.appendChild(webNode);
            webNode.appendChild(factory.getTextNode("display-name", wbd.getName()));
            webNode.appendChild(factory.getTextNode("context-root", wbd.getContextRoot()));
            Iterator resourceReferences = wbd.getResourceReferenceDescriptors().iterator();
            while (resourceReferences.hasNext()) {
                ResourceReferenceDescriptor nextRR = (ResourceReferenceDescriptor)resourceReferences.next();
                ElementNode resourceReferenceNode = RuntimeDescriptorNode.getResourceReferenceNodeFor(nextRR, factory);
                webNode.appendChild(resourceReferenceNode);
            }
            Iterator ejbReferences = wbd.getEjbReferenceDescriptors().iterator();
            while (ejbReferences.hasNext()) {
                EjbReferenceDescriptor next = (EjbReferenceDescriptor)ejbReferences.next();
                ElementNode ejbReferenceNode = factory.getNode("ejb-ref");
                webNode.appendChild(ejbReferenceNode);
                ejbReferenceNode.appendChild(factory.getTextNode("ejb-ref-name", next.getName()));
                ejbReferenceNode.appendChild(factory.getTextNode(JNDI_NAME, next.getJndiName()));
            }
        }
        if (application.getEjbComponentCount() > 0) {
            ElementNode ejbsNode = factory.getNode(EJBS);
            this.appendChild(ejbsNode);
            Iterator ejbBundles = application.getEjbBundleDescriptors().iterator();
            while (ejbBundles.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)ejbBundles.next();
                Iterator itr2 = ejbBundleDescriptor.getEjbs().iterator();
                while (itr2.hasNext()) {
                    EjbDescriptor ejbDescriptor = (EjbDescriptor)itr2.next();
                    ElementNode ejbNode = factory.getNode(EJB);
                    ejbsNode.appendChild(ejbNode);
                    ejbNode.appendChild(factory.getTextNode(EJB_NAME, ejbDescriptor.getName()));
                    ElementNode jndiNameNode = factory.getTextNode(JNDI_NAME, ejbDescriptor.getJndiName());
                    ejbNode.appendChild(jndiNameNode);
                    Iterator resourceReferences = ejbDescriptor.getResourceReferenceDescriptors().iterator();
                    while (resourceReferences.hasNext()) {
                        ResourceReferenceDescriptor nextRR = (ResourceReferenceDescriptor)resourceReferences.next();
                        ElementNode resourceReferenceNode = RuntimeDescriptorNode.getResourceReferenceNodeFor(nextRR, factory);
                        ejbNode.appendChild(resourceReferenceNode);
                    }
                    Iterator ejbReferences = ejbDescriptor.getEjbReferenceDescriptors().iterator();
                    while (ejbReferences.hasNext()) {
                        EjbReferenceDescriptor next = (EjbReferenceDescriptor)ejbReferences.next();
                        ElementNode ejbReferenceNode = factory.getNode("ejb-ref");
                        ejbNode.appendChild(ejbReferenceNode);
                        ejbReferenceNode.appendChild(factory.getTextNode("ejb-ref-name", next.getName()));
                        ejbReferenceNode.appendChild(factory.getTextNode(JNDI_NAME, next.getJndiName()));
                    }
                    if (!(ejbDescriptor instanceof EjbEntityDescriptor)) continue;
                    EjbEntityDescriptor entity = (EjbEntityDescriptor)ejbDescriptor;
                    ElementNode cmpNode = factory.getNode(CMP);
                    ejbNode.appendChild(cmpNode);
                    if (entity.getResourceReference() != null) {
                        cmpNode.appendChild(factory.getTextNode(DATA_SOURCE_JNDI_NAME, entity.getResourceReference().getJndiName()));
                        if (entity.getResourceReference().getResourcePrincipal() != null) {
                            ResourcePrincipal rp = entity.getResourceReference().getResourcePrincipal();
                            ElementNode defaultUserNode = factory.getNode(DEFAULT_RESOURCE_PRINCIPAL);
                            cmpNode.appendChild(defaultUserNode);
                            defaultUserNode.appendChild(factory.getTextNode(NAME, rp.getName()));
                            defaultUserNode.appendChild(factory.getTextNode(PASSWORD, rp.getPassword()));
                        }
                    }
                    Iterator methods = entity.getSqlStatementedMethods().iterator();
                    while (methods.hasNext()) {
                        MethodDescriptor nextMd = (MethodDescriptor)methods.next();
                        ElementNode sqlStatementNode = factory.getNode(SQL_STATEMENT);
                        cmpNode.appendChild(sqlStatementNode);
                        MethodDescriptorNode methodNode = new MethodDescriptorNode();
                        sqlStatementNode.appendChild(methodNode);
                        methodNode.setDescriptor(nextMd, entity);
                        sqlStatementNode.appendChild(factory.getTextNode(SQL, entity.getSqlStatementFor(nextMd)));
                    }
                    cmpNode.appendChild(factory.getTextNode(TABLE_CREATE, entity.getTableCreateSqlStatement()));
                    cmpNode.appendChild(factory.getTextNode(TABLE_REMOVE, entity.getTableRemoveSqlStatement()));
                    cmpNode.appendChild(factory.getTextNode(CREATE_TABLE_DEPLOY, new Boolean(entity.getCreateTableOnDeployment()).toString()));
                    cmpNode.appendChild(factory.getTextNode(DELETE_TABLE_UNDEPLOY, new Boolean(entity.getDeleteTableOnUndeployment()).toString()));
                }
            }
        }
    }

    static void updateResourceReference(ResourceReferenceDescriptor resourceReference, ElementNode rrNode) {
        ElementNode mailNode;
        resourceReference.setJndiName(XMLUtils.getTextFor(rrNode, JNDI_NAME));
        ElementNode defaultResourcePrincipalNode = XMLUtils.getFirstNodeUnder(rrNode, DEFAULT_RESOURCE_PRINCIPAL);
        if (defaultResourcePrincipalNode != null) {
            String name = XMLUtils.getTextFor(defaultResourcePrincipalNode, NAME);
            String password = XMLUtils.getTextFor(defaultResourcePrincipalNode, PASSWORD);
            ResourcePrincipal defaultResourcePrincipal = new ResourcePrincipal(name, password);
            resourceReference.setResourcePrincipal(defaultResourcePrincipal);
        }
        if ((mailNode = XMLUtils.getFirstNodeUnder(rrNode, MAIL_CONFIG)) != null) {
            MailConfiguration mc = new MailConfiguration(XMLUtils.getTextFor(mailNode, NAME), XMLUtils.getTextFor(mailNode, MAIL_FROM), XMLUtils.getTextFor(mailNode, MAIL_HOST));
            resourceReference.setMailConfiguration(mc);
        }
    }

    public void updateRuntimeInformation(Application application) throws ContentTransformationException {
        try {
            application.setServerName(XMLUtils.getTextFor(this, SERVER_NAME));
            RoleMapper rm = application.getRoleMapper();
            ElementNode roleMappingNode = XMLUtils.getFirstNodeUnder(this, ROLEMAPPING);
            Enumeration roleNodes = XMLUtils.getNodesUnder((Node)roleMappingNode, ROLE_ENTRY);
            while (roleNodes.hasMoreElements()) {
                ElementNode roleNode = (ElementNode)roleNodes.nextElement();
                String roleName = XMLUtils.getValueOf(roleNode, ROLE_ENTRY, "name");
                Role role = new Role(roleName);
                Enumeration principals = XMLUtils.getNodesUnder((Node)roleNode, PRINCIPAL);
                while (principals.hasMoreElements()) {
                    ElementNode principalNode = (ElementNode)principals.nextElement();
                    String principalName = XMLUtils.getTextFor(principalNode, NAME);
                    PrincipalImpl principal = new PrincipalImpl(principalName);
                    rm.assignRole(principal, role);
                }
                Enumeration groups = XMLUtils.getNodesUnder((Node)roleNode, GROUP);
                while (groups.hasMoreElements()) {
                    ElementNode groupNode = (ElementNode)groups.nextElement();
                    String groupName = XMLUtils.getValueOf(groupNode, GROUP, "name");
                    Group groupG = new Group(groupName);
                    rm.assignRole(groupG, role);
                }
            }
            Enumeration e10 = XMLUtils.getNodesUnder((Node)this, "web");
            while (e10.hasMoreElements()) {
                ElementNode webNode = (ElementNode)e10.nextElement();
                WebBundleDescriptor wbd = application.getWebBundleDescriptorByName(XMLUtils.getTextFor(webNode, "display-name"));
                String contextRoot = XMLUtils.getTextFor(webNode, "context-root");
                if ("".equals(wbd.getContextRoot())) {
                    wbd.setContextRoot(contextRoot);
                }
                Enumeration rrNodes = XMLUtils.getNodesUnder((Node)webNode, "resource-ref");
                while (rrNodes.hasMoreElements()) {
                    ElementNode rrNode = (ElementNode)rrNodes.nextElement();
                    String resourceReferenceName = XMLUtils.getTextFor(rrNode, "res-ref-name");
                    ResourceReferenceDescriptor resourceReference = wbd.getResourceReferenceByName(resourceReferenceName);
                    RuntimeDescriptorNode.updateResourceReference(resourceReference, rrNode);
                }
                Enumeration erNodes = XMLUtils.getNodesUnder((Node)webNode, "ejb-ref");
                while (erNodes.hasMoreElements()) {
                    ElementNode erNode = (ElementNode)erNodes.nextElement();
                    String ejbReferenceName = XMLUtils.getTextFor(erNode, "ejb-ref-name");
                    EjbReferenceDescriptor er2 = wbd.getEjbReferenceByName(ejbReferenceName);
                    er2.setJndiName(XMLUtils.getTextFor(erNode, JNDI_NAME));
                }
            }
            ElementNode ejbsNode = XMLUtils.getFirstNodeUnder(this, EJBS);
            if (ejbsNode != null) {
                Enumeration e11 = XMLUtils.getNodesUnder((Node)ejbsNode, EJB);
                while (e11.hasMoreElements()) {
                    ElementNode ejbNode = (ElementNode)e11.nextElement();
                    String ejbName = XMLUtils.getTextFor(ejbNode, EJB_NAME);
                    EjbDescriptor ejbDescriptor = application.getEjbByName(ejbName);
                    ejbDescriptor.setJndiName(XMLUtils.getTextFor(ejbNode, JNDI_NAME));
                    Enumeration rrNodes = XMLUtils.getNodesUnder((Node)ejbNode, "resource-ref");
                    while (rrNodes.hasMoreElements()) {
                        ElementNode rrNode = (ElementNode)rrNodes.nextElement();
                        String resourceReferenceName = XMLUtils.getTextFor(rrNode, "res-ref-name");
                        ResourceReferenceDescriptor resourceReference = ejbDescriptor.getResourceReferenceByName(resourceReferenceName);
                        RuntimeDescriptorNode.updateResourceReference(resourceReference, rrNode);
                    }
                    Enumeration erNodes = XMLUtils.getNodesUnder((Node)ejbNode, "ejb-ref");
                    while (erNodes.hasMoreElements()) {
                        ElementNode erNode = (ElementNode)erNodes.nextElement();
                        String ejbReferenceName = XMLUtils.getTextFor(erNode, "ejb-ref-name");
                        EjbReferenceDescriptor er3 = ejbDescriptor.getEjbReferenceByName(ejbReferenceName);
                        if ("".equals(XMLUtils.getTextFor(erNode, JNDI_NAME))) continue;
                        er3.setJndiName(XMLUtils.getTextFor(erNode, JNDI_NAME));
                    }
                    ElementNode cmpNode = XMLUtils.getFirstNodeUnder(ejbNode, CMP);
                    if (cmpNode == null) continue;
                    EjbEntityDescriptor entity = (EjbEntityDescriptor)ejbDescriptor;
                    if (XMLUtils.getFirstNodeUnder(cmpNode, DATA_SOURCE_JNDI_NAME) != null && XMLUtils.getFirstNodeUnder(cmpNode, DEFAULT_RESOURCE_PRINCIPAL) != null) {
                        ResourceReferenceDescriptor rrd = new ResourceReferenceDescriptor();
                        String jndiName = XMLUtils.getTextFor(cmpNode, DATA_SOURCE_JNDI_NAME);
                        rrd.setJndiName(jndiName);
                        ElementNode defaultUserNode = XMLUtils.getFirstNodeUnder(cmpNode, DEFAULT_RESOURCE_PRINCIPAL);
                        ResourcePrincipal rp = new ResourcePrincipal(XMLUtils.getTextFor(defaultUserNode, NAME), XMLUtils.getTextFor(defaultUserNode, PASSWORD));
                        rrd.setResourcePrincipal(rp);
                        entity.setResourceReference(rrd);
                    }
                    Enumeration sqlStatements = XMLUtils.getNodesUnder((Node)cmpNode, SQL_STATEMENT);
                    while (sqlStatements.hasMoreElements()) {
                        ElementNode sqlStatementNode = (ElementNode)sqlStatements.nextElement();
                        String sql = XMLUtils.getTextFor(sqlStatementNode, SQL);
                        MethodDescriptorNode methodNode = (MethodDescriptorNode)XMLUtils.getFirstNodeUnder(sqlStatementNode, MethodDescriptorNode.METHOD_TAG);
                        MethodDescriptor method = methodNode.getDescriptor(entity);
                        entity.setSqlStatementFor(method, sql);
                    }
                    entity.setTableCreateSqlStatement(XMLUtils.getTextFor(cmpNode, TABLE_CREATE));
                    entity.setTableRemoveSqlStatement(XMLUtils.getTextFor(cmpNode, TABLE_REMOVE));
                    entity.setCreateTableOnDeployment(new Boolean(XMLUtils.getTextFor(cmpNode, CREATE_TABLE_DEPLOY)));
                    entity.setDeleteTableOnUndeployment(new Boolean(XMLUtils.getTextFor(cmpNode, DELETE_TABLE_UNDEPLOY)));
                }
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw new ContentTransformationException(iae.getMessage(), this.toString());
        }
    }

    private static void write() throws Throwable {
        XmlDocument document = RuntimeDescriptorNode.getDocument(DescriptorGenerator.getDefaultApplication());
        StringWriter sw = new StringWriter();
        XMLUtils.writeDocument(document, sw);
        System.out.println(sw);
        XMLUtils.writeDocumentToFile(document, new File("rt.xml"));
    }
}

