/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.log;

import com.sun.enterprise.log.FileLogWriter;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.log.LogWriter;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Properties;

public final class LogUtil {
    public static final boolean debug = false;
    public static final String WEB_LOG = "web";
    public static final String EJB_LOG = "ejb";
    private static final String LOG_DIRECTORY = "log.directory";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$log$LogUtil != null ? class$com$sun$enterprise$log$LogUtil : (class$com$sun$enterprise$log$LogUtil = LogUtil.class$("com.sun.enterprise.log.LogUtil")));
    private static Properties config;
    private static final String LOG_OUTPUT_FILE = "log.output.file";
    private static final String LOG_ERROR_FILE = "log.error.file";
    private static final String LOG_EVENT_FILE = "log.event.file";
    static /* synthetic */ Class class$com$sun$enterprise$log$LogUtil;

    static {
        try {
            config = new Properties();
            String propsFile = String.valueOf(System.getProperty("com.sun.enterprise.home")) + File.separator + "config" + File.separator + "default.properties";
            FileInputStream fis = new FileInputStream(propsFile);
            config.load(fis);
        }
        catch (Exception ex2) {
            System.err.println(localStrings.getLocalString("enterprise.log.error", "ERROR during Log initialization"));
            ex2.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static String getBaseLogDirName() {
        return FileUtil.getAbsolutePath(config.getProperty(LOG_DIRECTORY, "logs"));
    }

    private static LogWriter getLog(File dir, String logFileName) throws IOException {
        File logfile = new File(dir, logFileName);
        if (!logfile.exists()) {
            logfile.createNewFile();
        }
        return new FileLogWriter(logfile);
    }

    public static File getLogDirectory(String appName, String appType) {
        String logDirName = String.valueOf(LogUtil.getBaseLogDirName()) + File.separator + Utility.getLocalHost() + File.separator + appType + File.separator + appName + File.separator;
        File logDir = new File(logDirName);
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        return logDir;
    }

    static String getShutdownInfo() {
        return "\n\n" + localStrings.getLocalString("enterprise.log.logging.serverversion.stopped", "Logging for J2EE Server Version: {0} stopped at: {1}.", new Object[]{"1.2.1-q", new Date().toString()}) + "\n";
    }

    private static String getStartupInfo() {
        return "\n\n" + localStrings.getLocalString("enterprise.log.logging.serverversion.started", "Logging for J2EE Server Version: {0} started at: {1}", new Object[]{"1.2.1-q", new Date().toString()}) + "." + "\n" + localStrings.getLocalString("enterprise.log.using.vm.name.version.from", "Using the {0} and the version number {1} from {2} ", new Object[]{System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("java.vm.vendor")}) + "." + "\n" + localStrings.getLocalString("enterprise.log.vm's.classpath", "VM is using the classpath: {0}", new Object[]{System.getProperty("java.class.path")}) + "." + "\n" + localStrings.getLocalString("enterprise.log.j2ee.homedirectory", "J2EE Home Directory has been set to:  {0}", new Object[]{System.getProperty("com.sun.enterprise.home")}) + "." + "\n\n";
    }

    public static void initDefaultLogFiles(File dir) throws IOException {
        try {
            Log.setOutputLog(LogUtil.getLog(dir, config.getProperty(LOG_OUTPUT_FILE, "output.log")));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        try {
            Log.setEventLog(LogUtil.getLog(dir, config.getProperty(LOG_EVENT_FILE, "event.log")));
        }
        catch (FileNotFoundException fileNotFoundException) {}
        try {
            Log.setErrorLog(LogUtil.getLog(dir, config.getProperty(LOG_ERROR_FILE, "error.log")));
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static void printInfo(PrintStream pstream) {
        pstream.println(LogUtil.getStartupInfo());
        pstream.flush();
    }

    public static void printInfo(PrintWriter pwriter) {
        pwriter.println(LogUtil.getStartupInfo());
        pwriter.flush();
    }
}

