/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.certificate;

import com.sun.enterprise.security.auth.AuthenticationInfoImpl;
import com.sun.enterprise.security.auth.AuthenticationStatus;
import com.sun.enterprise.security.auth.AuthenticationStatusImpl;
import com.sun.enterprise.security.auth.Credentials;
import com.sun.enterprise.security.auth.CredentialsImpl;
import com.sun.enterprise.security.auth.Privilege;
import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateUser;

class CertificateAuthHandler
implements AuthenticationHandler {
    private CertificateRealm realm;

    public CertificateAuthHandler(CertificateRealm realm) throws IllegalArgumentException {
        this.realm = realm;
    }

    public AuthenticationStatus doAuthentication(Credentials creds, String principalName, byte[] authData) {
        int status = 1;
        AuthenticationInfoImpl ainfo = null;
        try {
            try {
                CertificateUser user = (CertificateUser)this.realm.getUser(principalName);
                byte[] cert = user.getCertificate().getEncoded();
                if (cert.length == authData.length) {
                    int i2 = 0;
                    while (i2 < authData.length) {
                        if (cert[i2] != authData[i2]) break;
                        ++i2;
                    }
                    if (i2 == authData.length) {
                        status = 0;
                        ainfo = new AuthenticationInfoImpl(user.getName(), this.realm.getName(), true);
                        ainfo.setAttribute("Groups", new Privilege[0]);
                    }
                }
            }
            catch (NoSuchUserException nsue) {
                System.out.println(nsue);
            }
            catch (Exception e10) {
                e10.printStackTrace(System.out);
            }
        }
        catch (Throwable throwable) {}
        AuthenticationStatusImpl as2 = new AuthenticationStatusImpl(principalName, this.realm.getName(), this.realm.getAuthType(), status);
        if (creds instanceof CredentialsImpl) {
            CredentialsImpl cimpl = (CredentialsImpl)creds;
            cimpl.setAuthenticationStatus(as2);
            if (ainfo != null) {
                cimpl.addAuthenticationInfo(ainfo);
            }
        }
        return as2;
    }

    public Realm getRealm() {
        return this.realm;
    }
}

