/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm.sharedpassword;

import com.sun.enterprise.security.auth.realm.AuthenticationHandler;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.User;
import com.sun.enterprise.security.auth.realm.sharedpassword.FilePassword;
import com.sun.enterprise.security.auth.realm.sharedpassword.FilePrivileges;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordAuthHandler;
import com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordUser;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public final class SharedPasswordRealm
extends Realm {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$auth$realm$sharedpassword$SharedPasswordRealm != null ? class$com$sun$enterprise$security$auth$realm$sharedpassword$SharedPasswordRealm : (class$com$sun$enterprise$security$auth$realm$sharedpassword$SharedPasswordRealm = SharedPasswordRealm.class$("com.sun.enterprise.security.auth.realm.sharedpassword.SharedPasswordRealm")));
    private static String PASSWORD_FILE_NAME = "keyfile";
    private static String PRIVILEGES_FILE_NAME = "privileges";
    private static String PASSWORD_DIR_PROP = "directory";
    private static String AUTH_TYPE = "password";
    private boolean initted = false;
    private FilePassword passwords;
    private FilePrivileges privileges;
    private AuthenticationHandler authHandler = new SharedPasswordAuthHandler(this);
    static /* synthetic */ Class class$com$sun$enterprise$security$auth$realm$sharedpassword$SharedPasswordRealm;

    public void addGroup(String groupName) throws BadRealmException {
        if (this.privileges == null) {
            throw new BadRealmException(localStrings.getLocalString("sharedpassword.not_supported", "Not Supported"));
        }
        this.privileges.set("Groups", groupName);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void createUser(String userName, String password, String[] groups) throws BadRealmException {
        FilePassword filePassword = this.passwords;
        synchronized (filePassword) {
            try {
                User u2 = this.getUser(userName);
                String message = localStrings.getLocalString("sharedpassword.duplicate_user", "There is already a user named {0}.", new Object[]{userName});
                throw new BadRealmException(message);
            }
            catch (NoSuchUserException noSuchUserException) {
                this.passwords.addUser(userName, password, groups);
            }
        }
    }

    public void deleteUser(String userName) throws BadRealmException, NoSuchUserException {
        FilePassword filePassword = this.passwords;
        synchronized (filePassword) {
            User u2 = this.getUser(userName);
            this.passwords.removeUser(userName);
        }
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    public Enumeration getGroupNames() throws BadRealmException {
        if (this.privileges != null) {
            String[] groups = this.privileges.get("Groups");
            Vector<String> v2 = new Vector<String>();
            int i2 = 0;
            while (i2 < groups.length) {
                v2.add(groups[i2]);
                ++i2;
            }
            return v2.elements();
        }
        throw new BadRealmException(localStrings.getLocalString("sharedpassword.not_supported", "Not Supported"));
    }

    FilePassword getPasswords() {
        return this.passwords;
    }

    FilePrivileges getPrivileges() {
        return this.privileges;
    }

    public User getUser(String name) throws NoSuchUserException {
        name = name.replace(' ', '_');
        return new SharedPasswordUser(this, name);
    }

    public Enumeration getUserNames() {
        return this.passwords.users();
    }

    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        if (!this.initted) {
            this.initted = true;
            super.init(props);
            String dirname = FileUtil.getAbsolutePath(props.getProperty(PASSWORD_DIR_PROP));
            this.passwords = new FilePassword(String.valueOf(dirname) + File.separator + PASSWORD_FILE_NAME);
            this.privileges = new FilePrivileges(String.valueOf(dirname) + File.separator + PRIVILEGES_FILE_NAME);
        }
    }

    public void refresh() throws BadRealmException {
        SharedPasswordRealm sharedPasswordRealm = this;
        synchronized (sharedPasswordRealm) {
            try {
                this.passwords.read();
                this.privileges.read();
            }
            catch (Exception e10) {
                throw new BadRealmException(e10.getMessage());
            }
        }
    }

    public void removeGroup(String groupName) throws BadRealmException {
        if (this.privileges == null) {
            throw new BadRealmException(localStrings.getLocalString("sharedpassword.not_supported", "Not Supported"));
        }
        this.privileges.remove("Groups", groupName);
    }
}

