/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.main;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Project;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ProjectImpl
extends Project {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$Project != null ? class$com$sun$enterprise$deployment$Project : (class$com$sun$enterprise$deployment$Project = ProjectImpl.class$("com.sun.enterprise.deployment.Project")));
    private static final boolean debug = false;
    private static final String EAR_SIZE_PROP = "EAR_SIZE";
    private Hashtable appOrigins = new Hashtable();
    private Application app;
    private String appName;
    private File originsFile;
    private File clientCodeFile;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Project;

    public ProjectImpl(Application app) {
        this.app = app;
        this.appName = app.getName();
        String filename = String.valueOf(System.getProperty("user.home")) + File.separator + ".j2eedeploymenttool" + File.separator + this.appName + ".proj";
        this.originsFile = new File(filename);
        this.appOrigins = new Hashtable();
    }

    public void addFiles(Archivist arch, Hashtable files) {
        if (arch instanceof ApplicationArchivist) {
            this.appOrigins.putAll(files);
        } else {
            String bundleUri = arch.getArchiveUri();
            Hashtable bundleTable = (Hashtable)this.appOrigins.get(bundleUri);
            if (bundleTable == null) {
                bundleTable = new Hashtable();
                this.appOrigins.put(bundleUri, bundleTable);
            }
            bundleTable.putAll(files);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public File getClientCodeFile() {
        return this.clientCodeFile;
    }

    public void load() {
        if (!this.originsFile.exists()) {
            return;
        }
        Properties origins = new Properties();
        try {
            FileInputStream fis = new FileInputStream(this.originsFile);
            origins.load(fis);
            fis.close();
        }
        catch (Exception exception) {
            return;
        }
        ApplicationArchivist archivist = this.app.getApplicationArchivist();
        Long earFileLength = new Long(archivist.getApplicationFile().length());
        String oldEarFileLengthStr = origins.getProperty(EAR_SIZE_PROP);
        if (oldEarFileLengthStr == null) {
            return;
        }
        Long oldEarFileLength = Long.decode(oldEarFileLengthStr);
        if (!earFileLength.equals(oldEarFileLength)) {
            this.originsFile.delete();
            return;
        }
        this.appOrigins = new Hashtable();
        String count = origins.getProperty("numArchives");
        if (count == null) {
            return;
        }
        int numArchives = Integer.parseInt(count);
        int i2 = 0;
        while (i2 < numArchives) {
            String arPrefix = "archive" + i2 + ".";
            String archive = origins.getProperty(String.valueOf(arPrefix) + "name");
            String numfiles = origins.getProperty(String.valueOf(arPrefix) + "numfiles");
            if (numfiles == null) {
                String arOrigin = origins.getProperty(String.valueOf(arPrefix) + "origin");
                File originFile = new File(arOrigin);
                if (arOrigin != null) {
                    this.appOrigins.put(archive, originFile);
                }
            } else {
                int numEntries = Integer.parseInt(numfiles);
                Hashtable<String, File> arOrigins = new Hashtable<String, File>();
                this.appOrigins.put(archive, arOrigins);
                int j2 = 0;
                while (j2 < numEntries) {
                    String entryPrefix = String.valueOf(arPrefix) + "entry" + j2 + ".";
                    String jarEntry = origins.getProperty(String.valueOf(entryPrefix) + "entry");
                    String origin = origins.getProperty(String.valueOf(entryPrefix) + "origin");
                    File originFile = new File(origin);
                    arOrigins.put(jarEntry, originFile);
                    ++j2;
                }
            }
            ++i2;
        }
    }

    public void remove() {
        this.appOrigins = null;
    }

    public void removeEntries(Archivist arch, Vector entries) {
        if (arch instanceof ApplicationArchivist) {
            int i2 = 0;
            while (i2 < entries.size()) {
                this.appOrigins.remove(entries.elementAt(i2));
                ++i2;
            }
        } else {
            String bundleUri = arch.getArchiveUri();
            Hashtable bundleTable = (Hashtable)this.appOrigins.get(bundleUri);
            if (bundleTable == null) {
                return;
            }
            int i3 = 0;
            while (i3 < entries.size()) {
                bundleTable.remove(entries.elementAt(i3));
                ++i3;
            }
        }
    }

    public void save() {
        Enumeration entries = this.appOrigins.keys();
        if (this.originsFile.exists()) {
            this.originsFile.delete();
        }
        Properties origins = new Properties();
        origins.setProperty("appName", this.appName);
        ApplicationArchivist archivist = this.app.getApplicationArchivist();
        File earFile = archivist.getApplicationFile();
        Long earFileLength = new Long(earFile.length());
        origins.setProperty(EAR_SIZE_PROP, earFileLength.toString());
        int nArchives = 0;
        while (entries.hasMoreElements()) {
            String entry = (String)entries.nextElement();
            Object arOrigins = this.appOrigins.get(entry);
            if (arOrigins == null) continue;
            String arPrefix = "archive" + nArchives + ".";
            origins.setProperty(String.valueOf(arPrefix) + "name", entry);
            if (arOrigins instanceof File) {
                origins.setProperty(String.valueOf(arPrefix) + "origin", ((File)arOrigins).getAbsolutePath());
            } else if (arOrigins instanceof Hashtable) {
                Hashtable jarOrigins = (Hashtable)arOrigins;
                origins.setProperty(String.valueOf(arPrefix) + "numfiles", String.valueOf(jarOrigins.size()));
                Enumeration jarEntries = jarOrigins.keys();
                int entrycount = 0;
                while (jarEntries.hasMoreElements()) {
                    String entryPrefix = String.valueOf(arPrefix) + "entry" + entrycount + ".";
                    String jarEntry = (String)jarEntries.nextElement();
                    String origin = ((File)jarOrigins.get(jarEntry)).getAbsolutePath();
                    origins.setProperty(String.valueOf(entryPrefix) + "entry", jarEntry);
                    origins.setProperty(String.valueOf(entryPrefix) + "origin", origin);
                    ++entrycount;
                }
            }
            ++nArchives;
        }
        origins.setProperty("numArchives", String.valueOf(nArchives));
        try {
            FileOutputStream fos = new FileOutputStream(this.originsFile);
            origins.store(fos, " File origins for application " + this.appName);
            fos.close();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public void setClientCodeFile(File ccf) {
        this.clientCodeFile = ccf;
    }

    public Vector updateApp() throws Exception {
        ZipEntry earEntry;
        if (this.appOrigins == null) {
            throw new RuntimeException(localStrings.getLocalString("enterprise.tools.deployment.main.noproject", "No project information for this application."));
        }
        String earFileName = this.app.getApplicationArchivist().getApplicationFile().getAbsolutePath();
        File earFile = new File(earFileName);
        ZipInputStream earStream = new ZipInputStream(new FileInputStream(earFile));
        Vector<String> changedEntries = new Vector<String>();
        Hashtable<String, File> updateEarEntries = new Hashtable<String, File>();
        Set archiveDescriptors = this.app.getArchivableDescriptors();
        while ((earEntry = earStream.getNextEntry()) != null) {
            ZipEntry jarEntry;
            Object arOrigin = this.appOrigins.get(earEntry.getName());
            if (arOrigin == null) continue;
            if (arOrigin instanceof File) {
                File originFile = (File)arOrigin;
                long zipTime = earEntry.getTime();
                if (zipTime <= 0L || originFile.lastModified() <= zipTime) continue;
                updateEarEntries.put(earEntry.getName(), originFile);
                changedEntries.add(earEntry.getName());
                continue;
            }
            if (!(arOrigin instanceof Hashtable)) continue;
            ZipInputStream zis = new ZipInputStream(earStream);
            Hashtable origins = (Hashtable)arOrigin;
            Hashtable<String, File> updateJarEntries = new Hashtable<String, File>();
            while ((jarEntry = zis.getNextEntry()) != null) {
                Object origin = origins.get(jarEntry.getName());
                if (origin == null) continue;
                File originFile = (File)origin;
                long zipTime = jarEntry.getTime();
                if (zipTime <= 0L || originFile.lastModified() <= zipTime) continue;
                updateJarEntries.put(jarEntry.getName(), originFile);
                changedEntries.add(String.valueOf(earEntry.getName()) + "!" + jarEntry.getName());
            }
            if (updateJarEntries.size() <= 0) continue;
            Archivist bundleArch = null;
            Iterator it = archiveDescriptors.iterator();
            while (it.hasNext()) {
                BundleDescriptor bd2 = (BundleDescriptor)it.next();
                bundleArch = bd2.getArchivist();
                if (bundleArch.getArchiveUri().equals(earEntry.getName())) break;
            }
            if (bundleArch == null) continue;
            bundleArch.updateFiles(updateJarEntries);
        }
        if (updateEarEntries.size() > 0) {
            ApplicationArchivist appArch = this.app.getApplicationArchivist();
            appArch.updateFiles(updateEarEntries);
        }
        if (earStream != null) {
            earStream.close();
        }
        return changedEntries;
    }
}

