/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.NamedReferencePair;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.tools.deployment.ui.Wand;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.help.CSH;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ApplicationJndiInspector
extends JPanel
implements Inspector,
TableInspector,
Wand {
    private static String helpSetMapID = "AIJNDI";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ApplicationJndiInspector != null ? class$com$sun$enterprise$tools$deployment$ui$ApplicationJndiInspector : (class$com$sun$enterprise$tools$deployment$ui$ApplicationJndiInspector = ApplicationJndiInspector.class$("com.sun.enterprise.tools.deployment.ui.ApplicationJndiInspector")));
    Application application;
    JPanel pnlWest = new JPanel();
    DefaultTableModel tableModel;
    InspectorTable table;
    JndiTableModel jndiTableModel;
    JndiTable jndiTable;
    JScrollPane scrlTable;
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ApplicationJndiInspector;

    public ApplicationJndiInspector() {
        try {
            this.initializeLayout();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public boolean canLeaveBackward() {
        this.editingStopped();
        return true;
    }

    public boolean canLeaveForward() {
        this.editingStopped();
        boolean canLeave = false;
        Set jndiComponents = this.application.getNamedDescriptors();
        Iterator itr = jndiComponents.iterator();
        while (itr.hasNext()) {
            NamedDescriptor namedComponent = (NamedDescriptor)itr.next();
            if (!"".equals(namedComponent.getJndiName())) continue;
            JOptionPane.showMessageDialog(this, String.valueOf(((Descriptor)((Object)namedComponent)).getName()) + " " + localStrings.getLocalString("jndinamesinspector.requires_jndi_name", "requires a JNDI name"));
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void editingStopped() {
        this.jndiTable.editingStopped(new ChangeEvent(this));
    }

    public Application getDescriptor() {
        return this.application;
    }

    private void initializeLayout() throws Exception {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        this.setLayout(this.borderLayout1);
        this.jndiTableModel = new JndiTableModel(this);
        this.jndiTable = new JndiTable(this.jndiTableModel);
        this.scrlTable = new JScrollPane(this.jndiTable);
        this.add((Component)this.scrlTable, "Center");
    }

    private void refresh() {
        this.jndiTableModel = new JndiTableModel(this);
        Enumeration jndiComponents = this.application.getNamedReferencePairs().elements();
        while (jndiComponents.hasMoreElements()) {
            NamedReferencePair jndiComponent = (NamedReferencePair)jndiComponents.nextElement();
            if (jndiComponent.getReferant().getName().equals(jndiComponent.getReferee().getName())) {
                this.jndiTableModel.addRow("", jndiComponent.getReferee().getName(), jndiComponent.getReferee().getJndiName());
                continue;
            }
            this.jndiTableModel.addRow(jndiComponent.getReferant().getName(), jndiComponent.getReferee().getName(), jndiComponent.getReferee().getJndiName());
        }
        this.jndiTable.setModel(this.jndiTableModel);
        this.jndiTable.setAutoResizeMode(4);
        this.jndiTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof Application) {
            this.application = (Application)object;
            this.refresh();
        }
    }

    private class JndiTable
    extends InspectorTable {
        int selectedRow = -1;

        public JndiTable(TableModel model) {
            super(model);
            this.setToolTipText(localStrings.getLocalString("applicationjndiinspector.jndi_tool_tip", "Table of jndi names"));
            this.setSelectionMode(0);
            ListSelectionModel rowSM = this.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ JndiTable this$1;
                {
                    this.this$1 = this$1;
                }

                public void valueChanged(ListSelectionEvent e10) {
                    ListSelectionModel lsm = (ListSelectionModel)e10.getSource();
                    if (!lsm.isSelectionEmpty()) {
                        JndiTable.access$0(this.this$1, lsm.getMinSelectionIndex());
                    } else {
                        JndiTable.access$0(this.this$1, -1);
                    }
                }
            });
        }

        static /* synthetic */ void access$0(JndiTable $0, int $1) {
            $0.setSelectedRow($1);
        }

        private void setSelectedRow(int index) {
            Integer oldIndex = new Integer(this.selectedRow);
            this.selectedRow = index;
        }

        void setupColNameColumn() {
            TableColumn colNameColumn = this.getColumnModel().getColumn(1);
            JTextField colNameText = new JTextField();
            colNameColumn.setCellEditor(new DefaultCellEditor(colNameText));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("applicationjndiinspector.col_tool_tip", "Click to edit text"));
            colNameColumn.setCellRenderer(renderer);
        }

        void setupTypeColumn() {
            TableColumn typeColumn = this.getColumnModel().getColumn(2);
            JComboBox typeComboBox = new JComboBox();
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("applicationjndiinspector.type_tool_tip", "Click to edit text"));
            typeColumn.setCellRenderer(renderer);
        }
    }

    public class JndiTableModel
    extends AbstractTableModel {
        ArrayList fields = new ArrayList();
        ApplicationJndiInspector inspector;
        String[] columnNames = new String[]{ApplicationJndiInspector.access$0().getLocalString("applicationjndiinspector.col_name_referenced_by", "Referenced By"), ApplicationJndiInspector.access$0().getLocalString("applicationjndiinspector.col_name_name", "Component/Reference Name"), ApplicationJndiInspector.access$0().getLocalString("applicationjndiinspector.col_name_jndi", "JNDI Name")};

        public JndiTableModel(ApplicationJndiInspector inspector) {
            this.inspector = inspector;
        }

        public void addRow(String referrer, String componentName, String jndiName) {
            FieldInfo field = new FieldInfo();
            field.referrer = referrer;
            field.componentName = componentName;
            field.jndiName = jndiName;
            this.fields.add(field);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public int getRowCount() {
            return this.fields.size();
        }

        public Object getValueAt(int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            Object value = fieldInfo.getElement(col);
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 2;
        }

        public void setValueAt(Object value, int row, int col) {
            FieldInfo fieldInfo = (FieldInfo)this.fields.get(row);
            fieldInfo.setElement(col, value);
            Enumeration jndiComponents = ApplicationJndiInspector.this.application.getNamedReferencePairs().elements();
            NamedReferencePair jndiComponent = null;
            int index = 0;
            while (index <= row) {
                jndiComponent = (NamedReferencePair)jndiComponents.nextElement();
                ++index;
            }
            switch (col) {
                case 2: {
                    jndiComponent.getReferee().setJndiName((String)fieldInfo.getElement(col));
                    break;
                }
            }
        }

        private class FieldInfo {
            String referrer;
            String componentName;
            String jndiName;

            FieldInfo() {
            }

            Object getElement(int col) {
                String elem = null;
                switch (col) {
                    case 0: {
                        elem = this.referrer;
                        break;
                    }
                    case 1: {
                        elem = this.componentName;
                        break;
                    }
                    case 2: {
                        elem = this.jndiName;
                        break;
                    }
                }
                return elem;
            }

            void setElement(int col, Object elem) {
                switch (col) {
                    case 0: {
                        this.referrer = elem.toString();
                        break;
                    }
                    case 1: {
                        this.componentName = elem.toString();
                        break;
                    }
                    case 2: {
                        this.jndiName = elem.toString();
                        break;
                    }
                }
            }
        }
    }
}

