/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

class CustomMetalFileChooserUI
extends BasicFileChooserUI {
    private JPanel centerPanel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField filenameTextField;
    private JList list;
    private JButton approveButton;
    private JButton cancelButton;
    private JComboBox filterComboBox;
    private JPanel bodyPanel = null;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension hstrut25 = new Dimension(25, 1);
    private static final Dimension vstrut2 = new Dimension(1, 2);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Dimension vstrut15 = new Dimension(1, 15);
    private static final Dimension vstrut20 = new Dimension(1, 20);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 300;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 400;
    private static int MIN_HEIGHT = 200;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_MIN_WIDTH = 400;
    private static int LIST_MIN_HEIGHT = 100;
    private static Dimension LIST_MIN_SIZE = new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private static boolean dirchooser = false;
    JTextField editCell = null;
    int lastIndex = -1;
    boolean editing = false;
    int editX = 20;
    int editWidth = 200;
    static final int space = 10;

    public CustomMetalFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
        this.installIcons(filechooser);
    }

    private void cancelEdit() {
        this.editing = false;
        if (this.editCell != null) {
            this.list.remove(this.editCell);
        }
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc2) {
        return new DirectoryComboBoxModel();
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc2) {
        return new DirectoryComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected JPanel createList(JFileChooser fc2) {
        JPanel p2 = new JPanel(new BorderLayout());
        this.list = new JList();
        this.list.setCellRenderer(new FileRenderer());
        this.list.setModel(this.getModel());
        this.list.addListSelectionListener(this.createListSelectionListener(fc2));
        this.list.addMouseListener(this.createDoubleClickListener(fc2, this.list));
        JScrollPane scrollpane = new JScrollPane(this.list);
        p2.add((Component)scrollpane, "Center");
        return p2;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc2) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e10) {
                String prop = e10.getPropertyName();
                if (prop.equals("SelectedFileChangedProperty")) {
                    CustomMetalFileChooserUI.this.cancelEdit();
                    File f2 = (File)e10.getNewValue();
                    if (f2 != null) {
                        CustomMetalFileChooserUI.this.setFileName(CustomMetalFileChooserUI.this.getFileChooser().getName(f2));
                    } else {
                        CustomMetalFileChooserUI.this.setFileName(null);
                    }
                    CustomMetalFileChooserUI.this.setFileSelected();
                } else if (prop.equals("directoryChanged")) {
                    CustomMetalFileChooserUI.this.cancelEdit();
                    CustomMetalFileChooserUI.this.resetEditIndex();
                    CustomMetalFileChooserUI.this.clearIconCache();
                    CustomMetalFileChooserUI.this.list.clearSelection();
                    File currentDirectory = CustomMetalFileChooserUI.this.getFileChooser().getCurrentDirectory();
                    if (currentDirectory != null) {
                        CustomMetalFileChooserUI.this.directoryComboBoxModel.addItem(currentDirectory);
                        CustomMetalFileChooserUI.this.getNewFolderAction().setEnabled(currentDirectory.canWrite());
                    }
                } else if (prop.equals("fileFilterChanged") || prop.equals("fileSelectionChanged")) {
                    CustomMetalFileChooserUI.this.cancelEdit();
                    CustomMetalFileChooserUI.this.resetEditIndex();
                    CustomMetalFileChooserUI.this.clearIconCache();
                    CustomMetalFileChooserUI.this.list.clearSelection();
                } else if (prop == "AccessoryChangedProperty") {
                    if (CustomMetalFileChooserUI.this.getAccessoryPanel() != null) {
                        JComponent accessory;
                        if (e10.getOldValue() != null) {
                            CustomMetalFileChooserUI.this.getAccessoryPanel().remove((JComponent)e10.getOldValue());
                        }
                        if ((accessory = (JComponent)e10.getNewValue()) != null) {
                            CustomMetalFileChooserUI.this.getAccessoryPanel().add((Component)accessory, "Center");
                        }
                    }
                } else if (prop == "ApproveButtonTextChangedProperty" || prop == "DialogTypeChangedProperty") {
                    JFileChooser chooser = CustomMetalFileChooserUI.this.getFileChooser();
                    CustomMetalFileChooserUI.this.approveButton.setText(CustomMetalFileChooserUI.this.getApproveButtonText(chooser));
                    CustomMetalFileChooserUI.this.approveButton.setToolTipText(CustomMetalFileChooserUI.this.getApproveButtonToolTipText(chooser));
                    CustomMetalFileChooserUI.this.approveButton.setMnemonic(CustomMetalFileChooserUI.this.getApproveButtonMnemonic(chooser));
                } else if (prop.equals("ApproveButtonMnemonicChangedProperty")) {
                    CustomMetalFileChooserUI.this.approveButton.setMnemonic(CustomMetalFileChooserUI.this.getApproveButtonMnemonic(CustomMetalFileChooserUI.this.getFileChooser()));
                }
            }
        };
    }

    public static ComponentUI createUI(JComponent c10) {
        return new CustomMetalFileChooserUI((JFileChooser)c10);
    }

    public static ComponentUI createUI(JComponent c10, boolean directoryChooser) {
        dirchooser = directoryChooser;
        return new CustomMetalFileChooserUI((JFileChooser)c10);
    }

    public void ensureFileIsVisible(JFileChooser fc2, File f2) {
        if (this.getModel().contains(f2)) {
            this.list.ensureIndexIsVisible(this.getModel().indexOf(f2));
        }
    }

    protected JButton getApproveButton(JFileChooser fc2) {
        return this.approveButton;
    }

    public String getDirectoryName() {
        return null;
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public Dimension getMaximumSize(JComponent c10) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent c10) {
        return MIN_SIZE;
    }

    public Dimension getPreferredSize(JComponent c10) {
        return PREF_SIZE;
    }

    public void installComponents(JFileChooser fc2) {
        fc2.setLayout(new BoxLayout(fc2, 1));
        fc2.add(Box.createRigidArea(vstrut10));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        fc2.add(topPanel);
        fc2.add(Box.createRigidArea(vstrut10));
        JLabel l2 = new JLabel(this.lookInLabelText);
        l2.setDisplayedMnemonic(this.lookInLabelMnemonic);
        l2.setAlignmentX(0.0f);
        l2.setAlignmentY(0.5f);
        topPanel.add(Box.createRigidArea(hstrut10));
        topPanel.add(l2);
        topPanel.add(Box.createRigidArea(hstrut25));
        this.directoryComboBox = new JComboBox();
        this.directoryComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        l2.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc2);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc2));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        topPanel.add(this.directoryComboBox);
        topPanel.add(Box.createRigidArea(hstrut10));
        JButton b10 = new JButton(this.upFolderIcon);
        b10.setToolTipText(this.upFolderToolTipText);
        b10.getAccessibleContext().setAccessibleName(this.upFolderAccessibleName);
        b10.setAlignmentX(0.0f);
        b10.setAlignmentY(0.5f);
        b10.setMargin(shrinkwrap);
        b10.addActionListener(this.getChangeToParentDirectoryAction());
        topPanel.add(b10);
        topPanel.add(Box.createRigidArea(hstrut10));
        b10 = new JButton(this.homeFolderIcon);
        b10.setToolTipText(this.homeFolderToolTipText);
        b10.getAccessibleContext().setAccessibleName(this.homeFolderAccessibleName);
        b10.setAlignmentX(0.0f);
        b10.setAlignmentY(0.5f);
        b10.setMargin(shrinkwrap);
        b10.addActionListener(this.getGoHomeAction());
        topPanel.add(b10);
        topPanel.add(Box.createRigidArea(hstrut10));
        b10 = new JButton(this.newFolderIcon);
        b10.setToolTipText(this.newFolderToolTipText);
        b10.getAccessibleContext().setAccessibleName(this.newFolderAccessibleName);
        b10.setAlignmentX(0.0f);
        b10.setAlignmentY(0.5f);
        b10.setMargin(shrinkwrap);
        b10.addActionListener(this.getNewFolderAction());
        topPanel.add(b10);
        topPanel.add(Box.createRigidArea(hstrut10));
        JToggleButton tb = new JToggleButton(this.listViewIcon);
        tb.setToolTipText(this.listViewButtonToolTipText);
        tb.getAccessibleContext().setAccessibleName(this.listViewButtonAccessibleName);
        tb.setEnabled(false);
        tb.setAlignmentX(0.0f);
        tb.setAlignmentY(0.5f);
        tb.setMargin(shrinkwrap);
        topPanel.add(tb);
        tb = new JToggleButton(this.detailsViewIcon);
        tb.setToolTipText(this.detailsViewButtonToolTipText);
        tb.getAccessibleContext().setAccessibleName(this.detailsViewButtonAccessibleName);
        tb.setSelected(true);
        tb.setEnabled(false);
        tb.setAlignmentX(0.0f);
        tb.setAlignmentY(0.5f);
        tb.setMargin(shrinkwrap);
        topPanel.add(tb);
        topPanel.add(Box.createRigidArea(hstrut10));
        this.centerPanel = new JPanel(new BorderLayout());
        JPanel p2 = this.createList(fc2);
        p2.setMinimumSize(LIST_MIN_SIZE);
        this.centerPanel.add((Component)p2, "Center");
        this.centerPanel.add((Component)this.getAccessoryPanel(), "East");
        JComponent accessory = fc2.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        fc2.add(this.centerPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(Box.createRigidArea(hstrut10));
        fc2.add(Box.createRigidArea(vstrut10));
        fc2.add(bottomPanel);
        fc2.add(Box.createRigidArea(vstrut10));
        this.filenameTextField = new JTextField(){

            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        File f2 = fc2.getSelectedFile();
        if (f2 != null) {
            this.setFileName(fc2.getName(f2));
        }
        if (!dirchooser) {
            JPanel labelPanel = new JPanel();
            labelPanel.setLayout(new BoxLayout(labelPanel, 1));
            JLabel fnl = new JLabel(this.fileNameLabelText);
            fnl.setDisplayedMnemonic(this.fileNameLabelMnemonic);
            fnl.setAlignmentY(0.0f);
            labelPanel.add(fnl);
            labelPanel.add(Box.createRigidArea(vstrut20));
            JLabel ftl = new JLabel(this.filesOfTypeLabelText);
            ftl.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
            labelPanel.add(ftl);
            bottomPanel.add(labelPanel);
            bottomPanel.add(Box.createRigidArea(hstrut25));
            JPanel fileAndFilterPanel = new JPanel();
            fileAndFilterPanel.setLayout(new BoxLayout(fileAndFilterPanel, 1));
            fileAndFilterPanel.add(Box.createRigidArea(vstrut2));
            fnl.setLabelFor(this.filenameTextField);
            fileAndFilterPanel.add(this.filenameTextField);
            fileAndFilterPanel.add(Box.createRigidArea(vstrut15));
            this.filterComboBoxModel = this.createFilterComboBoxModel();
            fc2.addPropertyChangeListener(this.filterComboBoxModel);
            this.filterComboBox = new JComboBox(this.filterComboBoxModel);
            ftl.setLabelFor(this.filterComboBox);
            this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
            fileAndFilterPanel.add(this.filterComboBox);
            bottomPanel.add(fileAndFilterPanel);
            bottomPanel.add(Box.createRigidArea(hstrut10));
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        Dimension buttonSize = new Dimension();
        this.approveButton = new JButton(this.getApproveButtonText(fc2)){

            public Dimension getMaximumSize() {
                return ((CustomMetalFileChooserUI)CustomMetalFileChooserUI.this).approveButton.getPreferredSize().width > ((CustomMetalFileChooserUI)CustomMetalFileChooserUI.this).cancelButton.getPreferredSize().width ? CustomMetalFileChooserUI.this.approveButton.getPreferredSize() : CustomMetalFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc2));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc2));
        buttonPanel.add(this.approveButton);
        buttonPanel.add(Box.createRigidArea(vstrut10));
        this.cancelButton = new JButton(this.cancelButtonText){

            public Dimension getMaximumSize() {
                return ((CustomMetalFileChooserUI)CustomMetalFileChooserUI.this).approveButton.getPreferredSize().width > ((CustomMetalFileChooserUI)CustomMetalFileChooserUI.this).cancelButton.getPreferredSize().width ? CustomMetalFileChooserUI.this.approveButton.getPreferredSize() : CustomMetalFileChooserUI.this.cancelButton.getPreferredSize();
            }
        };
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        buttonPanel.add(this.cancelButton);
        bottomPanel.add(buttonPanel);
        bottomPanel.add(Box.createRigidArea(hstrut10));
    }

    public void installDefaults(JFileChooser fc2) {
        super.installDefaults(fc2);
    }

    protected void installStrings(JFileChooser fc2) {
        super.installStrings(fc2);
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString("FileChooser.lookInLabelText");
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString("FileChooser.fileNameLabelText");
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString("FileChooser.filesOfTypeLabelText");
        this.upFolderToolTipText = UIManager.getString("FileChooser.upFolderToolTipText");
        this.upFolderAccessibleName = UIManager.getString("FileChooser.upFolderAccessibleName");
        this.homeFolderToolTipText = UIManager.getString("FileChooser.homeFolderToolTipText");
        this.homeFolderAccessibleName = UIManager.getString("FileChooser.homeFolderAccessibleName");
        this.newFolderToolTipText = UIManager.getString("FileChooser.newFolderToolTipText");
        this.newFolderAccessibleName = UIManager.getString("FileChooser.newFolderAccessibleName");
        this.listViewButtonToolTipText = UIManager.getString("FileChooser.listViewButtonToolTipText");
        this.listViewButtonAccessibleName = UIManager.getString("FileChooser.listViewButtonAccessibleName");
        this.detailsViewButtonToolTipText = UIManager.getString("FileChooser.detailsViewButtonToolTipText");
        this.detailsViewButtonAccessibleName = UIManager.getString("FileChooser.detailsViewButtonAccessibleName");
    }

    public void rescanCurrentDirectory(JFileChooser fc2) {
        this.getModel().invalidateFileCache();
        this.getModel().validateFileCache();
    }

    private void resetEditIndex() {
        this.lastIndex = -1;
    }

    public void setDirectoryName(String dirname) {
    }

    private void setEditIndex(int i2) {
        this.lastIndex = i2;
    }

    public void setFileName(String filename) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(filename);
        }
    }

    void setFileSelected() {
        File f2 = this.getFileChooser().getSelectedFile();
        if (f2 != null && this.getModel().contains(f2)) {
            this.list.setSelectedIndex(this.getModel().indexOf(f2));
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        } else {
            this.list.clearSelection();
        }
    }

    public void uninstallUI(JComponent c10) {
        c10.removePropertyChangeListener(this.filterComboBoxModel);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c10);
    }

    public void valueChanged(ListSelectionEvent e10) {
        File f2 = this.getFileChooser().getSelectedFile();
        if (!e10.getValueIsAdjusting() && f2 != null && !this.getFileChooser().isTraversable(f2)) {
            this.setFileName(this.getFileChooser().getName(f2));
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        protected FileRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = CustomMetalFileChooserUI.this.getFileChooser().getName(file);
            this.setText(fileName);
            Icon icon = CustomMetalFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            if (isSelected) {
                CustomMetalFileChooserUI.this.editX = icon.getIconWidth() + 4;
            }
            return this;
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            File directory = (File)value;
            if (directory == null) {
                this.setText("");
                return this;
            }
            String fileName = CustomMetalFileChooserUI.this.getFileChooser().getName(directory);
            this.setText(fileName);
            int depth = 0;
            if (index != -1) {
                File f2 = directory;
                while (f2.getParent() != null) {
                    ++depth;
                    f2 = CustomMetalFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(f2.getParent());
                }
            }
            this.ii.icon = icon = CustomMetalFileChooserUI.this.getFileChooser().getIcon(directory);
            this.ii.depth = depth;
            this.setIcon(this.ii);
            return this;
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        public int getIconHeight() {
            return this.icon.getIconHeight();
        }

        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        public void paintIcon(Component c10, Graphics g2, int x2, int y2) {
            this.icon.paintIcon(c10, g2, x2 + this.depth * 10, y2);
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        int topIndex = -1;
        int pathCount = 0;
        File selectedDirectory = null;

        public DirectoryComboBoxModel() {
            File[] roots = CustomMetalFileChooserUI.this.getFileChooser().getFileSystemView().getRoots();
            int i2 = 0;
            while (i2 < roots.length) {
                this.directories.addElement(roots[i2]);
                ++i2;
            }
            this.addItem(CustomMetalFileChooserUI.this.getFileChooser().getCurrentDirectory());
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            if (this.selectedDirectory != null) {
                this.removeSelectedDirectory();
            }
            File canonical = null;
            try {
                canonical = CustomMetalFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(directory.getCanonicalPath());
            }
            catch (IOException iOException) {
                return;
            }
            File f2 = canonical;
            Vector<File> path = new Vector<File>(10);
            while (f2.getParent() != null) {
                path.addElement(f2);
                if (this.directories.contains(f2)) {
                    this.topIndex = this.directories.indexOf(f2);
                }
                f2 = CustomMetalFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(f2.getParent());
            }
            this.pathCount = path.size();
            if (this.topIndex < 0) {
                if (this.directories.contains(f2)) {
                    this.topIndex = this.directories.indexOf(f2);
                } else {
                    this.directories.addElement(f2);
                }
            }
            int i2 = 0;
            while (i2 < path.size()) {
                this.directories.insertElementAt(path.elementAt(i2), this.topIndex + 1);
                ++i2;
            }
            this.setSelectedItem(canonical);
        }

        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        private void removeSelectedDirectory() {
            if (this.topIndex >= 0) {
                int i2 = this.topIndex;
                while (i2 < this.topIndex + this.pathCount) {
                    this.directories.removeElementAt(this.topIndex + 1);
                    ++i2;
                }
            }
            this.topIndex = -1;
            this.pathCount = 0;
            this.selectedDirectory = null;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            FileFilter filter = (FileFilter)value;
            if (filter != null) {
                this.setText(filter.getDescription());
            }
            return this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = CustomMetalFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return CustomMetalFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }

        public Object getSelectedItem() {
            FileFilter currentFilter = CustomMetalFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                int i2 = 0;
                while (i2 < this.filters.length) {
                    if (this.filters[i2] == currentFilter) {
                        found = true;
                    }
                    ++i2;
                }
                if (!found) {
                    CustomMetalFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return CustomMetalFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public void propertyChange(PropertyChangeEvent e10) {
            String prop = e10.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e10.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object filter) {
            if (filter != null) {
                CustomMetalFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        public void actionPerformed(ActionEvent e10) {
            CustomMetalFileChooserUI.this.getFileChooser().setCurrentDirectory((File)CustomMetalFileChooserUI.this.directoryComboBox.getSelectedItem());
        }
    }
}

