/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class InspectorTable
extends JTable {
    private JTextField tableTextEditor = new JTextField();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Integer;

    public InspectorTable() {
        this.setupInspectorTable();
    }

    public InspectorTable(TableModel model) {
        super(model);
        this.setupInspectorTable();
    }

    public InspectorTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.setupInspectorTable();
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void processKeyEvent(KeyEvent ke) {
        JTextComponent c10;
        super.processKeyEvent(ke);
        TableCellEditor editor = this.getCellEditor();
        if (editor instanceof DefaultCellEditor && ((DefaultCellEditor)editor).getComponent() instanceof JTextComponent && !(c10 = (JTextComponent)((DefaultCellEditor)editor).getComponent()).getCaret().isVisible()) {
            c10.getCaret().setVisible(true);
        }
    }

    private void setupInspectorTable() {
        this.tableTextEditor.setCursor(Cursor.getPredefinedCursor(2));
        DefaultCellEditor tableEditor = new DefaultCellEditor(this.tableTextEditor);
        this.setDefaultEditor(class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = InspectorTable.class$("java.lang.Object")), tableEditor);
        final WholeNumberField integerField = new WholeNumberField(0, 5);
        integerField.setHorizontalAlignment(4);
        DefaultCellEditor integerEditor = new DefaultCellEditor(integerField){

            public Object getCellEditorValue() {
                return new Integer(integerField.getValue());
            }
        };
        this.setDefaultEditor(class$java$lang$Integer != null ? class$java$lang$Integer : (class$java$lang$Integer = InspectorTable.class$("java.lang.Integer")), integerEditor);
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
    }

    class WholeNumberField
    extends JTextField {
        private Toolkit toolkit = Toolkit.getDefaultToolkit();
        private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

        public WholeNumberField(int value, int columns) {
            super(columns);
            this.integerFormatter.setParseIntegerOnly(true);
            this.setValue(value);
        }

        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        public int getValue() {
            int retVal = 0;
            try {
                retVal = this.integerFormatter.parse(this.getText()).intValue();
            }
            catch (ParseException parseException) {
                this.toolkit.beep();
            }
            return retVal;
        }

        public void setValue(int value) {
            this.setText(this.integerFormatter.format(value));
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            protected WholeNumberDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j2 = 0;
                int i2 = 0;
                while (i2 < result.length) {
                    if (Character.isDigit(source[i2])) {
                        result[j2++] = source[i2];
                    } else {
                        WholeNumberField.this.toolkit.beep();
                        System.err.println("insertString: " + source[i2]);
                    }
                    ++i2;
                }
                super.insertString(offs, new String(result, 0, j2), a);
            }
        }
    }
}

