/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.tools.deployment.ui.Inspector;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.Wand;
import com.sun.enterprise.tools.deployment.ui.descriptor.MyTableModel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.Set;
import javax.help.CSH;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class JndiNamesInspector
extends JPanel
implements Inspector,
TableInspector,
Wand {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$JndiNamesInspector != null ? class$com$sun$enterprise$tools$deployment$ui$JndiNamesInspector : (class$com$sun$enterprise$tools$deployment$ui$JndiNamesInspector = JndiNamesInspector.class$("com.sun.enterprise.tools.deployment.ui.JndiNamesInspector")));
    private Application application;
    private NotificationListener eventAdaptor;
    private NotificationListener tableEventAdaptor;
    private InspectorTable jndiNamesTable;
    private String[] COLUMN_LABELS = new String[]{localStrings.getLocalString("jndinamesinspector.component_name", "Component"), localStrings.getLocalString("jndinamesinspector.jndi_name", "JNDI name")};
    private String TITLE = localStrings.getLocalString("jndinamesinspector.title", "Names for the Name Service");
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$JndiNamesInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Descriptor;

    JndiNamesInspector(String labelString, Application application) {
        CSH.setHelpIDString((Component)this, (String)localStrings.getLocalString("jndinamesinspector.help_id_string", "Deploy_Provide_JNDI_Names_Inspector"));
        this.application = application;
        this.setBorder(new TitledBorder(LineBorder.createGrayLineBorder(), labelString));
        this.eventAdaptor = new NotificationListener(){

            public void notification(NotificationEvent ne) {
                JndiNamesInspector.this.refresh();
            }
        };
        this.tableEventAdaptor = new NotificationListener(){

            public void notification(NotificationEvent ne) {
                JndiNamesInspector.this.tableChanged();
            }
        };
        Object[][] data = new Object[][]{{localStrings.getLocalString("jndinamesinspector.this_ejb", "this ejb"), localStrings.getLocalString("jndinamesinspector.data_jndi_name", "jndi name")}};
        this.jndiNamesTable = new InspectorTable(new MyTableModel(data, this.COLUMN_LABELS));
        this.jndiNamesTable.setAutoResizeMode(4);
        TableColumn descriptorTableColumn = this.jndiNamesTable.getColumn(this.COLUMN_LABELS[0]);
        this.jndiNamesTable.setDefaultRenderer(class$com$sun$enterprise$deployment$Descriptor != null ? class$com$sun$enterprise$deployment$Descriptor : (class$com$sun$enterprise$deployment$Descriptor = JndiNamesInspector.class$("com.sun.enterprise.deployment.Descriptor")), new DescriptorTableCellRenderer());
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.jndiNamesTable));
        this.refresh();
    }

    public boolean canExit() {
        return true;
    }

    public boolean canLeaveBackward() {
        return true;
    }

    public boolean canLeaveForward() {
        boolean canLeave = false;
        Set jndiComponents = this.application.getNamedDescriptors();
        Iterator itr = jndiComponents.iterator();
        while (itr.hasNext()) {
            NamedDescriptor namedComponent = (NamedDescriptor)itr.next();
            if (!"".equals(namedComponent.getJndiName())) continue;
            JOptionPane.showMessageDialog(this, String.valueOf(((Descriptor)((Object)namedComponent)).getName()) + " " + localStrings.getLocalString("jndinamesinspector.requires_jndi_name", "requires a JNDI name"));
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void editingStopped() {
        this.jndiNamesTable.editingStopped(new ChangeEvent(this));
    }

    public void refresh() {
        Set jndiComponents = this.application.getNamedDescriptors();
        Object[][] data = new Object[jndiComponents.size()][2];
        int row = 0;
        Iterator itr = jndiComponents.iterator();
        while (itr.hasNext()) {
            NamedDescriptor nextNamedDescriptor = (NamedDescriptor)itr.next();
            data[row][0] = nextNamedDescriptor;
            data[row][1] = nextNamedDescriptor.getJndiName();
            ++row;
        }
        MyTableModel tableModel = new MyTableModel(data, this.COLUMN_LABELS);
        tableModel.addNotificationListener(this.tableEventAdaptor);
        this.jndiNamesTable.setModel(tableModel);
        this.jndiNamesTable.sizeColumnsToFit(0);
    }

    public void setObject(Object object) {
        if (object instanceof Application) {
            this.application = (Application)object;
            this.refresh();
        }
    }

    public void setVisible(boolean isVisible) {
        if (!isVisible) {
            this.application.removeNotificationListener(this.eventAdaptor);
        }
        super.setVisible(false);
    }

    public void tableChanged() {
        TableModel model = this.jndiNamesTable.getModel();
        int i2 = 0;
        while (i2 < model.getRowCount()) {
            NamedDescriptor nextNamedDescriptor = (NamedDescriptor)model.getValueAt(i2, 0);
            String jndiName = (String)model.getValueAt(i2, 1);
            nextNamedDescriptor.setJndiName(jndiName);
            ++i2;
        }
        this.application.changed();
    }

    class DescriptorTableCellRenderer
    implements TableCellRenderer {
        DescriptorTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel renderingComponent = null;
            renderingComponent = value instanceof EjbDescriptor ? new JLabel(((Descriptor)value).getName(), UIUtils.getImageIconFor(UIUtils.EJB_ICON), 2) : (value instanceof Descriptor ? new JLabel(((Descriptor)value).getName()) : new JLabel(value.toString()));
            return renderingComponent;
        }
    }
}

