/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.TableInspector;
import com.sun.enterprise.tools.deployment.ui.descriptor.RolesDialog;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.help.CSH;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class RoleRefsInspector
extends JPanel
implements TableInspector {
    RoleRefsTable roleRefsTable;
    JButton addPB;
    JButton delPB;
    String inspectorMode = "DeveloperMode";
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$RoleRefsInspector != null ? class$com$sun$enterprise$tools$deployment$ui$descriptor$RoleRefsInspector : (class$com$sun$enterprise$tools$deployment$ui$descriptor$RoleRefsInspector = RoleRefsInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.RoleRefsInspector")));
    private static String helpSetMapID = "CIEditRole";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$RoleRefsInspector;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public RoleRefsInspector() {
        CSH.setHelpIDString((Component)this, (String)helpSetMapID);
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        GridBagConstraints c10 = new GridBagConstraints();
        c10.fill = 1;
        c10.weightx = 0.5;
        JPanel roleNamesPanel = new JPanel();
        roleNamesPanel.setBorder(new TitledBorder(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.rolesnamesrefrencedincode", "Role names referenced in code")));
        GridBagLayout gb2 = new GridBagLayout();
        roleNamesPanel.setLayout(gb2);
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb1.setConstraints(roleNamesPanel, c10);
        this.add(roleNamesPanel);
        this.roleRefsTable = new RoleRefsTable(new RoleRefsTableModel());
        this.roleRefsTable.setAutoResizeMode(4);
        JScrollPane roleRefsTablePane = new JScrollPane(this.roleRefsTable);
        roleRefsTablePane.setPreferredSize(new Dimension(400, 150));
        this.roleRefsTable.setSelectionMode(0);
        ListSelectionModel roleNamesSelectionModel = this.roleRefsTable.getSelectionModel();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        gb2.setConstraints(roleRefsTablePane, c10);
        roleNamesPanel.add(roleRefsTablePane);
        JPanel roleNamesButtonPanel = new JPanel();
        roleNamesButtonPanel.setLayout(new GridLayout(3, 1, 5, 5));
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.weightx = 0.0;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 0;
        c10.anchor = 13;
        gb2.setConstraints(roleNamesButtonPanel, c10);
        roleNamesPanel.add(roleNamesButtonPanel);
        c10.fill = 1;
        c10.anchor = 10;
        this.addPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.addbutton", "Add"));
        roleNamesButtonPanel.add(this.addPB);
        this.addPB.setMnemonic('A');
        this.addPB.setActionCommand("Add");
        this.addPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                RoleRefsInspector.this.addRoleAction();
            }
        });
        this.delPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deletebutton", "Delete..."));
        roleNamesButtonPanel.add(this.delPB);
        this.delPB.setMnemonic('D');
        this.delPB.setActionCommand("Delete");
        this.delPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                RoleRefsInspector.this.deleteRoleAction();
            }
        });
        JButton editRolesPB = new JButton(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.rolebutton", "Edit Roles"));
        roleNamesButtonPanel.add(editRolesPB);
        editRolesPB.setMnemonic('E');
        editRolesPB.setActionCommand("Edit Roles");
        editRolesPB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                RoleRefsInspector.this.editRolesAction();
            }
        });
    }

    private void addRoleAction() {
        this.editingStopped();
        RoleReference rr = new RoleReference("", "");
        this.addRoleReference(rr);
    }

    protected abstract void addRoleReference(RoleReference var1);

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void deleteRoleAction() {
        this.editingStopped();
        RoleRefsTableModel model = (RoleRefsTableModel)this.roleRefsTable.getModel();
        int index = this.roleRefsTable.getSelectedRow();
        if (index >= 0) {
            int n2 = JOptionPane.showConfirmDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.surewanttodeleterole", "Are you sure you want to delete selected role reference?"), localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deleterole", "Delete role"), 0);
            if (n2 == 0) {
                this.removeRoleReference(model.getRow(index));
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.firstselectrolefromlist", "You must first select a role from the list"));
        }
    }

    private void editRolesAction() {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame != null ? class$javax$swing$JFrame : (class$javax$swing$JFrame = RoleRefsInspector.class$("javax.swing.JFrame")), this);
        RolesDialog rolesDialog = new RolesDialog(frame, true);
        rolesDialog.setObject(((WebComponentDescriptorImpl)this.getDescriptor()).getWebBundleDescriptor());
        rolesDialog.setLocationRelativeTo(this);
        ((Component)rolesDialog).setVisible(true);
    }

    public void editingStopped() {
        this.roleRefsTable.editingStopped(new ChangeEvent(this));
    }

    protected abstract Descriptor getDescriptor();

    protected abstract ArrayList getRoleReferences();

    protected abstract Set getRoles();

    public void refresh() {
        this.roleRefsTable.setModel(new RoleRefsTableModel());
        this.roleRefsTable.setupRolesColumn();
        this.roleRefsTable.sizeColumnsToFit(0);
    }

    protected abstract void removeRoleReference(RoleReference var1);

    public void setInspectorMode(String mode) {
        this.inspectorMode = mode;
    }

    public void setVisible(boolean b10) {
        if (!b10) {
            this.editingStopped();
        }
        super.setVisible(b10);
    }

    private class RoleRefsTable
    extends InspectorTable {
        public RoleRefsTable(RoleRefsTableModel model) {
            super(model);
            this.setSelectionMode(0);
        }

        public void setupRolesColumn() {
            TableColumn typeColumn = this.getColumnModel().getColumn(1);
            JComboBox<String> typeComboBox = new JComboBox<String>();
            Iterator itr = RoleRefsInspector.this.getRoles().iterator();
            while (itr.hasNext()) {
                Role r2 = (Role)itr.next();
                typeComboBox.addItem(r2.getName());
            }
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setToolTipText(localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.clicktoeditrolename", "Click to edit role name"));
            typeColumn.setCellRenderer(renderer);
        }
    }

    public class RoleRefsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{RoleRefsInspector.access$3().getLocalString("enterprise.tools.deployment.ui.descriptor.codedname", "Coded name"), RoleRefsInspector.access$3().getLocalString("enterprise.tools.deployment.ui.descriptor.rolename", "Role name")};

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public RoleReference getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (RoleReference)RoleRefsInspector.this.getRoleReferences().get(index);
        }

        public int getRowCount() {
            return RoleRefsInspector.this.getRoleReferences().size();
        }

        public Object getValueAt(int row, int col) {
            RoleReference roleReference = this.getRow(row);
            String value = null;
            switch (col) {
                case 0: {
                    value = roleReference.getName();
                    break;
                }
                case 1: {
                    value = roleReference.getValue();
                    break;
                }
            }
            return value;
        }

        public boolean isCellEditable(int row, int col) {
            return row >= 0 && row < this.getRowCount() && col >= 0 && col < this.getColumnCount();
        }

        public void setValueAt(Object value, int row, int col) {
            RoleReference roleReference = this.getRow(row);
            if (roleReference == null) {
                return;
            }
            switch (col) {
                case 0: {
                    roleReference.setName(value.toString());
                    RoleRefsInspector.this.getDescriptor().changed();
                    break;
                }
                case 1: {
                    if (value == null) break;
                    roleReference.setValue(value.toString());
                    RoleRefsInspector.this.getDescriptor().changed();
                    break;
                }
            }
        }
    }
}

