/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;
import java.util.Set;

public class AppSecurityRole
implements AppCheck {
    boolean debug = Verifier.getDebug();
    LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public Result check(Application descriptor) {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + this.smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(this.smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (!descriptor.getRoles().isEmpty()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Set sc = descriptor.getRoles();
            Iterator itr = sc.iterator();
            while (itr.hasNext()) {
                foundIt = false;
                Role role = (Role)itr.next();
                String roleName = role.getName();
                foundIt = roleName.length() > 0;
                if (foundIt) {
                    result.addGoodDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "The security role name [ {0} ] found within application [ {1} ]", new Object[]{roleName, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: The security role name [ {0} ] not found within application [ {1} ]", new Object[]{roleName, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(this.smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no role-name elements within the application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

