/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Iterator;

public class AppWebContext
implements AppCheck {
    boolean debug = Verifier.getDebug();

    public Result check(Application descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor.getWebBundleDescriptors().size() > 0) {
            boolean oneWarning = false;
            Iterator itr = descriptor.getWebBundleDescriptors().iterator();
            while (itr.hasNext()) {
                WebBundleDescriptor wbd = (WebBundleDescriptor)itr.next();
                if (wbd.getContextRoot().equals("")) {
                    if (!oneWarning) {
                        oneWarning = true;
                    }
                    result.addWarningDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".warning", "Warning: [ {0} ] has blank context root defined within application [ {1} ]", new Object[]{wbd.getName(), descriptor.getName()}));
                    continue;
                }
                result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] has context root defined as [ {1} ] within application[ {2} ].", new Object[]{wbd.getName(), wbd.getContextRoot(), descriptor.getName()}));
            }
            if (oneWarning) {
                result.setStatus(2);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no web components in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

