/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient.elements;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class AppClientEjbLinkOnlyOne
implements AppClientCheck {
    boolean debug = Verifier.getDebug();

    public Result check(ApplicationClientDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        int resolved = 0;
        boolean oneFailed = false;
        int na = 0;
        if (Verifier.getEarFile() == null) {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".no_ear", "This Application Client [ {0} ] is not part of a J2EE Archive.", new Object[]{descriptor.getName()}));
            return result;
        }
        String applicationName = null;
        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            Iterator itr = descriptor.getEjbReferenceDescriptors().iterator();
            while (itr.hasNext()) {
                EjbReferenceDescriptor nextEjbReference = (EjbReferenceDescriptor)itr.next();
                if (nextEjbReference.isLinked()) {
                    String ejb_link;
                    block20: {
                        ejb_link = nextEjbReference.getLinkName();
                        try {
                            File file = new File(Verifier.getEarFile());
                            Application application = ApplicationArchivist.open(file);
                            applicationName = application.getName();
                            File tmpFile = new File(System.getProperty("java.io.tmpdir"));
                            tmpFile = new File(tmpFile, "verifier-tmp.tmp");
                            Set ejbBundles = application.getEjbBundleDescriptors();
                            Iterator ejbBundlesIterator = ejbBundles.iterator();
                            EjbBundleDescriptor ejbBundle = null;
                            while (ejbBundlesIterator.hasNext()) {
                                ejbBundle = (EjbBundleDescriptor)ejbBundlesIterator.next();
                                application.getApplicationArchivist().extractBundleToFile(ejbBundle, tmpFile);
                                Iterator itr2 = ejbBundle.getEjbs().iterator();
                                while (itr2.hasNext()) {
                                    EjbDescriptor ejbDescriptor = (EjbDescriptor)itr2.next();
                                    if (!ejbDescriptor.getName().equals(ejb_link)) continue;
                                    ++resolved;
                                    if (!this.debug) continue;
                                    System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug", "ejb-link [ {0} ] found same value as EJB [ {1} ] for application client [ {2} ]", new Object[]{ejb_link, ejbDescriptor.getName(), descriptor.getName()}));
                                }
                            }
                        }
                        catch (IOException e10) {
                            if (this.debug) {
                                System.out.println("[" + this.getClass() + "] Error: " + e10.getMessage());
                            }
                            if (!oneFailed) {
                                oneFailed = true;
                            }
                        }
                        catch (ArchiveException e11) {
                            if (this.debug) {
                                System.out.println("[" + this.getClass() + "] Error: " + e11.getMessage());
                            }
                            if (oneFailed) break block20;
                            oneFailed = true;
                        }
                    }
                    if (resolved != 1) {
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: ejb-link [ {0} ] did not find only one corresponding EJB value [ {1} ] for application client [ {2} ]", new Object[]{ejb_link, ejb_link, descriptor.getName()}));
                        continue;
                    }
                    if (resolved != true) continue;
                    resolved = 0;
                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "ejb-link [ {0} ] found only one corresponding EJB value [ {1} ] for application client [ {2} ]", new Object[]{ejb_link, ejb_link, descriptor.getName()}));
                    continue;
                }
                result.addNaDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "Warning:  Cannot verify the existence of an ejb reference [ {0} ] to external bean within different .ear file.", new Object[]{nextEjbReference.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == descriptor.getEjbReferenceDescriptors().size()) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
            File tmpFile = new File(System.getProperty("java.io.tmpdir"));
            tmpFile = new File(tmpFile, "verifier-tmp.tmp");
            tmpFile.delete();
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "There are no ejb references to other beans within this application client [ {0} ]", new Object[]{descriptor.getName()}));
        return result;
    }
}

