/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.beanclass;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class EjbClassConstructor
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                boolean foundOne = false;
                Constructor<?>[] constructors = c10.getConstructors();
                int i2 = 0;
                while (i2 < constructors.length) {
                    Class<?>[] constructorParameterTypes;
                    int modifiers = constructors[i2].getModifiers();
                    if (Modifier.isPublic(modifiers) && (constructorParameterTypes = constructors[i2].getParameterTypes()).length <= 0) {
                        foundOne = true;
                        break;
                    }
                    ++i2;
                }
                if (foundOne) {
                    result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "Valid: This bean [ {0} ] has a public constructor method with no  \n parameters.  Enterprise beans must have a public constructor  \n method with no parameters.", new Object[]{descriptor.getEjbClassName()}));
                } else {
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: There is no public constructor method with no parameters\n defined within bean [ {0} ].  Enterprise beans must have a \n public constructor methods with no parameters.", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

