/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class EjbFinderMethodPublic
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                boolean ejbFindMethodFound = false;
                boolean isPublic = false;
                boolean oneFailed = false;
                int findMethodModifiers = 0;
                int foundAtLeastOne = 0;
                try {
                    JarClassLoader jcl = JarClassLoader.getInstance();
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        int j2 = 0;
                        while (j2 < ejbFinderMethods.length) {
                            isPublic = false;
                            ejbFindMethodFound = false;
                            if (ejbFinderMethods[j2].getName().startsWith("ejbFind")) {
                                ejbFindMethodFound = true;
                                ++foundAtLeastOne;
                                findMethodModifiers = ejbFinderMethods[j2].getModifiers();
                                if (Modifier.isPublic(findMethodModifiers)) {
                                    isPublic = true;
                                }
                                if (ejbFindMethodFound && isPublic) {
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "A public [ {0} ] method was found.", new Object[]{ejbFinderMethods[j2].getName()}));
                                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                                } else if (ejbFindMethodFound && !isPublic) {
                                    oneFailed = true;
                                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j2].getName()}));
                                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: An [ {0} ] method was found, but was not public.", new Object[]{ejbFinderMethods[j2].getName()}));
                                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                                }
                            }
                            ++j2;
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && foundAtLeastOne == 0);
                    if (foundAtLeastOne == 0) {
                        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable1", "No ejbFind<METHOD> method was found in [ {0} ] class.", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (foundAtLeastOne == 0) {
                    result.setStatus(3);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

