/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findbyprimarykey;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;

public class HomeInterfaceFindByPrimaryKeyReturn
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbEntityDescriptor) {
            boolean findByPrimaryKeyMethodFound = false;
            boolean oneFailed = false;
            boolean returnValueValid = false;
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> homeInterfaceClass = jcl.loadClass(descriptor.getHomeClassName());
                Method[] ejbFinderMethods = homeInterfaceClass.getDeclaredMethods();
                Class<?> rc = jcl.loadClass(descriptor.getRemoteClassName());
                int j2 = 0;
                while (j2 < ejbFinderMethods.length) {
                    returnValueValid = false;
                    if (ejbFinderMethods[j2].getName().equals("findByPrimaryKey")) {
                        Class<?> returnByPrimaryKeyValue;
                        if (!findByPrimaryKeyMethodFound) {
                            findByPrimaryKeyMethodFound = true;
                        }
                        if ((returnByPrimaryKeyValue = ejbFinderMethods[j2].getReturnType()).getName().equals(rc.getName()) && !returnByPrimaryKeyValue.getName().equals("java.util.Collection") && !returnByPrimaryKeyValue.getName().equals("java.util.Enumeration")) {
                            returnValueValid = true;
                        }
                        if (findByPrimaryKeyMethodFound && returnValueValid) {
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j2].getName()}));
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "A findByPrimaryKey method was found with valid return type."));
                            result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                            break;
                        }
                        if (!findByPrimaryKeyMethodFound || returnValueValid) break;
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home interface [ {0} ] Finder Method [ {1} ]", new Object[]{homeInterfaceClass.getName(), ejbFinderMethods[j2].getName()}));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: A findByPrimaryKey method was found, but with invalid return type."));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                        break;
                    }
                    ++j2;
                }
                if (!findByPrimaryKeyMethodFound) {
                    oneFailed = true;
                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug3", "For Home interface [ {0} ] ", new Object[]{homeInterfaceClass.getName()}));
                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed1", "Error: No findByPrimaryKey method was found in home interface class [ {0} ].", new Object[]{homeInterfaceClass.getName()}));
                    result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable.", new Object[]{descriptor.getHomeClassName()}));
                oneFailed = true;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

