/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.homeintf;

import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;

public class HomeInterfaceRmiIIOPArgs
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(descriptor.getHomeClassName());
                Method[] methods = c10.getDeclaredMethods();
                boolean isLegalRMIIIOP = false;
                int i2 = 0;
                while (i2 < methods.length) {
                    isLegalRMIIIOP = false;
                    Class[] methodParameterTypes = methods[i2].getParameterTypes();
                    if (RmiIIOPUtils.isValidRmiIIOPParameters(methodParameterTypes)) {
                        isLegalRMIIIOP = true;
                    }
                    if (isLegalRMIIIOP) {
                        result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] properly declares method with valid RMI-IIOP parameters.", new Object[]{methods[i2].getName()}));
                        result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                    } else if (!isLegalRMIIIOP) {
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] declares method with invalid RMI-IIOP parameters.", new Object[]{methods[i2].getName()}));
                        result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug2", "=============================="));
                    }
                    ++i2;
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                oneFailed = true;
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
            }
            catch (Throwable t2) {
                Verifier.debug(t2);
                oneFailed = true;
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedThrowable", "Error: [ {0} ] class encountered [ {1} ]. Cannot access methods of class [ {2} ] within [ {3} ].", new Object[]{descriptor.getHomeClassName(), t2.toString(), t2.getMessage(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

