/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.homeintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class HomeInterfaceSuperInterface
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            try {
                JarClassLoader jcl = JarClassLoader.getInstance();
                Class<?> c10 = jcl.loadClass(descriptor.getHomeClassName());
                boolean validHomeInterface = false;
                block2: do {
                    Class<?>[] interfaces = c10.getInterfaces();
                    int i2 = 0;
                    while (i2 < interfaces.length) {
                        if (this.debug) {
                            System.out.println(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".debug1", "Interface [ {0} ]", new Object[]{interfaces[i2].getName()}));
                        }
                        if (RmiIIOPUtils.isValidRmiIIOPInterface(interfaces[i2])) {
                            if (interfaces[i2].getName().equals("javax.ejb.EJBHome")) {
                                validHomeInterface = true;
                                continue block2;
                            }
                        } else {
                            oneFailed = true;
                            result.addErrorDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans home interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces .  [ {1} ] is not a valid home interface.", new Object[]{interfaces[i2].getName(), descriptor.getHomeClassName()}));
                        }
                        ++i2;
                    }
                } while ((c10 = c10.getSuperclass()) != null && !validHomeInterface);
                if (validHomeInterface) {
                    result.addGoodDetails(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] properly conforms to rules of RMI-IIOP for superinterfaces.", new Object[]{descriptor.getHomeClassName()}));
                }
            }
            catch (ClassNotFoundException e10) {
                Verifier.debug(e10);
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
                oneFailed = true;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return result;
    }
}

