/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.util.LocalStringManagerImpl;

public class TransactionTypeBeanManaged
implements EjbCheck {
    boolean debug = Verifier.getDebug();

    public Result check(EjbDescriptor descriptor) {
        String transactionType;
        LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", String.valueOf(String.valueOf(this.getClass())) + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        if (EjbDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType = descriptor.getTransactionType())) {
            if (descriptor instanceof EjbSessionDescriptor) {
                result.passed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".passed", "[ {0} ] is valid transactionType within Session bean [ {1} ]", new Object[]{transactionType, descriptor.getName()}));
            } else if (descriptor instanceof EjbEntityDescriptor) {
                result.failed(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".failedException", "Error: [ {0} ] is not valid transactionType within entity bean [ {1} ]", new Object[]{transactionType, descriptor.getName()}));
            }
            return result;
        }
        if (EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
            result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "Expected [ {0} ] transaction demarcation, but [ {1} ] bean has [ {2} ] transaction demarcation.", new Object[]{EjbDescriptor.BEAN_TRANSACTION_TYPE, descriptor.getName(), EjbDescriptor.CONTAINER_TRANSACTION_TYPE}));
            return result;
        }
        result.notApplicable(smh.getLocalString(String.valueOf(this.getClass().getName()) + ".notApplicable", "Expected [ {0} ] transaction demarcation, but [ {1} ] bean has [ {2} ] transaction demarcation.", new Object[]{EjbDescriptor.BEAN_TRANSACTION_TYPE, descriptor.getName(), transactionType}));
        return result;
    }
}

